/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.interceptor;

import com.dbeaver.remote.client.RefreshSMSessionFunction;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.utils.CommonUtils;

public class DCAuthInterceptor
implements Interceptor {
    @Nullable
    private final RefreshSMSessionFunction authRefreshFunction;
    @NotNull
    private final SMCredentialsProvider smCredentialsProvider;

    public DCAuthInterceptor(@Nullable RefreshSMSessionFunction authRefreshFunction, @NotNull SMCredentialsProvider smCredentialsProvider) {
        this.authRefreshFunction = authRefreshFunction;
        this.smCredentialsProvider = smCredentialsProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(this.addDCAccessTokenToHeader(request));
        if (response.code() == 440 && this.authRefreshFunction != null) {
            try {
                this.authRefreshFunction.refresh();
                response.close();
                response = chain.proceed(this.addDCAccessTokenToHeader(request));
            }
            catch (DBException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return response;
    }

    private Request addDCAccessTokenToHeader(Request request) {
        if (this.smCredentialsProvider.getActiveUserCredentials() == null) {
            return request;
        }
        SMCredentials smCredentials = this.smCredentialsProvider.getActiveUserCredentials();
        if (CommonUtils.isEmpty((String)smCredentials.getSmAccessToken())) {
            return request;
        }
        return request.newBuilder().header("Authorization", smCredentials.getSmAccessToken()).build();
    }
}

