/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.GsonUtils;
import com.dbeaver.remote.client.RestExceptionHandler;
import com.dbeaver.remote.client.interceptor.RetryRequestInterceptor;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.security.exception.SMAccessTokenExpiredException;
import org.jkiss.dbeaver.model.security.exception.SMRefreshTokenExpiredException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractRemoteClient {
    private static final Log log = Log.getLog(AbstractRemoteClient.class);
    public static final int TOKEN_EXPIRED_ERROR_CODE = 440;
    public static final int REFRESH_TOKEN_EXPIRED_ERROR_CODE = 441;
    public static final int DEFAULT_REQUEST_RETRIES = 60;
    private static final Gson gson = GsonUtils.gsonBuilder().create();
    private static final List<RestExceptionHandler> exceptionHandlers = new ArrayList<RestExceptionHandler>();
    private static boolean runRequestsInAsyncMode;
    private final OkHttpClient httpClient;
    private final String apiUrl;

    public static boolean isRunRequestsInAsyncMode() {
        return runRequestsInAsyncMode;
    }

    public static void setRunRequestsInAsyncMode(boolean runRequestsInAsyncMode) {
        AbstractRemoteClient.runRequestsInAsyncMode = runRequestsInAsyncMode;
    }

    public static void addExceptionHandler(@NotNull RestExceptionHandler handler) {
        exceptionHandlers.add(handler);
    }

    public static void removeExceptionHandler(@NotNull RestExceptionHandler handler) {
        exceptionHandlers.remove(handler);
    }

    public AbstractRemoteClient(String apiUrl, List<Interceptor> interceptors) {
        this(apiUrl, 5000, 120000, interceptors);
    }

    public AbstractRemoteClient(String apiUrl, int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        this.apiUrl = apiUrl;
        this.httpClient = this.buildClient(connectTimeout, readTimeout, interceptors);
    }

    @NotNull
    private OkHttpClient buildClient(int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient().newBuilder();
        if (connectTimeout > 0) {
            httpClientBuilder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (readTimeout > 0) {
            httpClientBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        httpClientBuilder.addInterceptor((Interceptor)new RetryRequestInterceptor(this, 60, this.apiUrl));
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        return httpClientBuilder.build();
    }

    public boolean isOmitRequestRetry(URL url) {
        return false;
    }

    protected OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected <T> T executeGetRequest(String endpointUrl, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, parameters, BodyConverter.JSON, type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, MediaType resultMediaType, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Object body, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).delete(BodyConverter.convertFrom(body, BodyConverter.JSON)).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, body, BodyConverter.JSON, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType mediaType, Type type) throws DBException {
        Request request = this.buildPostRequest(endpointUrl, parameters, body, mediaType);
        return this.executeRequest(request, type);
    }

    protected Request buildPostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType mediaType) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        RequestBody requestBody = BodyConverter.convertFrom(body, mediaType);
        return new Request.Builder().url(url).post(requestBody).build();
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @Nullable Object body, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, parameters, body, BodyConverter.JSON, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType bodyMediaType, @NotNull Type type) throws DBException {
        Request request = new Request.Builder().url(this.buildUrl(endpointUrl, parameters)).put(BodyConverter.convertFrom(body, bodyMediaType)).build();
        return this.executeRequest(request, type);
    }

    protected HttpUrl buildUrl(String endpointUrl, Map<String, ?> parameters) throws DBException {
        HttpUrl baseUrl = HttpUrl.parse((String)this.apiUrl);
        if (baseUrl == null) {
            throw new DBException("Could not parse url: " + this.apiUrl);
        }
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder().addPathSegments(endpointUrl);
        parameters.forEach((paramName, value) -> {
            if (value == null) {
                return;
            }
            if (value instanceof byte[]) {
                urlBuilder.addQueryParameter(paramName, new String((byte[])value, StandardCharsets.UTF_8));
            } else if (value.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])value;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    urlBuilder.addQueryParameter(paramName, v.toString());
                    ++n2;
                }
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection array = (Collection)value;
                for (Object v : array) {
                    urlBuilder.addQueryParameter(paramName, v.toString());
                }
            } else {
                urlBuilder.addQueryParameter(paramName, value.toString());
            }
        });
        return urlBuilder.build();
    }

    /*
     * Unable to fully structure code
     */
    protected <T> T executeRequest(Request request, Type type) throws DBException {
        requestURL = request.url();
        AbstractRemoteClient.log.debug((Object)("--> Call: " + requestURL.scheme() + "://" + requestURL.host() + ":" + requestURL.port() + requestURL.encodedPath()));
        call = this.httpClient.newCall(request);
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                response = AbstractRemoteClient.execute(call);
                try {
                    if (!response.isSuccessful()) {
                        message = response.code() == 404 ? "Endpoint '" + requestURL + "' not recognized by remote server" : response.body().string();
                        if (CommonUtils.isEmpty((String)message)) {
                            message = "Error processing HTTP request: " + response.message();
                        }
                        if (response.code() == 440) {
                            throw new SMAccessTokenExpiredException(message);
                        }
                        if (response.code() == 441) {
                            throw new SMRefreshTokenExpiredException(message);
                        }
                        throw new DBException(message);
                    }
                    if (type == byte[].class) {
                        return (T)response.body().bytes();
                    }
                    jsonResponse = response.body().string();
                    if (type == String.class) {
                        return (T)jsonResponse;
                    }
                    return (T)AbstractRemoteClient.gson.fromJson(jsonResponse, type);
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                } else if (var5_5 != var6_9) {
                    var5_5.addSuppressed(var6_9);
                }
                throw var5_5;
            }
        }
        catch (Exception e) {
            ** for (handler : AbstractRemoteClient.exceptionHandlers)
        }
lbl-1000:
        // 1 sources

        {
            handler.handle(e);
            continue;
        }
lbl40:
        // 1 sources

        this.handleRequestException(e);
        return null;
    }

    protected static String buildEndpointUrl(String ... pathParts) {
        return String.join((CharSequence)"/", pathParts);
    }

    protected void handleRequestException(Exception e) throws DBException {
        throw new DBCException(e.getMessage(), (Throwable)e);
    }

    @NotNull
    private static Response execute(final @NotNull Call call) throws Exception {
        if (!AbstractRemoteClient.isRunRequestsInAsyncMode()) {
            return call.execute();
        }
        String descr = "Execute remote call to " + String.join((CharSequence)"/", call.request().url().pathSegments());
        Future result = DBWorkbench.getPlatformUI().executeWithProgressBlocking(descr, (DBRRunnableWithResult)new DBRRunnableWithResult<Future<Response>>(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    this.result = CompletableFuture.completedFuture(call.execute());
                }
                catch (IOException ex) {
                    this.result = CompletableFuture.failedFuture(ex);
                }
            }

            public void cancel() {
                call.cancel();
            }
        });
        return (Response)result.get();
    }
}

