/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AncestorListener;
import org.eclipse.draw2dl.AnchorListener;
import org.eclipse.draw2dl.ConnectionAnchorBase;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Point;

public abstract class AbstractConnectionAnchor
extends ConnectionAnchorBase
implements AncestorListener {
    private IFigure owner;

    public AbstractConnectionAnchor() {
    }

    public AbstractConnectionAnchor(IFigure owner) {
        this.setOwner(owner);
    }

    @Override
    public void addAnchorListener(AnchorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.size() == 0) {
            this.getOwner().addAncestorListener(this);
        }
        super.addAnchorListener(listener);
    }

    @Override
    public void ancestorMoved(IFigure figure) {
        this.fireAnchorMoved();
    }

    @Override
    public void ancestorAdded(IFigure ancestor) {
    }

    @Override
    public void ancestorRemoved(IFigure ancestor) {
    }

    @Override
    public IFigure getOwner() {
        return this.owner;
    }

    @Override
    public Point getReferencePoint() {
        if (this.getOwner() == null) {
            return null;
        }
        Point ref = this.getOwner().getBounds().getCenter();
        this.getOwner().translateToAbsolute(ref);
        return ref;
    }

    @Override
    public void removeAnchorListener(AnchorListener listener) {
        super.removeAnchorListener(listener);
        if (this.listeners.size() == 0) {
            this.getOwner().removeAncestorListener(this);
        }
    }

    public void setOwner(IFigure owner) {
        this.owner = owner;
    }
}

