/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.channels;

import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.LogUtilities;
import com.vertica.support.channels.AbstractSocketChannel;
import com.vertica.support.channels.IHostNameValidator;
import com.vertica.support.channels.ISocketChannelReadCallback;
import com.vertica.support.channels.SocketChannelMessageKey;
import com.vertica.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public class TLSSocketChannel
extends AbstractSocketChannel {
    private static final String PROTOCOL_SSL = "SSL";
    private static final int UNFLIPPED_STATE = -1;
    private SSLContext m_sslContext;
    private SSLEngine m_sslEngine;
    private SSLSession m_sslSession;
    private ByteBuffer m_sendEncryptedBuffer;
    private ByteBuffer m_recvEncryptedBuffer;
    private ByteBuffer m_recvClearTextBuffer;
    private ByteBuffer m_sendHandshakeClearTextBuffer;
    private ByteBuffer m_recvHandshakeClearTextBuffer;
    private SSLWriteEngineLock m_sslengineWriteLock;
    private SSLReadEngineLock m_sslengineReadLock;

    public TLSSocketChannel(SocketChannel internal, ISocketChannelReadCallback readCallback, String host, int port, IHostNameValidator hostNameValidator, boolean hostnameValidation, KeyManager[] keyManagers, TrustManager[] trustManagers, ILogger logger) throws ErrorException {
        super(internal, readCallback, logger);
        LogUtilities.logDebug(String.format("Host=%s Port=%d", host, port), logger);
        this.m_sslengineWriteLock = new SSLWriteEngineLock();
        this.m_sslengineReadLock = new SSLReadEngineLock();
        System.setProperty("com.sun.net.ssl.rsaPreMasterSecretFix", "true");
        try {
            this.m_sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        try {
            this.m_sslContext.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (KeyManagementException ex) {
            LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        this.m_sslEngine = this.m_sslContext.createSSLEngine(host, port);
        if (hostnameValidation) {
            hostNameValidator.enableHostnameValidation(this.m_sslEngine, this.m_log);
        }
        this.m_sslEngine.setEnabledProtocols(this.removeSSLProtocols(this.m_sslEngine.getEnabledProtocols()));
        this.m_sslEngine.setUseClientMode(true);
        this.m_sslSession = this.m_sslEngine.getSession();
        this.m_recvEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_recvClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_sendHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_recvClearTextBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.doHandshake();
    }

    private String[] removeSSLProtocols(String[] enabledProtocols) {
        StringBuffer str = new StringBuffer();
        str.append("Input protocols = '");
        ArrayList<String> acceptedProtocols = new ArrayList<String>();
        for (String protocol : enabledProtocols) {
            str.append(protocol);
            str.append(",");
            if (null == protocol || protocol.toUpperCase().contains(PROTOCOL_SSL)) continue;
            acceptedProtocols.add(protocol);
        }
        str.append("', enabled protocols = '");
        for (String protocol : acceptedProtocols) {
            str.append(protocol);
            str.append(",");
        }
        str.append("'");
        LogUtilities.logDebug(str.toString(), this.m_log);
        return acceptedProtocols.toArray(new String[acceptedProtocols.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void read() throws ErrorException {
        SSLEngineResult result = null;
        int positionBeforeFlip = -1;
        int bytesRead = -2;
        SSLReadEngineLock sSLReadEngineLock = this.m_sslengineReadLock;
        synchronized (sSLReadEngineLock) {
            while (true) {
                try {
                    bytesRead = this.m_internal.read(this.m_recvEncryptedBuffer);
                }
                catch (IOException ex) {
                    LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                }
                if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                    LogUtilities.logTrace(String.format("%d bytes read from channel %s", bytesRead, this.getChannelID()), this.m_log);
                }
                if (-1 == bytesRead) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
                }
                block22: do {
                    try {
                        positionBeforeFlip = this.m_recvEncryptedBuffer.position();
                        this.m_recvEncryptedBuffer.flip();
                        result = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvClearTextBuffer);
                        if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                            LogUtilities.logDebug("ReadMessages:UNWRAP:Consume:" + result.bytesConsumed() + ":Produced:" + result.bytesProduced() + ":Position:" + this.m_recvEncryptedBuffer.position(), this.m_log);
                        }
                    }
                    catch (SSLProtocolException ex) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    catch (SSLException ex) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    catch (ReadOnlyBufferException ex) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    catch (IllegalStateException ex) {
                        LogUtilities.logFatal(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    if (null != result) {
                        switch (result.getStatus()) {
                            case OK: {
                                LogUtilities.logDebug("ReadMessages:OK:" + (Object)((Object)result.getHandshakeStatus()), this.m_log);
                                switch (result.getHandshakeStatus()) {
                                    case NEED_TASK: 
                                    case NEED_UNWRAP: 
                                    case NEED_WRAP: {
                                        boolean shouldLogDebug = LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log);
                                        if (shouldLogDebug) {
                                            LogUtilities.logDebug("Handshake request detected: " + (Object)((Object)result.getHandshakeStatus()) + ":EncReadBuffer.remaining():" + this.m_recvEncryptedBuffer.remaining() + ":ClearTextBuffer.remaining():" + this.m_recvClearTextBuffer.remaining(), this.m_log);
                                        }
                                        try {
                                            if (shouldLogDebug) {
                                                LogUtilities.logDebug("ReadMessages:OK:NEED_TASK:PreReadMessages:Before:Flip:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.m_recvEncryptedBuffer.clear();
                                            if (shouldLogDebug) {
                                                LogUtilities.logDebug("ReadMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.doHandshake();
                                            break;
                                        }
                                        catch (Exception ex) {
                                            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                                            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                                        }
                                    }
                                    default: {
                                        positionBeforeFlip = -1;
                                        this.readCallback(this.m_recvClearTextBuffer);
                                        if (this.m_recvEncryptedBuffer.hasRemaining()) {
                                            this.m_recvEncryptedBuffer.compact();
                                            break;
                                        }
                                        this.m_recvEncryptedBuffer.clear();
                                        break;
                                    }
                                }
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_OVERFLOW", this.m_log);
                                if (positionBeforeFlip != -1) {
                                    this.m_recvEncryptedBuffer.position(positionBeforeFlip);
                                    this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                }
                                this.m_recvClearTextBuffer = this.resizeBuffer(this.m_recvClearTextBuffer, this.m_sslEngine.getSession().getApplicationBufferSize());
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_UNDERFLOW", this.m_log);
                                if (positionBeforeFlip == -1) break;
                                this.m_recvEncryptedBuffer.position(positionBeforeFlip);
                                this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                continue block22;
                            }
                            case CLOSED: {
                                LogUtilities.logDebug("ReadMessages:CLOSED", this.m_log);
                            }
                        }
                        continue;
                    }
                    LogUtilities.logDebug("ReadMessages:Result was null but there was no exception.", this.m_log);
                } while (this.m_recvEncryptedBuffer.position() > 0 && null != result && result.getStatus() == SSLEngineResult.Status.OK);
                if (null == result) continue;
                if (null == result) return;
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            }
            return;
        }
    }

    @Override
    public boolean write(ByteBuffer writeBuffer) throws ErrorException {
        return this.write(new ByteBuffer[]{writeBuffer}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(ByteBuffer[] writeBuffers, int offset, int length) throws ErrorException {
        if (null == this.m_sendEncryptedBuffer) {
            this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
            this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        SSLWriteEngineLock sSLWriteEngineLock = this.m_sslengineWriteLock;
        synchronized (sSLWriteEngineLock) {
            try {
                if (!this.writeEncryptedBuffer()) {
                    return false;
                }
                if (!this.arrayHasRemaining(writeBuffers, offset, length)) {
                    return true;
                }
                this.m_sendEncryptedBuffer.clear();
                while (this.arrayHasRemaining(writeBuffers, offset, length)) {
                    ByteBuffer writeBuffer;
                    int i;
                    SSLEngineResult result = null;
                    if (this.m_log.isEnabled()) {
                        for (i = offset; i < length; ++i) {
                            writeBuffer = writeBuffers[i];
                            LogUtilities.logDebug("WriteMessages:WRAP:BEFORE:0:writeBuffer.remaining:" + writeBuffer.remaining() + ":writeBuffer.pos:" + writeBuffer.position() + ":writeBuffer.limit:" + writeBuffer.limit(), this.m_log);
                        }
                    }
                    result = this.m_sslEngine.wrap(writeBuffers, offset, length, this.m_sendEncryptedBuffer);
                    if (this.m_log.isEnabled()) {
                        for (i = offset; i < length; ++i) {
                            writeBuffer = writeBuffers[i];
                            LogUtilities.logDebug("WriteMessages:WRAP:AFTER:0:writeBuffer.remaining:" + writeBuffer.remaining() + ":writeBuffer.pos:" + writeBuffer.position() + ":writeBuffer.limit:" + writeBuffer.limit() + ":produced:" + result.bytesProduced() + ":consumed:" + result.bytesConsumed(), this.m_log);
                        }
                    }
                    this.m_sendEncryptedBuffer.flip();
                    switch (result.getStatus()) {
                        case OK: {
                            if (this.m_log.isEnabled()) {
                                LogUtilities.logDebug("WriteMessages:OK:" + (Object)((Object)result.getHandshakeStatus()), this.m_log);
                            }
                            switch (result.getHandshakeStatus()) {
                                case NEED_TASK: 
                                case NEED_UNWRAP: 
                                case NEED_WRAP: {
                                    try {
                                        if (this.m_log.isEnabled()) {
                                            LogUtilities.logDebug("WriteMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit() + ":TempEncHSRecvBuffer.remaining:", this.m_log);
                                        }
                                        this.doHandshake();
                                        this.m_sendEncryptedBuffer.flip();
                                        this.m_sendEncryptedBuffer.limit(this.m_sendEncryptedBuffer.capacity());
                                        break;
                                    }
                                    catch (Exception ex) {
                                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                                    }
                                }
                                default: {
                                    if (!this.writeEncryptedBuffer()) {
                                        return false;
                                    }
                                    if (!this.m_log.isEnabled()) break;
                                    LogUtilities.logDebug("Wrote Messages - " + (Object)((Object)this.m_sslEngine.getHandshakeStatus()), this.m_log);
                                    break;
                                }
                            }
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            if (this.m_log.isEnabled()) {
                                LogUtilities.logDebug("WriteMessages:BUFFER_OVERFLOW:Expanding to " + this.m_sslEngine.getSession().getPacketBufferSize() + " bytes.", this.m_log);
                            }
                            this.m_sendEncryptedBuffer = this.resizeBuffer(this.m_sendEncryptedBuffer, this.m_sslEngine.getSession().getPacketBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (!this.m_log.isEnabled()) break;
                            LogUtilities.logDebug("WriteMessages:BUFFER_UNDERFLOW:Should not happen", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("WriteMessages:CLOSED", this.m_log);
                            return true;
                        }
                    }
                }
            }
            catch (IOException ex) {
                LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    private boolean writeEncryptedBuffer() throws IOException {
        while (this.m_sendEncryptedBuffer.hasRemaining()) {
            int bytesWritten = this.m_internal.write(this.m_sendEncryptedBuffer);
            if (-1 == bytesWritten) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("WriteMessages:OK:Closed", this.m_log);
                }
                return true;
            }
            if (0 == bytesWritten) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("WriteMessages:OK:0 Bytes Written", this.m_log);
                }
                return false;
            }
            if (!this.m_log.isEnabled()) continue;
            LogUtilities.logDebug("WriteMessages:OK:" + bytesWritten + " bytes sent.", this.m_log);
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.m_recvClearTextBuffer.flip();
            SSLEngineResult check = this.m_sslEngine.unwrap(this.m_recvClearTextBuffer, this.m_recvEncryptedBuffer);
            if (check.getStatus() != SSLEngineResult.Status.CLOSED) {
                this.m_sslEngine.closeOutbound();
            }
        }
        catch (Exception ex) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
        }
        super.close();
    }

    @Override
    public int getReadBufferCapacity() {
        return this.m_recvEncryptedBuffer.capacity();
    }

    private void doHandshake() throws ErrorException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        int totalBytesLastRead = -1;
        int bytesConsumedSinceLastRead = 0;
        int bytesProducedSinceLastRead = 0;
        this.logHandshakeAction("BEGIN:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
        try {
            this.m_sslEngine.beginHandshake();
        }
        catch (SSLException ex) {
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        bytesConsumedSinceLastRead = 0;
        bytesProducedSinceLastRead = 0;
        totalBytesLastRead = this.readBytes("BEGIN:");
        SSLEngineResult.HandshakeStatus inHandshakeStatus = handshakeStatus = this.m_sslEngine.getHandshakeStatus();
        while (SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != inHandshakeStatus && SSLEngineResult.HandshakeStatus.FINISHED != inHandshakeStatus) {
            SSLEngineResult res = null;
            SSLEngineResult.Status status = null;
            SSLEngineResult.HandshakeStatus updatedHandshakeStatus = null;
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.logHandshakeAction("NEED_UNWRAP:BEFORE:UNWRAP:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
                    try {
                        res = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvHandshakeClearTextBuffer);
                    }
                    catch (SSLException ex) {
                        LogUtilities.logError("Handshake count: 0", this.m_log);
                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    updatedHandshakeStatus = res.getHandshakeStatus();
                    status = res.getStatus();
                    LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:UNWRAP:RESULT: UnwrapStatus:" + (Object)((Object)status) + " - UnwrapHandshakeStatus:" + (Object)((Object)updatedHandshakeStatus) + "\n\tBytesConsumed:" + res.bytesConsumed() + "\n\tBytesProduced:" + res.bytesProduced(), this.m_log);
                    this.logHandshakeAction("NEED_UNWRAP:AFTER:UNWRAP:", totalBytesLastRead, bytesConsumedSinceLastRead += res.bytesConsumed(), bytesProducedSinceLastRead += res.bytesProduced());
                    switch (status) {
                        case OK: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:OK", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:BUFFER_OVERFLOW", this.m_log);
                            this.m_recvHandshakeClearTextBuffer = this.resizeBuffer(this.m_recvHandshakeClearTextBuffer, this.m_sslSession.getApplicationBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
                            if (this.m_recvEncryptedBuffer.remaining() == 0 && this.m_recvEncryptedBuffer.position() == this.m_recvEncryptedBuffer.limit()) {
                                LogUtilities.logDebug("\nBuffer has been consumed", this.m_log);
                                this.m_recvEncryptedBuffer.clear();
                                totalBytesLastRead = -1;
                            } else {
                                LogUtilities.logDebug("\nBuffer has NOT been consumed. Remaining : " + this.m_recvEncryptedBuffer.remaining(), this.m_log);
                            }
                            if (this.m_recvEncryptedBuffer.remaining() > 0 && this.m_recvEncryptedBuffer.remaining() != this.m_recvEncryptedBuffer.capacity()) {
                                this.compact("NEED_UNWRAP:BUFFER_UNDERFLOW", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
                            }
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:READ:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
                            bytesConsumedSinceLastRead = 0;
                            bytesProducedSinceLastRead = 0;
                            totalBytesLastRead = this.readBytes("NEED_UNWRAP:BUFFER_UNDERFLOW");
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("Handshake:NEED_UNWRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    LogUtilities.logDebug("\nHandshake:NEED_WRAP", this.m_log);
                    this.m_sendEncryptedBuffer.clear();
                    res = null;
                    try {
                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:WRAP", this.m_log);
                        res = this.m_sslEngine.wrap(this.m_sendHandshakeClearTextBuffer, this.m_sendEncryptedBuffer);
                        bytesConsumedSinceLastRead += res.bytesConsumed();
                        bytesProducedSinceLastRead += res.bytesProduced();
                        updatedHandshakeStatus = res.getHandshakeStatus();
                        status = res.getStatus();
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:WRAP:RESULT: WrapStatus:" + (Object)((Object)status) + " - WrapHandshakeStatus:" + (Object)((Object)updatedHandshakeStatus) + "\n\tBytesConsumed:" + res.bytesConsumed() + "\n\tBytesProduced:" + res.bytesProduced(), this.m_log);
                        }
                    }
                    catch (SSLException ex) {
                        LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                        throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                    switch (res.getStatus()) {
                        case OK: {
                            int totalBytesLastWritten;
                            this.flip("NEED_WRAP:OK", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead, false);
                            int bytesWritten = totalBytesLastWritten = 0;
                            LogUtilities.logDebug("NEED_WRAP:OK:BEFORE:WRITE:", this.m_log);
                            while (this.m_sendEncryptedBuffer.hasRemaining()) {
                                try {
                                    bytesWritten = this.m_internal.write(this.m_sendEncryptedBuffer);
                                    totalBytesLastWritten += bytesWritten;
                                    if (!this.m_log.isEnabled()) continue;
                                    if (bytesWritten < 0) {
                                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:0B written, conn closed.", this.m_log);
                                    }
                                    LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:WRITE\n\tWritten: " + bytesWritten + " bytes." + "\n\tTotal Written: " + totalBytesLastWritten + " bytes.", this.m_log);
                                }
                                catch (IOException ex) {
                                    LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
                                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                                }
                            }
                            if (!this.m_log.isEnabled()) break;
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:AFTER:WRITE\n\tFinal Total Written: " + totalBytesLastWritten + " bytes total.", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_OVERFLOW", this.m_log);
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_UNDERFLOW", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.needTask();
                    break;
                }
                case FINISHED: {
                    LogUtilities.logDebug("\nHandshake:FINISHED", this.m_log);
                    break;
                }
                case NOT_HANDSHAKING: {
                    LogUtilities.logDebug("\nHandshake:NOT_HANDSHAKING", this.m_log);
                }
            }
            handshakeStatus = this.m_sslEngine.getHandshakeStatus();
            if (this.m_log.isEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append((Object)inHandshakeStatus);
                sb.append(":SSL_ENGINE_STATUS: ");
                sb.append("UpdatedHandshakeStatus: ");
                sb.append((Object)updatedHandshakeStatus);
                sb.append(" - EngineHandshakeStatus: ");
                sb.append((Object)handshakeStatus);
                if (null != updatedHandshakeStatus && updatedHandshakeStatus != handshakeStatus) {
                    sb.append(" !!!!!!!!!!!!!!!");
                }
                LogUtilities.logDebug(sb.toString(), this.m_log);
            }
            inHandshakeStatus = handshakeStatus;
        }
        if (totalBytesLastRead == -1) {
            LogUtilities.logDebug("\nBuffer has been consumed", this.m_log);
            this.m_recvEncryptedBuffer.compact();
        } else {
            this.m_recvEncryptedBuffer.position(bytesConsumedSinceLastRead);
            this.m_recvEncryptedBuffer.limit(totalBytesLastRead);
            this.m_recvEncryptedBuffer.compact();
        }
        this.logHandshakeAction("FINSIHED:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
        LogUtilities.logDebug("\nHandshake: All done.", this.m_log);
    }

    private ByteBuffer resizeBuffer(ByteBuffer buffer, int size) {
        if (size > buffer.remaining()) {
            if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                LogUtilities.logDebug("Buffer resize - Remaining: " + buffer.remaining() + ", Limit: " + buffer.limit() + ", SSLEngine.???Size: " + size + ", new size will be: " + (size + buffer.limit()), this.m_log);
            }
            ByteBuffer b = ByteBuffer.allocateDirect(size + buffer.limit());
            buffer.flip();
            b.put(buffer);
            return b;
        }
        return buffer;
    }

    private void logHandshakeAction(String handshakeAction, int totalBytesLastRead, int bytesConsumedSinceLastRead, int bytesProducedSinceLastRead) {
        if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nHandshake:");
            sb.append(handshakeAction);
            sb.append("\n\tRead:");
            sb.append(totalBytesLastRead);
            if (totalBytesLastRead != -1 && totalBytesLastRead < bytesConsumedSinceLastRead) {
                sb.append(" !!");
            }
            sb.append("\n\tConsumed Since Read:");
            sb.append(bytesConsumedSinceLastRead);
            if (totalBytesLastRead != -1 && totalBytesLastRead < bytesConsumedSinceLastRead) {
                sb.append(" !!");
            }
            sb.append("\n\tProduced Since Read:");
            sb.append(bytesProducedSinceLastRead);
            sb.append("\n\tEncHSRecvBuffer.remaining:");
            sb.append(this.m_recvEncryptedBuffer.remaining());
            sb.append("\n\tEncHSRecvBuffer.pos:");
            sb.append(this.m_recvEncryptedBuffer.position());
            sb.append("\n\tEncHSRecvBuffer.limit:");
            sb.append(this.m_recvEncryptedBuffer.limit());
            sb.append("\n\tEncHSRecvBuffer.capacity:");
            sb.append(this.m_recvEncryptedBuffer.capacity());
            sb.append("\n\tClearHSRecvBuffer.remaining:");
            sb.append(this.m_recvHandshakeClearTextBuffer.remaining());
            sb.append("\n\tClearHSRecvBuffer.pos:");
            sb.append(this.m_recvHandshakeClearTextBuffer.position());
            sb.append("\n\tCLearHSRecvBuffer.limit:");
            sb.append(this.m_recvHandshakeClearTextBuffer.limit());
            sb.append("\n\tCLearHSRecvBuffer.capacity:");
            sb.append(this.m_recvHandshakeClearTextBuffer.capacity());
            LogUtilities.logDebug(sb.toString(), this.m_log);
        }
    }

    private void compact(String handshakeAction, int totalBytesLastRead, int bytesConsumedSinceLastRead, int bytesProducedSinceLastRead) {
        this.logHandshakeAction(handshakeAction + ":BEFORE:COMPACT:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
        this.m_recvEncryptedBuffer.compact();
        this.logHandshakeAction(handshakeAction + ":AFTER:COMPACT:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
    }

    private void flip(String handshakeAction, int totalBytesLastRead, int bytesConsumedSinceLastRead, int bytesProducedSinceLastRead, boolean isRecv) {
        if (isRecv) {
            this.logHandshakeAction(handshakeAction + ":BEFORE:FLIP:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
            this.m_recvEncryptedBuffer.flip();
            this.logHandshakeAction(handshakeAction + ":AFTER:FLIP:", totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead);
        } else {
            this.m_sendEncryptedBuffer.flip();
        }
    }

    private void needTask() {
        Runnable task;
        LogUtilities.logDebug("\nHandshake:NEED_TASK", this.m_log);
        while ((task = this.m_sslEngine.getDelegatedTask()) != null) {
            LogUtilities.logDebug("\nHandshake:NEED_TASK:Starting delegate task.", this.m_log);
            task.run();
        }
    }

    private int readBytes(String handshakeAction) throws ErrorException {
        int bytesProducedSinceLastRead = 0;
        int bytesConsumedSinceLastRead = 0;
        int bytesLastRead = 0;
        int totalBytesLastRead = 0;
        try {
            do {
                bytesConsumedSinceLastRead = 0;
                bytesProducedSinceLastRead = 0;
                bytesLastRead = this.m_internal.read(this.m_recvEncryptedBuffer);
                totalBytesLastRead += bytesLastRead;
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("\nHandshake:" + handshakeAction + ":READ:" + "\n\tRead: " + bytesLastRead + " bytes." + "\n\tTotal Read: " + totalBytesLastRead + " bytes.", this.m_log);
            } while (bytesLastRead > 0);
        }
        catch (IOException ex) {
            LogUtilities.logError("Handshake count: 0", this.m_log);
            LogUtilities.logError(String.format("Error occurred on channel %s: %s", this.getChannelID(), ex), this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("\nHandshake:" + handshakeAction + ":AFTER:READ:" + "\n\tFinal Total Read: " + totalBytesLastRead + " bytes total.", this.m_log);
        }
        if (totalBytesLastRead < 0) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Handshake count: 0", this.m_log);
            }
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        }
        this.flip(handshakeAction, totalBytesLastRead, bytesConsumedSinceLastRead, bytesProducedSinceLastRead, true);
        return totalBytesLastRead;
    }

    private class SSLWriteEngineLock {
        private SSLWriteEngineLock() {
        }
    }

    private class SSLReadEngineLock {
        private SSLReadEngineLock() {
        }
    }
}

