/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.channels;

import com.vertica.support.channels.FramedSocketChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

class FramedTcpSocketChannel
extends FramedSocketChannel {
    private final SocketChannel m_channel;
    private final ByteBuffer m_lenBuf = ByteBuffer.allocate(2);
    private char m_truncatedLen = '\u0000';

    FramedTcpSocketChannel(SocketChannel channel) {
        this.m_channel = channel;
        this.m_lenBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public SelectableChannel getChannel() {
        return this.m_channel;
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return this.m_channel.connect(remote);
    }

    @Override
    public int readFrame(ByteBuffer dst) throws IOException {
        int readLen;
        if (this.m_lenBuf.hasRemaining()) {
            readLen = this.m_channel.read(this.m_lenBuf);
            if (readLen <= 0) {
                return readLen;
            }
            if (this.m_lenBuf.hasRemaining()) {
                return 0;
            }
            this.m_lenBuf.flip();
            char frameLen = this.m_lenBuf.getChar();
            dst.limit(Math.min(frameLen, dst.capacity()));
            this.m_truncatedLen = (char)(frameLen - dst.limit());
        }
        if (dst.hasRemaining()) {
            readLen = this.m_channel.read(dst);
            if (readLen <= 0) {
                return readLen;
            }
            if (dst.hasRemaining()) {
                return 0;
            }
        }
        if (this.m_truncatedLen > '\u0000') {
            ByteBuffer truncatedData = ByteBuffer.allocate(this.m_truncatedLen);
            int readLen2 = this.m_channel.read(truncatedData);
            if (readLen2 <= 0) {
                return readLen2;
            }
            this.m_truncatedLen = (char)(this.m_truncatedLen - truncatedData.position());
            if (this.m_truncatedLen > '\u0000') {
                return 0;
            }
        }
        this.m_lenBuf.clear();
        return dst.limit();
    }

    @Override
    public int writeFrame(ByteBuffer src) throws IOException {
        int writeLen;
        if (this.m_lenBuf.hasRemaining()) {
            if (this.m_lenBuf.position() == 0) {
                assert (src.limit() <= 65535);
                this.m_lenBuf.putChar((char)src.limit());
                this.m_lenBuf.flip();
            }
            if ((writeLen = this.m_channel.write(this.m_lenBuf)) <= 0) {
                return writeLen;
            }
            if (this.m_lenBuf.hasRemaining()) {
                return 0;
            }
        }
        if ((writeLen = this.m_channel.write(src)) <= 0) {
            return writeLen;
        }
        if (src.hasRemaining()) {
            return 0;
        }
        this.m_lenBuf.clear();
        return src.limit();
    }
}

