/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.jdbc41.S41ForwardResultSet;
import com.vertica.jdbc.jdbc41.S41ParameterMetaData;
import com.vertica.jdbc.jdbc41.S41ResultSetMetaData;
import com.vertica.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class S41PreparedStatement
extends SPreparedStatement {
    public S41PreparedStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet internalResultSet, boolean updatable, int fetchSize) throws SQLException {
        SForwardResultSet resultSet = updatable ? new S41UpdatableForwardResultSet(this, internalResultSet, this.getLogger()) : new S41ForwardResultSet(this, internalResultSet, this.getLogger());
        resultSet.setFetchSize(fetchSize);
        return resultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults execResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> itr = execResults.getResultItr();
                if (!itr.hasNext()) {
                    return null;
                }
                ExecutionResult execResult = itr.next();
                if (ExecutionResultType.RESULT_SET == execResult.getType()) {
                    IResultSet result = (IResultSet)execResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(result));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet internalResultSet) throws SQLException {
        try {
            ArrayList<? extends IColumn> metadataColumns = internalResultSet.getSelectColumns();
            if (null == metadataColumns) {
                return null;
            }
            return new S41ResultSetMetaData(metadataColumns, this.getLogger(), this.getWarningListener());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData parameterMetadata = null;
                parameterMetadata = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(parameterMetadata);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }
}

