/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IErrorResult;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class SStatement
implements Statement {
    private static final int MAX_ROWS_UNLIMITED = 0;
    private static final String INSERT_TOKEN = "insert";
    private static final int RESULT_SET_UPDATE_COUNT = -1;
    protected Iterator<ExecutionResult> m_resultIterator = null;
    protected ParameterGeneratedValues m_generatedParams = null;
    protected IResultSet m_generatedResult = new DSIEmptyResultSet();
    protected List<ResultContext> m_resultSets = new ArrayList<ResultContext>();
    protected IStatement m_statement = null;
    protected IQueryExecutor m_queryExecutor = null;
    private IDataEngine m_dataEngine = null;
    protected SWarningListener m_warningListener = null;
    protected IMessageSource m_messageSource = null;
    protected boolean m_escapeProcessingEnabled = true;
    protected ILogger m_logger = null;
    protected SConnection m_parentConnection = null;
    private int m_currentResultSetIndex = 0;
    private int m_concurrency = 1007;
    private List<String> m_batchSQLStatements = new ArrayList<String>();
    protected JDBCVersion m_jdbcVersion;
    private final Object m_closeLock = new Object();
    protected boolean m_isCanceled = false;
    protected boolean m_isInCancelableFunction = false;
    protected final Object m_cancelLock = new Object();
    private final Object m_resultSetsLock = new Object();
    protected volatile boolean m_closeOnCompletion = false;

    protected static boolean isInsertStatement(String sql) {
        StringTokenizer strTokenizer = new StringTokenizer(sql);
        String initialToken = strTokenizer.nextToken();
        return INSERT_TOKEN.equalsIgnoreCase(initialToken);
    }

    private static CheckResultType GetCheckResultType(long stateMachineMode) {
        if (0L != (stateMachineMode & 2L)) {
            return CheckResultType.None;
        }
        if (0L != (stateMachineMode & 1L)) {
            return CheckResultType.CheckAfterExec;
        }
        return CheckResultType.CheckAfterPrep;
    }

    protected static ThrowCondition GetConditionForAfterPrepare(long stateMachineMode, boolean expectResultset) {
        switch (SStatement.GetCheckResultType(stateMachineMode)) {
            case None: 
            case CheckAfterExec: {
                return ThrowCondition.None;
            }
        }
        return expectResultset ? ThrowCondition.SingleResult : ThrowCondition.SingleRowCount;
    }

    protected static ThrowCondition GetConditionForAfterExecute(long stateMachineMode, boolean expectResultset) {
        switch (SStatement.GetCheckResultType(stateMachineMode)) {
            case CheckAfterExec: {
                return expectResultset ? ThrowCondition.SingleResult : ThrowCondition.SingleRowCount;
            }
        }
        return ThrowCondition.None;
    }

    private static int longUpdateCountToInt(long updateCount) {
        if (updateCount == -3L) {
            return -3;
        }
        if (updateCount == -2L || updateCount > Integer.MAX_VALUE) {
            return -2;
        }
        if (updateCount < 0L) {
            throw new IllegalArgumentException(String.format("Invalid updateCount: %d", updateCount));
        }
        return (int)updateCount;
    }

    private static int[] longUpdateCountstoInts(long[] updateCounts) {
        int[] intUpdateCounts = new int[updateCounts.length];
        for (int i = 0; i < updateCounts.length; ++i) {
            intUpdateCounts[i] = SStatement.longUpdateCountToInt(updateCounts[i]);
        }
        return intUpdateCounts;
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> errorExceptions, long[] ret) {
        return SStatement.createBatchUpdateException(errorExceptions, SStatement.longUpdateCountstoInts(ret));
    }

    private static BatchUpdateException createBatchUpdateException(List<SQLException> exceptions, int[] results) {
        BatchUpdateException result = null;
        if (null != exceptions && !exceptions.isEmpty()) {
            Iterator<SQLException> iter = exceptions.iterator();
            SQLException firstException = iter.next();
            SQLException previousException = result = new BatchUpdateException(firstException.getMessage(), firstException.getSQLState(), firstException.getErrorCode(), results);
            while (iter.hasNext()) {
                SQLException currentException = iter.next();
                previousException.setNextException(currentException);
                previousException = currentException;
            }
        }
        return result;
    }

    protected SStatement(IStatement statement, SConnection conn, int concurrency) {
        this.m_logger = conn.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, statement, conn, concurrency);
        this.m_parentConnection = conn;
        this.m_statement = statement;
        this.m_concurrency = concurrency;
        this.m_messageSource = DSIDriverSingleton.getInstance().getMessageSource();
        this.m_warningListener = new SWarningListener(this.m_messageSource, null);
        this.m_warningListener.setLocale(conn.getDSIConnection().getLocale());
        this.m_statement.registerWarningListener(this.m_warningListener);
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                sql = this.m_parentConnection.nativeSQL(sql);
            }
            this.m_batchSQLStatements.add(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                if (this.m_isInCancelableFunction) {
                    this.m_isCanceled = true;
                }
            }
            IQueryExecutor queryExecutor = this.m_queryExecutor;
            if (null != queryExecutor) {
                queryExecutor.cancelExecute();
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_batchSQLStatements.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.clearResults();
            if (null != this.m_parentConnection) {
                this.m_parentConnection.removeStatement(this);
                this.m_parentConnection = null;
            }
            this.replaceQueryExecutor(null, null);
            try {
                if (null != this.m_statement) {
                    this.m_statement.close();
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_statement = null;
                this.m_generatedResult = null;
            }
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            this.checkIfNullSQL(sql);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            IResults execResults = this.executeNoParams(sql, this.m_generatedParams, ThrowCondition.None);
            this.m_resultIterator = execResults.getResultItr();
            if (!this.m_resultIterator.hasNext()) {
                return false;
            }
            ExecutionResult execResult = this.moveToNextResult();
            this.addResultPair(this.createResultPair(execResult));
            return ExecutionResultType.RESULT_SET == this.m_resultSets.get((int)0).m_resultType || ExecutionResultType.ERROR_RESULT_SET == this.m_resultSets.get((int)0).m_resultType;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(autoGeneratedKeys);
            } else if (autoGeneratedKeys == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.execute(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(columnIndexes);
                return this.execute(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(columnNames);
                return this.execute(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processBatchResults(this.m_queryExecutor.getResults(), Collections.<Pair<Integer, SQLException>>emptyList(), BatchType.MULTI_STATEMENT);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeAnyBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            IDataEngine dataEngine = this.m_statement.createDataEngine();
            dataEngine.setDirectExecute();
            dataEngine.setMetadataNeeded(false);
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor(dataEngine, dataEngine.prepareBatch(this.m_batchSQLStatements));
            ArrayList<ArrayList<ParameterInputValue>> inputParamValues = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> metadata = new ArrayList<ParameterMetadata>();
            inputParamValues.add(new ArrayList());
            ExecutionContexts execContexts = new ExecutionContexts(metadata, inputParamValues);
            this.clearResults();
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(execContexts, this.m_warningListener);
        }
        catch (Exception e) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception e2) {
                LogUtilities.logError(e2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.m_batchSQLStatements.clear();
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            this.checkIfNullSQL(sql);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            long stateMachineMode = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults execResults = this.executeNoParams(sql, SStatement.GetConditionForAfterPrepare(stateMachineMode, true));
            this.m_resultIterator = execResults.getResultItr();
            ExecutionResult execResult = this.checkAndMoveToNextResult(sql, execResults, SStatement.GetConditionForAfterExecute(stateMachineMode, true));
            if (ExecutionResultType.ERROR_RESULT_SET == execResult.getType()) {
                this.addResultPair(this.createResultPair(execResult));
                throw ((IErrorResult)execResult.getResult()).getError();
            }
            ResultSet resultSet = this.createResultSet(execResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            return resultSet;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            return this.castRowCount(this.executeAnyUpdate(sql));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized long executeAnyUpdate(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            this.checkIfNullSQL(sql);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            long stateMachineMode = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults execResults = this.executeNoParams(sql, this.m_generatedParams, SStatement.GetConditionForAfterPrepare(stateMachineMode, false));
            this.m_resultIterator = execResults.getResultItr();
            ExecutionResult execResult = this.checkAndMoveToNextResult(sql, execResults, SStatement.GetConditionForAfterExecute(stateMachineMode, false));
            if (ExecutionResultType.ERROR_ROW_COUNT == execResult.getType()) {
                this.addResultPair(this.createResultPair(execResult));
                throw ((IErrorResult)execResult.getResult()).getError();
            }
            IRowCountResult result = (IRowCountResult)execResult.getResult();
            this.addResultPair(this.createResultPair(execResult));
            if (result.hasRowCount()) {
                return result.getRowCount();
            }
            return 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            boolean supportsGetGeneratedKeys = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (supportsGetGeneratedKeys) {
                if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
                }
                this.m_generatedParams = new ParameterGeneratedValues(autoGeneratedKeys);
            }
            if (!supportsGetGeneratedKeys && autoGeneratedKeys == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.executeUpdate(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            boolean supportsGetGeneratedKeys = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (supportsGetGeneratedKeys) {
                this.m_generatedParams = new ParameterGeneratedValues(columnIndexes);
                return this.executeUpdate(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            boolean supportsGetGeneratedKeys = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (supportsGetGeneratedKeys) {
                this.m_generatedParams = new ParameterGeneratedValues(columnNames);
                return this.executeUpdate(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized Object getAttribute(int key) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(key)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(key));
            }
            Variant attribute = this.m_statement.getCustomProperty(key);
            switch (attribute.getType()) {
                case 5: {
                    return attribute.getShort();
                }
                case 2: {
                    return Character.valueOf(attribute.getChar());
                }
                case 6: {
                    return attribute.getInt();
                }
                case 3: 
                case 7: {
                    return attribute.getLong();
                }
                case 4: {
                    return attribute.getBigInteger();
                }
            }
            return attribute.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(6).getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (!this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            ResultSet resultSet = this.createResultSet(this.m_generatedResult, false, 0);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            return resultSet;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(1);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant var = this.m_statement.getProperty(2);
            long maxRows = var.getLong();
            if (Integer.MAX_VALUE < maxRows || Integer.MIN_VALUE > maxRows) {
                return 0;
            }
            return (int)maxRows;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getMoreResults(true);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, current);
            this.checkIfOpen();
            switch (current) {
                case 1: {
                    return this.getMoreResults(true);
                }
                case 3: {
                    this.closeAllResultsToCurrent();
                    return this.getMoreResults(true);
                }
                case 2: {
                    IDriver driver = DSIDriverSingleton.getInstance();
                    Variant var = driver.getProperty(1005);
                    if (var.getShort() != 1) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                    }
                    return this.getMoreResults(false);
                }
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MORERESULTS_VALUE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(current));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public SConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public IQueryExecutor getQueryExecutor() {
        return this.m_queryExecutor;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(3);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext pair = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_RESULT_SET == pair.m_resultType) {
                    throw ((IErrorResult)pair.m_result).getError();
                }
                if (ExecutionResultType.RESULT_SET == pair.m_resultType) {
                    ((SForwardResultSet)pair.m_result).initializeColumnNameMap();
                    return (ResultSet)pair.m_result;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_concurrency;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection.getHoldability();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public IStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.castRowCount(this.getAnyUpdateCount());
    }

    public synchronized long getAnyUpdateCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext pair = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_ROW_COUNT == pair.m_resultType) {
                    throw ((IErrorResult)pair.m_result).getError();
                }
                if (ExecutionResultType.ROW_COUNT == pair.m_resultType) {
                    return ((IRowCountResult)pair.m_result).getRowCount();
                }
            }
            return -1L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    protected SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized void setAttribute(int key, Object value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(key)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(key));
            }
            int type = this.m_statement.getCustomPropertyType(key);
            this.m_statement.setCustomProperty(key, new Variant(type, value));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCursorName(String name) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, name);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, enable);
            this.checkIfOpen();
            this.m_escapeProcessingEnabled = enable;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, direction);
            this.checkIfOpen();
            switch (direction) {
                case 1000: {
                    break;
                }
                case 1001: 
                case 1002: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(direction));
                }
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, rows);
            this.checkIfOpen();
            if (rows < 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE_UNLIMITED_MAX, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(rows));
            }
            this.m_statement.setProperty(6, new Variant(4, rows));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        long minSize = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, max);
        this.checkIfOpen();
        try {
            minSize = this.getStatementPropertyLong(101);
        }
        catch (Exception e) {
            // empty catch block
        }
        long maxSize = 0L;
        try {
            maxSize = this.getStatementPropertyLong(100);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (minSize > (long)max || 0L != maxSize && maxSize < (long)max) {
                throw new Exception();
            }
            this.setStatementProperty(1, 4, max);
        }
        catch (Exception e) {
            String maxStrSize = String.valueOf(Double.POSITIVE_INFINITY);
            String minStrSize = String.valueOf(minSize);
            if (0L != maxSize) {
                maxStrSize = String.valueOf(maxSize);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FIELD_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(max), minStrSize, maxStrSize);
        }
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.setAnyMaxRows(max);
    }

    protected synchronized void setAnyMaxRows(long max) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, max);
        this.checkIfOpen();
        long minRows = 0L;
        try {
            minRows = this.getStatementPropertyLong(103);
        }
        catch (Exception e) {
            // empty catch block
        }
        long maxRows = 0L;
        try {
            maxRows = this.getStatementPropertyLong(102);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (minRows > max || 0L != maxRows && maxRows < max) {
                throw new Exception();
            }
            this.setStatementProperty(2, 4, max);
        }
        catch (Exception e) {
            String maxStrRows = String.valueOf(Double.POSITIVE_INFINITY);
            String minStrRows = String.valueOf(minRows);
            if (0L != maxRows) {
                maxStrRows = String.valueOf(maxRows);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MAX_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(max), minStrRows, maxStrRows);
        }
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        long minTimeout = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, seconds);
        this.checkIfOpen();
        try {
            minTimeout = this.getStatementPropertyLong(105);
        }
        catch (Exception e) {
            // empty catch block
        }
        long maxTimeout = 0L;
        try {
            maxTimeout = this.getStatementPropertyLong(104);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, seconds);
            this.checkIfOpen();
            if (minTimeout > (long)seconds || 0L != maxTimeout && maxTimeout < (long)seconds) {
                throw new Exception();
            }
            this.setStatementProperty(3, 4, seconds);
        }
        catch (Exception e) {
            String maxStrTimeout = String.valueOf(Double.POSITIVE_INFINITY);
            String minStrTimeout = String.valueOf(minTimeout);
            if (0L != maxTimeout) {
                maxStrTimeout = String.valueOf(maxTimeout);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_TIMEOUT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(seconds), minStrTimeout, maxStrTimeout);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), poolable);
        this.checkIfOpen();
    }

    public void setGeneratedValues(ParameterGeneratedValues generatedParams) {
        this.m_generatedParams = generatedParams;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    void closeIfPrepared() throws SQLException {
    }

    void closeResults() throws SQLException {
        for (int i = this.m_resultSets.size() - 1; i >= 0; --i) {
            ResultContext context = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != context.m_resultType || context.m_isResultClosed) continue;
            ((ResultSet)context.m_result).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markResultSetClosed(ResultSet result) throws SQLException {
        boolean isAllResultSetsClosed = true;
        Object object = this.m_resultSetsLock;
        synchronized (object) {
            for (ResultContext context : this.m_resultSets) {
                if (context.m_result == result) {
                    context.m_isResultClosed = true;
                }
                if (ExecutionResultType.RESULT_SET != context.m_resultType || context.m_isResultClosed) continue;
                isAllResultSetsClosed = false;
            }
        }
        if (isAllResultSetsClosed && this.m_closeOnCompletion) {
            this.close();
        }
    }

    protected void addResultPair(ResultContext pair) {
        if (null != this.m_resultSets && !this.m_resultSets.contains(pair)) {
            this.m_resultSets.add(pair);
        }
    }

    protected void addResultSet(ResultSet rs) {
        this.addResultPair(new ResultContext(rs));
    }

    protected ExecutionResult checkAndMoveToNextResult(String sql, IResults results, ThrowCondition throwCondition) throws SQLException {
        if (ThrowCondition.None == throwCondition) {
            return this.moveToNextResult();
        }
        if (!this.m_resultIterator.hasNext()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(0), sql);
        }
        ExecutionResult result = this.moveToNextResult();
        if (this.m_resultIterator.hasNext()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, "1 <", sql);
        }
        ExecutionResultType resultType = result.getType();
        if (ThrowCondition.SingleResult == throwCondition && ExecutionResultType.RESULT_SET != resultType && ExecutionResultType.ERROR_RESULT_SET != resultType) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, sql);
        }
        if (ThrowCondition.SingleRowCount == throwCondition && ExecutionResultType.ROW_COUNT != resultType && ExecutionResultType.ERROR_ROW_COUNT != resultType) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, sql);
        }
        return result;
    }

    protected void checkCondition(String sql, ThrowCondition throwCondition) throws ErrorException, SQLException {
        if (ThrowCondition.None != throwCondition) {
            IResults results = this.m_queryExecutor.getResults();
            Iterator<ExecutionResult> itr = results.getResultItr();
            if (!itr.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(0), sql);
            }
            ExecutionResult result = itr.next();
            if (itr.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, "1 <", sql);
            }
            ExecutionResultType resultType = result.getType();
            if (ThrowCondition.SingleResult == throwCondition && ExecutionResultType.RESULT_SET != resultType && ExecutionResultType.ERROR_RESULT_SET != resultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, sql);
            }
            if (ThrowCondition.SingleRowCount == throwCondition && ExecutionResultType.ROW_COUNT != resultType && ExecutionResultType.ERROR_ROW_COUNT != resultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, sql);
            }
        }
    }

    protected void checkIfNullSQL(String sql) throws SQLException {
        if (null == sql) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_SQL_STRING, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfOpen() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            if (null == this.m_statement) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STATEMENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
        }
    }

    protected void clearResults() {
        if (null != this.m_resultSets) {
            for (ResultContext context : this.m_resultSets) {
                try {
                    if (ExecutionResultType.RESULT_SET != context.m_resultType || context.m_isResultClosed) continue;
                    ((ResultSet)context.m_result).close();
                }
                catch (Exception exception) {}
            }
            this.m_resultSets.clear();
            if (null != this.m_resultIterator) {
                while (this.m_resultIterator.hasNext()) {
                    ExecutionResult e = this.m_resultIterator.next();
                    if (ExecutionResultType.RESULT_SET == e.getType()) {
                        ((IResultSet)e.getResult()).close();
                    }
                    e.getGeneratedResult().close();
                }
                this.m_resultIterator = null;
            }
        }
        this.m_currentResultSetIndex = 0;
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedResult = new DSIEmptyResultSet();
    }

    protected ResultContext createResultPair(ExecutionResult execResult) throws SQLException {
        if (ExecutionResultType.ROW_COUNT == execResult.getType()) {
            IRowCountResult rowCount = (IRowCountResult)execResult.getResult();
            return new ResultContext(rowCount);
        }
        if (ExecutionResultType.RESULT_SET == execResult.getType()) {
            ResultSet resultSet = this.createResultSet(execResult);
            return new ResultContext(resultSet);
        }
        if (ExecutionResultType.ERROR_RESULT_SET == execResult.getType()) {
            IErrorResult errorResult = (IErrorResult)execResult.getResult();
            return new ResultContext(errorResult, true);
        }
        IErrorResult errorResult = (IErrorResult)execResult.getResult();
        return new ResultContext(errorResult, false);
    }

    protected ResultSet createResultSet(ExecutionResult execResult) throws SQLException {
        return this.createResultSet((IResultSet)execResult.getResult(), this.createsUpdatableResults(), this.getFetchSize());
    }

    protected abstract ResultSet createResultSet(IResultSet var1, boolean var2, int var3) throws SQLException;

    protected boolean createsUpdatableResults() {
        return 1007 != this.m_concurrency;
    }

    @Deprecated
    protected int[] processBatchResults(IResults resultItr) throws ErrorException, SQLException {
        return this.processBatchResults(resultItr, Collections.<Pair<Integer, SQLException>>emptyList());
    }

    @Deprecated
    protected int[] processBatchResults(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) throws ErrorException, SQLException {
        return this.processBatchResults(resultItr, batchParamConversionExceptions, BatchType.UNKNOWN);
    }

    protected int[] processBatchResults(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions, BatchType batchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(batchType).processInt(resultItr, batchParamConversionExceptions);
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults resultItr) throws ErrorException, SQLException {
        return this.processLargeBatchResults(resultItr, Collections.<Pair<Integer, SQLException>>emptyList());
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) throws ErrorException, SQLException {
        return this.processLargeBatchResults(resultItr, batchParamConversionExceptions, BatchType.UNKNOWN);
    }

    protected long[] processLargeBatchResults(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions, BatchType batchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(batchType).processLong(resultItr, batchParamConversionExceptions);
    }

    protected void addToResultPair(boolean isTotalUnknown, long total) {
        if (isTotalUnknown) {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(-1L)));
        } else {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(total)));
        }
    }

    protected ExecutionResult moveToNextResult() throws SQLException {
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedParams = null;
        ExecutionResult execResult = this.m_resultIterator.next();
        this.m_generatedResult = execResult.getGeneratedResult();
        return execResult;
    }

    private void closeAllResultsToCurrent() throws SQLException {
        for (int i = 0; i < this.m_currentResultSetIndex; ++i) {
            ResultContext pair = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != pair.m_resultType || pair.m_isResultClosed) continue;
            ((ResultSet)pair.m_result).close();
        }
    }

    private IResults executeNoParams(String sql, ThrowCondition throwCondition) throws SQLException {
        return this.executeNoParams(sql, null, throwCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResults executeNoParams(String sql, ParameterGeneratedValues generatedParams, ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            IDataEngine dataEngine = this.m_statement.createDataEngine();
            dataEngine.setDirectExecute();
            if (ThrowCondition.None == throwCondition) {
                dataEngine.setMetadataNeeded(false);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                sql = this.m_parentConnection.nativeSQL(sql);
            }
            this.replaceQueryExecutor(dataEngine, dataEngine.prepare(sql));
            if (this.m_queryExecutor.getNumParams() != 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkCondition(sql, throwCondition);
            ArrayList<ArrayList<ParameterInputValue>> inputParamValues = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> metadata = new ArrayList<ParameterMetadata>();
            inputParamValues.add(new ArrayList());
            ExecutionContexts execContexts = new ExecutionContexts(metadata, inputParamValues, generatedParams);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(execContexts, this.m_warningListener);
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception e) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception e2) {
                LogUtilities.logError(e2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
            }
        }
    }

    private boolean getMoreResults(boolean closeCurrentResult) throws SQLException {
        if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
            ResultContext pair = this.m_resultSets.get(this.m_currentResultSetIndex);
            if (closeCurrentResult && ExecutionResultType.RESULT_SET == pair.m_resultType && !pair.m_isResultClosed) {
                ((ResultSet)pair.m_result).close();
            }
            if (this.m_generatedResult != null) {
                this.m_generatedResult.close();
            }
            ++this.m_currentResultSetIndex;
            if (null != this.m_resultIterator && this.m_resultIterator.hasNext()) {
                ExecutionResult er = this.moveToNextResult();
                ResultContext rc = this.createResultPair(er);
                this.addResultPair(rc);
            }
            if (this.m_resultSets.size() == this.m_currentResultSetIndex) {
                return false;
            }
            pair = this.m_resultSets.get(this.m_currentResultSetIndex);
            return ExecutionResultType.RESULT_SET == pair.m_resultType || ExecutionResultType.ERROR_RESULT_SET == pair.m_resultType;
        }
        return false;
    }

    private int getStatementPropertyInt(int key) throws SQLException {
        try {
            Variant var = this.m_statement.getProperty(key);
            return var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private long getStatementPropertyLong(int key) throws SQLException {
        try {
            Variant var = this.m_statement.getProperty(key);
            return var.getLong();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    protected void replaceQueryExecutor(IDataEngine dataEngine, IQueryExecutor queryExecutor) {
        IQueryExecutor oldQueryExecutor = this.m_queryExecutor;
        if (oldQueryExecutor != null) {
            oldQueryExecutor.close();
        }
        this.m_queryExecutor = queryExecutor;
        IDataEngine oldDataEngine = this.m_dataEngine;
        if (oldDataEngine != null) {
            oldDataEngine.close();
        }
        this.m_dataEngine = dataEngine;
    }

    private void setStatementProperty(int key, int type, Object value) throws SQLException {
        try {
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_SET_PROPERTY);
            this.m_statement.setProperty(key, new Variant(type, value));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private int castRowCount(long rowCount) {
        return rowCount > Integer.MAX_VALUE ? -2 : (int)rowCount;
    }

    private class BatchExecutionContext {
        private List<SQLException> m_exceptions = null;
        private Boolean m_stopOnError = null;
        private final ArrayList<Long> m_results = new ArrayList();
        private long m_total = 0L;
        private boolean m_isTotalUnknown = false;
        private Iterator<Pair<Integer, SQLException>> m_errorIt = null;
        private Pair<Integer, SQLException> m_nextError = null;
        private int m_batchesUntilNextError = -1;
        private final BatchType m_type;

        public BatchExecutionContext(BatchType in_type) {
            this.m_type = in_type;
        }

        public BatchExecutionContext() {
            this(BatchType.UNKNOWN);
        }

        public int[] processInt(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) throws BatchUpdateException, ErrorException {
            return (int[])this.doProcess(resultItr, batchParamConversionExceptions, false);
        }

        public long[] processLong(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) throws BatchUpdateException, ErrorException {
            return (long[])this.doProcess(resultItr, batchParamConversionExceptions, true);
        }

        private Object doProcess(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions, boolean returnLong) throws BatchUpdateException, ErrorException {
            this.collectUpdateCounts(resultItr, batchParamConversionExceptions);
            SStatement.this.addToResultPair(this.m_isTotalUnknown, this.m_total);
            return this.createResults(returnLong);
        }

        private void collectUpdateCounts(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) throws ErrorException {
            this.initIterators(resultItr, batchParamConversionExceptions);
            while (SStatement.this.m_resultIterator.hasNext() || -1 != this.m_batchesUntilNextError) {
                boolean errorOccurred;
                if (this.m_batchesUntilNextError == 0) {
                    errorOccurred = true;
                    this.processConversionError();
                } else {
                    errorOccurred = this.processExecutionResult(SStatement.this.m_resultIterator.next());
                    if (this.m_batchesUntilNextError > 0) {
                        --this.m_batchesUntilNextError;
                    }
                }
                if (!errorOccurred) continue;
                if (this.shouldStopOnError()) break;
                this.m_results.add(-3L);
            }
        }

        private Object createResults(boolean returnLong) throws BatchUpdateException {
            Object[] updateCounts = returnLong ? this.toLongArray(this.m_results) : (Object[])this.toIntArray(this.m_results);
            BatchUpdateException batchUpdateEx = this.createBatchUpdateException(updateCounts);
            if (null != batchUpdateEx) {
                throw batchUpdateEx;
            }
            return updateCounts;
        }

        private boolean shouldStopOnError() {
            if (this.m_stopOnError == null) {
                try {
                    switch (this.m_type) {
                        case MULTI_PARAM_SET: 
                        case MULTI_STATEMENT: {
                            long val = SStatement.this.m_parentConnection.getDSIConnection().getProperty(177).getLong();
                            long bitmask = BatchType.MULTI_PARAM_SET == this.m_type ? 2L : 1L;
                            this.m_stopOnError = (val & bitmask) == bitmask;
                            break;
                        }
                        case UNKNOWN: {
                            short val = DSIDriverSingleton.getInstance().getProperty(1001).getShort();
                            this.m_stopOnError = val == 1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid enum value: " + this.m_type.toString());
                        }
                    }
                }
                catch (Exception e) {
                    LogUtilities.logWarning(e, SStatement.this.getLogger());
                    this.m_stopOnError = Boolean.TRUE;
                }
            }
            return this.m_stopOnError;
        }

        private int[] toIntArray(List<Long> longList) {
            int[] result = new int[longList.size()];
            int i = 0;
            for (Long val : longList) {
                result[i++] = SStatement.longUpdateCountToInt(val);
            }
            return result;
        }

        private long[] toLongArray(List<Long> longList) {
            long[] result = new long[longList.size()];
            int i = 0;
            for (Long val : longList) {
                result[i++] = val;
            }
            return result;
        }

        BatchUpdateException createBatchUpdateException(Object results) {
            if (results instanceof int[]) {
                return SStatement.createBatchUpdateException(this.m_exceptions, (int[])results);
            }
            return SStatement.largeBatchException(this.m_exceptions, (long[])results);
        }

        private void initIterators(IResults resultItr, List<Pair<Integer, SQLException>> batchParamConversionExceptions) {
            SStatement.this.m_resultIterator = resultItr == null ? Collections.emptyList().iterator() : resultItr.getResultItr();
            this.m_errorIt = batchParamConversionExceptions.iterator();
            this.updateNextError();
        }

        private void updateNextError() {
            if (this.m_errorIt.hasNext()) {
                this.m_nextError = this.m_errorIt.next();
                this.m_batchesUntilNextError = this.m_nextError.key();
            } else {
                this.m_nextError = null;
                this.m_batchesUntilNextError = -1;
            }
        }

        private boolean processExecutionResult(ExecutionResult execResult) throws ErrorException {
            if (ExecutionResultType.ROW_COUNT == execResult.getType()) {
                long rowCount = ((IRowCountResult)execResult.getResult()).getRowCount();
                if (-1L == rowCount) {
                    this.m_results.add(-2L);
                    this.m_isTotalUnknown = true;
                } else {
                    if (rowCount < 0L) {
                        throw new RuntimeException(String.format("Invalid rowcount returned: %d", rowCount));
                    }
                    this.m_results.add(rowCount);
                    if (!this.m_isTotalUnknown) {
                        if (this.m_total <= Long.MAX_VALUE - rowCount) {
                            this.m_total += this.m_results.get(this.m_results.size() - 1).longValue();
                        } else {
                            this.m_isTotalUnknown = true;
                        }
                    }
                }
                return false;
            }
            if (ExecutionResultType.RESULT_SET == execResult.getType()) {
                SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_RETURNED, (IWarningListener)SStatement.this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                this.getExceptions().add(exception);
            } else {
                IErrorResult result = (IErrorResult)execResult.getResult();
                this.getExceptions().add(ExceptionConverter.getInstance().toSQLException(result.getError(), SStatement.this.m_warningListener));
            }
            return true;
        }

        private void processConversionError() {
            assert (this.m_nextError != null && this.m_nextError.value() != null);
            this.getExceptions().add(this.m_nextError.value());
            this.updateNextError();
        }

        private List<SQLException> getExceptions() {
            if (this.m_exceptions == null) {
                this.m_exceptions = new ArrayList<SQLException>();
            }
            return this.m_exceptions;
        }
    }

    public static enum BatchType {
        MULTI_STATEMENT,
        MULTI_PARAM_SET,
        UNKNOWN;

    }

    private static enum CheckResultType {
        None,
        CheckAfterExec,
        CheckAfterPrep;

    }

    protected static enum ThrowCondition {
        None,
        SingleResult,
        SingleRowCount;

    }

    protected static class ResultContext {
        protected ExecutionResultType m_resultType;
        protected boolean m_isResultClosed = false;
        protected Object m_result = null;

        ResultContext(IRowCountResult result) {
            this.m_resultType = ExecutionResultType.ROW_COUNT;
            this.m_result = result;
        }

        ResultContext(ResultSet result) {
            this.m_resultType = ExecutionResultType.RESULT_SET;
            this.m_result = result;
        }

        ResultContext(IErrorResult errorResult, boolean isResultSet) {
            this.m_resultType = isResultSet ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
            this.m_result = errorResult;
        }
    }
}

