/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ServerPropertiesForUpdate;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.Identity;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.Sku;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ServerForUpdate {
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private ServerPropertiesForUpdate innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public Identity identity() {
        return this.identity;
    }

    public ServerForUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerForUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ServerPropertiesForUpdate innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerForUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    public ServerForUpdate withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    public ServerForUpdate withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ServerForUpdate withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public ServerForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerForUpdate withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    public ServerForUpdate withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

