/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.Identity;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.Network;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerRestartParameter;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.mysqlflexibleserver.models.Sku;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Server {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Identity identity();

    public Sku sku();

    public SystemData systemData();

    public String administratorLogin();

    public String administratorLoginPassword();

    public ServerVersion version();

    public String availabilityZone();

    public CreateMode createMode();

    public String sourceServerResourceId();

    public OffsetDateTime restorePointInTime();

    public ReplicationRole replicationRole();

    public Integer replicaCapacity();

    public DataEncryption dataEncryption();

    public ServerState state();

    public String fullyQualifiedDomainName();

    public Storage storage();

    public Backup backup();

    public HighAvailability highAvailability();

    public Network network();

    public MaintenanceWindow maintenanceWindow();

    public Region region();

    public String regionName();

    public ServerInner innerModel();

    public Update update();

    public Server refresh();

    public Server refresh(Context var1);

    public void failover();

    public void failover(Context var1);

    public void restart(ServerRestartParameter var1);

    public void restart(ServerRestartParameter var1, Context var2);

    public void start();

    public void start(Context var1);

    public void stop();

    public void stop(Context var1);

    public static interface UpdateStages {

        public static interface WithDataEncryption {
            public Update withDataEncryption(DataEncryption var1);
        }

        public static interface WithReplicationRole {
            public Update withReplicationRole(ReplicationRole var1);
        }

        public static interface WithMaintenanceWindow {
            public Update withMaintenanceWindow(MaintenanceWindow var1);
        }

        public static interface WithHighAvailability {
            public Update withHighAvailability(HighAvailability var1);
        }

        public static interface WithBackup {
            public Update withBackup(Backup var1);
        }

        public static interface WithStorage {
            public Update withStorage(Storage var1);
        }

        public static interface WithAdministratorLoginPassword {
            public Update withAdministratorLoginPassword(String var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithAdministratorLoginPassword,
    UpdateStages.WithStorage,
    UpdateStages.WithBackup,
    UpdateStages.WithHighAvailability,
    UpdateStages.WithMaintenanceWindow,
    UpdateStages.WithReplicationRole,
    UpdateStages.WithDataEncryption {
        public Server apply();

        public Server apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithNetwork {
            public WithCreate withNetwork(Network var1);
        }

        public static interface WithHighAvailability {
            public WithCreate withHighAvailability(HighAvailability var1);
        }

        public static interface WithBackup {
            public WithCreate withBackup(Backup var1);
        }

        public static interface WithStorage {
            public WithCreate withStorage(Storage var1);
        }

        public static interface WithDataEncryption {
            public WithCreate withDataEncryption(DataEncryption var1);
        }

        public static interface WithReplicationRole {
            public WithCreate withReplicationRole(ReplicationRole var1);
        }

        public static interface WithRestorePointInTime {
            public WithCreate withRestorePointInTime(OffsetDateTime var1);
        }

        public static interface WithSourceServerResourceId {
            public WithCreate withSourceServerResourceId(String var1);
        }

        public static interface WithCreateMode {
            public WithCreate withCreateMode(CreateMode var1);
        }

        public static interface WithAvailabilityZone {
            public WithCreate withAvailabilityZone(String var1);
        }

        public static interface WithVersion {
            public WithCreate withVersion(ServerVersion var1);
        }

        public static interface WithAdministratorLoginPassword {
            public WithCreate withAdministratorLoginPassword(String var1);
        }

        public static interface WithAdministratorLogin {
            public WithCreate withAdministratorLogin(String var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithSku,
        WithAdministratorLogin,
        WithAdministratorLoginPassword,
        WithVersion,
        WithAvailabilityZone,
        WithCreateMode,
        WithSourceServerResourceId,
        WithRestorePointInTime,
        WithReplicationRole,
        WithDataEncryption,
        WithStorage,
        WithBackup,
        WithHighAvailability,
        WithNetwork {
            public Server create();

            public Server create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

