/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.BackupsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.CheckVirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.DatabasesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.FirewallRulesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.GetPrivateDnsZoneSuffixesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.LocationBasedCapabilitiesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.MySqlManagementClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.OperationsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.ServersClient;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.BackupsClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.CheckNameAvailabilitiesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.CheckVirtualNetworkSubnetUsagesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.GetPrivateDnsZoneSuffixesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.LocationBasedCapabilitiesClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.MySqlManagementClientBuilder;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.OperationsClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ServersClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MySqlManagementClientBuilder.class)
public final class MySqlManagementClientImpl
implements MySqlManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ServersClient servers;
    private final ReplicasClient replicas;
    private final BackupsClient backups;
    private final FirewallRulesClient firewallRules;
    private final DatabasesClient databases;
    private final ConfigurationsClient configurations;
    private final LocationBasedCapabilitiesClient locationBasedCapabilities;
    private final CheckVirtualNetworkSubnetUsagesClient checkVirtualNetworkSubnetUsages;
    private final CheckNameAvailabilitiesClient checkNameAvailabilities;
    private final GetPrivateDnsZoneSuffixesClient getPrivateDnsZoneSuffixes;
    private final OperationsClient operations;
    private static final ClientLogger LOGGER = new ClientLogger(MySqlManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ServersClient getServers() {
        return this.servers;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public BackupsClient getBackups() {
        return this.backups;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public LocationBasedCapabilitiesClient getLocationBasedCapabilities() {
        return this.locationBasedCapabilities;
    }

    @Override
    public CheckVirtualNetworkSubnetUsagesClient getCheckVirtualNetworkSubnetUsages() {
        return this.checkVirtualNetworkSubnetUsages;
    }

    @Override
    public CheckNameAvailabilitiesClient getCheckNameAvailabilities() {
        return this.checkNameAvailabilities;
    }

    @Override
    public GetPrivateDnsZoneSuffixesClient getGetPrivateDnsZoneSuffixes() {
        return this.getPrivateDnsZoneSuffixes;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    MySqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-05-01";
        this.servers = new ServersClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.backups = new BackupsClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.locationBasedCapabilities = new LocationBasedCapabilitiesClientImpl(this);
        this.checkVirtualNetworkSubnetUsages = new CheckVirtualNetworkSubnetUsagesClientImpl(this);
        this.checkNameAvailabilities = new CheckNameAvailabilitiesClientImpl(this);
        this.getPrivateDnsZoneSuffixes = new GetPrivateDnsZoneSuffixesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        for (Map.Entry entry : this.getContext().getValues().entrySet()) {
            context = context.addData(entry.getKey(), entry.getValue());
        }
        return context;
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

