/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.MySqlManagementClient;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.BackupsImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.CheckNameAvailabilitiesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.CheckVirtualNetworkSubnetUsagesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ConfigurationsImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.DatabasesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.FirewallRulesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.GetPrivateDnsZoneSuffixesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.LocationBasedCapabilitiesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.MySqlManagementClientBuilder;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.OperationsImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ReplicasImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ServersImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backups;
import com.azure.resourcemanager.mysqlflexibleserver.models.CheckNameAvailabilities;
import com.azure.resourcemanager.mysqlflexibleserver.models.CheckVirtualNetworkSubnetUsages;
import com.azure.resourcemanager.mysqlflexibleserver.models.Configurations;
import com.azure.resourcemanager.mysqlflexibleserver.models.Databases;
import com.azure.resourcemanager.mysqlflexibleserver.models.FirewallRules;
import com.azure.resourcemanager.mysqlflexibleserver.models.GetPrivateDnsZoneSuffixes;
import com.azure.resourcemanager.mysqlflexibleserver.models.LocationBasedCapabilities;
import com.azure.resourcemanager.mysqlflexibleserver.models.Operations;
import com.azure.resourcemanager.mysqlflexibleserver.models.Replicas;
import com.azure.resourcemanager.mysqlflexibleserver.models.Servers;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MySqlManager {
    private Servers servers;
    private Replicas replicas;
    private Backups backups;
    private FirewallRules firewallRules;
    private Databases databases;
    private Configurations configurations;
    private LocationBasedCapabilities locationBasedCapabilities;
    private CheckVirtualNetworkSubnetUsages checkVirtualNetworkSubnetUsages;
    private CheckNameAvailabilities checkNameAvailabilities;
    private GetPrivateDnsZoneSuffixes getPrivateDnsZoneSuffixes;
    private Operations operations;
    private final MySqlManagementClient clientObject;

    private MySqlManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new MySqlManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static MySqlManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return MySqlManager.configure().authenticate(credential, profile);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Servers servers() {
        if (this.servers == null) {
            this.servers = new ServersImpl(this.clientObject.getServers(), this);
        }
        return this.servers;
    }

    public Replicas replicas() {
        if (this.replicas == null) {
            this.replicas = new ReplicasImpl(this.clientObject.getReplicas(), this);
        }
        return this.replicas;
    }

    public Backups backups() {
        if (this.backups == null) {
            this.backups = new BackupsImpl(this.clientObject.getBackups(), this);
        }
        return this.backups;
    }

    public FirewallRules firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new FirewallRulesImpl(this.clientObject.getFirewallRules(), this);
        }
        return this.firewallRules;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public Configurations configurations() {
        if (this.configurations == null) {
            this.configurations = new ConfigurationsImpl(this.clientObject.getConfigurations(), this);
        }
        return this.configurations;
    }

    public LocationBasedCapabilities locationBasedCapabilities() {
        if (this.locationBasedCapabilities == null) {
            this.locationBasedCapabilities = new LocationBasedCapabilitiesImpl(this.clientObject.getLocationBasedCapabilities(), this);
        }
        return this.locationBasedCapabilities;
    }

    public CheckVirtualNetworkSubnetUsages checkVirtualNetworkSubnetUsages() {
        if (this.checkVirtualNetworkSubnetUsages == null) {
            this.checkVirtualNetworkSubnetUsages = new CheckVirtualNetworkSubnetUsagesImpl(this.clientObject.getCheckVirtualNetworkSubnetUsages(), this);
        }
        return this.checkVirtualNetworkSubnetUsages;
    }

    public CheckNameAvailabilities checkNameAvailabilities() {
        if (this.checkNameAvailabilities == null) {
            this.checkNameAvailabilities = new CheckNameAvailabilitiesImpl(this.clientObject.getCheckNameAvailabilities(), this);
        }
        return this.checkNameAvailabilities;
    }

    public GetPrivateDnsZoneSuffixes getPrivateDnsZoneSuffixes() {
        if (this.getPrivateDnsZoneSuffixes == null) {
            this.getPrivateDnsZoneSuffixes = new GetPrivateDnsZoneSuffixesImpl(this.clientObject.getGetPrivateDnsZoneSuffixes(), this);
        }
        return this.getPrivateDnsZoneSuffixes;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public MySqlManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public MySqlManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.mysqlflexibleserver").append("/").append("1.0.0-beta.2");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new MySqlManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

