/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.BlockingPopupDialog;

public abstract class AbstractPopupPanel
extends BaseDialog {
    private boolean modeless;
    private static boolean popupOpen;

    public static boolean isPopupOpen() {
        return popupOpen;
    }

    protected AbstractPopupPanel(Shell parentShell, String title) {
        super(parentShell, title, null);
    }

    @Override
    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Dialog.applyDialogFont((Control)contents);
        return contents;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        Rectangle maxBounds = Display.getCurrent().getBounds();
        initialSize.x = Math.min(initialSize.x, maxBounds.width - maxBounds.width / 50);
        return initialSize;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    protected boolean isModeless() {
        return this.modeless;
    }

    protected boolean isShowTitle() {
        return true;
    }

    public void setModeless(boolean modeless) {
        this.modeless = modeless;
        if (modeless) {
            this.setShellStyle(0x10 | (this.isShowTitle() ? 1120 : 0));
        } else {
            this.setShellStyle(68720);
        }
    }

    public int open() {
        popupOpen = true;
        try {
            int n = super.open();
            return n;
        }
        finally {
            popupOpen = false;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        if (this.modeless) {
            return UIUtils.createPlaceholder(parent, 1);
        }
        return super.createButtonBar(parent);
    }

    protected void closeOnFocusLost(Control ... controls) {
        if (this.modeless) {
            FocusAdapter focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    UIUtils.asyncExec(() -> AbstractPopupPanel.this.handleFocusLost(e));
                }
            };
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                if (ctrl != null) {
                    ctrl.addFocusListener((FocusListener)focusListener);
                }
                ++n2;
            }
        }
    }

    private void handleFocusLost(FocusEvent e) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            Control focusControl = shell.getDisplay().getFocusControl();
            if (focusControl != null && !UIUtils.isParent((Control)shell, focusControl)) {
                Object dialog = focusControl.getShell().getData();
                if (dialog instanceof BlockingPopupDialog || dialog instanceof ErrorDialog) {
                    return;
                }
                this.cancelPressed();
            }
        } else {
            this.cancelPressed();
        }
    }
}

