/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.firebirdsql.encodings.ConnectionEncodingFactory;
import org.firebirdsql.encodings.DefaultEncodingDefinition;
import org.firebirdsql.encodings.DefaultEncodingSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingGeneric;
import org.firebirdsql.encodings.EncodingSet;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.jna.BigEndianDatatypeCoder;
import org.firebirdsql.gds.ng.jna.LittleEndianDatatypeCoder;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class EncodingFactory
implements IEncodingFactory {
    private static final Logger log = LoggerFactory.getLogger(EncodingFactory.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final int MAX_NORMAL_CHARSET_ID = 255;
    private static final Comparator<EncodingSet> ENCODING_SET_COMPARATOR = new Comparator<EncodingSet>(){

        @Override
        public int compare(EncodingSet o1, EncodingSet o2) {
            return o1.getPreferenceWeight() - o2.getPreferenceWeight();
        }
    };
    public static final String ENCODING_NAME_NONE = "NONE";
    public static final String ENCODING_NAME_OCTETS = "OCTETS";
    private final Map<String, EncodingDefinition> firebirdEncodingToDefinition = new LinkedHashMap<String, EncodingDefinition>(128);
    private final EncodingDefinition[] firebirdCharacterSetIdToDefinition = new EncodingDefinition[256];
    private final Map<Charset, EncodingDefinition> javaCharsetToDefinition = new ConcurrentHashMap<Charset, EncodingDefinition>();
    private final Map<String, EncodingDefinition> javaAliasesToDefinition = new ConcurrentHashMap<String, EncodingDefinition>();
    private final Encoding defaultEncoding;
    private final EncodingDefinition defaultEncodingDefinition;
    private final ConcurrentMap<Class<? extends DatatypeCoder>, DatatypeCoder> datatypeCoderCache = new ConcurrentHashMap<Class<? extends DatatypeCoder>, DatatypeCoder>(3);

    private EncodingFactory(Iterator<EncodingSet> encodingSets) {
        while (encodingSets.hasNext()) {
            this.processEncodingSet(encodingSets.next());
        }
        this.firebirdCharacterSetIdToDefinition[127] = null;
        EncodingDefinition candidateDefinition = this.getEncodingDefinitionByCharset(DEFAULT_CHARSET);
        if (candidateDefinition != null && !candidateDefinition.isInformationOnly()) {
            this.defaultEncoding = candidateDefinition.getEncoding();
            this.defaultEncodingDefinition = candidateDefinition;
        } else {
            this.defaultEncoding = new EncodingGeneric(DEFAULT_CHARSET);
            this.defaultEncodingDefinition = new DefaultEncodingDefinition(ENCODING_NAME_NONE, DEFAULT_CHARSET, 1, 0, false);
        }
    }

    @Override
    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public static Encoding getPlatformEncoding() {
        return EncodingFactory.getRootEncodingFactory().getDefaultEncoding();
    }

    @Override
    public EncodingDefinition getDefaultEncodingDefinition() {
        return this.defaultEncodingDefinition;
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByFirebirdName(String firebirdEncodingName) {
        return firebirdEncodingName != null ? this.firebirdEncodingToDefinition.get(firebirdEncodingName.toLowerCase()) : null;
    }

    public Encoding getEncodingForFirebirdName(String firebirdEncodingName, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByFirebirdName(firebirdEncodingName), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForFirebirdName(String firebirdEncodingName) {
        return this.getEncodingForFirebirdName(firebirdEncodingName, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharacterSetId(int firebirdCharacterSetId) {
        return this.firebirdCharacterSetIdToDefinition[firebirdCharacterSetId & 0xFF];
    }

    public Encoding getEncodingForCharacterSetId(int firebirdCharacterSetId, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharacterSetId(firebirdCharacterSetId), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharacterSetId(int firebirdCharacterSetId) {
        return this.getEncodingForCharacterSetId(firebirdCharacterSetId, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharset(Charset charset) {
        EncodingDefinition encodingDefinition = this.javaCharsetToDefinition.get(charset);
        if (encodingDefinition != null) {
            return encodingDefinition;
        }
        return this.findAndMapEncodingDefinition(charset);
    }

    private EncodingDefinition findAndMapEncodingDefinition(Charset charset) {
        Set<String> potentialNames = EncodingFactory.toLowerCaseAliasSet(charset);
        for (EncodingDefinition encodingDefinition : this.firebirdEncodingToDefinition.values()) {
            String javaEncodingName = encodingDefinition.getJavaEncodingName();
            if (javaEncodingName == null || encodingDefinition.isFirebirdOnly() || !potentialNames.contains(javaEncodingName.toLowerCase())) continue;
            this.registerJavaMappingForEncodingDefinition(encodingDefinition);
            return encodingDefinition;
        }
        return null;
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharset(charset), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset) {
        return this.getEncodingForCharset(charset, null);
    }

    @Override
    public Encoding getOrCreateEncodingForCharset(Charset charset) {
        return this.getEncodingForCharset(charset, new EncodingGeneric(charset));
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharsetAlias(String charsetAlias) {
        if (charsetAlias == null) {
            return null;
        }
        EncodingDefinition encodingDefinition = this.javaAliasesToDefinition.get(charsetAlias.toLowerCase());
        if (encodingDefinition != null) {
            return encodingDefinition;
        }
        return this.resolveEncodingDefinitionByCharset(charsetAlias);
    }

    public Encoding getEncodingForCharsetAlias(String charsetAlias, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharsetAlias(charsetAlias), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharsetAlias(String charsetAlias) {
        return this.getEncodingForCharsetAlias(charsetAlias, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinition(String firebirdEncodingName, String javaCharsetAlias) {
        try {
            EncodingDefinition encodingDefinition = null;
            Charset charset = null;
            if (firebirdEncodingName != null) {
                encodingDefinition = this.getEncodingDefinitionByFirebirdName(firebirdEncodingName);
                if (javaCharsetAlias != null) {
                    charset = Charset.forName(javaCharsetAlias);
                } else if (encodingDefinition != null) {
                    charset = encodingDefinition.getJavaCharset();
                }
            } else if (javaCharsetAlias != null && (encodingDefinition = this.getEncodingDefinitionByCharsetAlias(javaCharsetAlias)) != null) {
                charset = encodingDefinition.getJavaCharset();
            }
            if (encodingDefinition == null) {
                return null;
            }
            if (!encodingDefinition.isInformationOnly() && (charset == null || encodingDefinition.getJavaCharset().equals(charset))) {
                return encodingDefinition;
            }
            if (charset != null) {
                return new DefaultEncodingDefinition(encodingDefinition.getFirebirdEncodingName(), charset, encodingDefinition.getMaxBytesPerChar(), encodingDefinition.getFirebirdCharacterSetId(), false);
            }
            if (ENCODING_NAME_NONE.equalsIgnoreCase(firebirdEncodingName)) {
                encodingDefinition = this.getDefaultEncodingDefinition();
                return new DefaultEncodingDefinition(ENCODING_NAME_NONE, encodingDefinition.getJavaCharset(), 1, 0, false);
            }
            return null;
        }
        catch (Exception e) {
            log.debug(String.format("Exception looking up encoding definition for firebirdEncodingName %s, javaCharsetAlias %s", firebirdEncodingName, javaCharsetAlias), e);
            return null;
        }
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(EncodingDefinition encodingDefinition) {
        EncodingDefinition resolvedEncodingDefinition = encodingDefinition != null && !encodingDefinition.isInformationOnly() ? encodingDefinition : this.getDefaultEncodingDefinition();
        return new ConnectionEncodingFactory(this, resolvedEncodingDefinition);
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(Charset charset) {
        return this.withDefaultEncodingDefinition(this.getEncodingDefinitionByCharset(charset));
    }

    @Override
    public <T extends DatatypeCoder> T getOrCreateDatatypeCoder(Class<T> datatypeCoderClass) {
        T newCoder;
        DatatypeCoder coder = (DatatypeCoder)this.datatypeCoderCache.get(datatypeCoderClass);
        if (coder == null && (coder = this.datatypeCoderCache.putIfAbsent((Class<? extends DatatypeCoder>)datatypeCoderClass, (DatatypeCoder)(newCoder = EncodingFactory.createNewDatatypeCoder(datatypeCoderClass, this)))) == null) {
            return newCoder;
        }
        return (T)coder;
    }

    protected static <T extends DatatypeCoder> T createNewDatatypeCoder(Class<T> datatypeCoderClass, IEncodingFactory encodingFactory) {
        if (datatypeCoderClass == DefaultDatatypeCoder.class) {
            return (T)new DefaultDatatypeCoder(encodingFactory);
        }
        if (datatypeCoderClass == LittleEndianDatatypeCoder.class) {
            return (T)new LittleEndianDatatypeCoder(encodingFactory);
        }
        if (datatypeCoderClass == BigEndianDatatypeCoder.class) {
            return (T)new BigEndianDatatypeCoder(encodingFactory);
        }
        try {
            Constructor<T> datatypeCoderConstructor = datatypeCoderClass.getConstructor(IEncodingFactory.class);
            return (T)((DatatypeCoder)datatypeCoderConstructor.newInstance(encodingFactory));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Type " + datatypeCoderClass + " has no single arg constructor accepting an IEncodingFactory");
        }
    }

    public IEncodingFactory withDefaultEncodingDefinition() {
        return this.withDefaultEncodingDefinition(this.getDefaultEncodingDefinition());
    }

    private static NavigableSet<EncodingSet> loadEncodingSets() {
        TreeSet<EncodingSet> encodingSets = new TreeSet<EncodingSet>(ENCODING_SET_COMPARATOR);
        ServiceLoader<EncodingSet> encodingSetLoader = ServiceLoader.load(EncodingSet.class, EncodingFactory.class.getClassLoader());
        Iterator<EncodingSet> encodingSetIterator = encodingSetLoader.iterator();
        while (encodingSetIterator.hasNext()) {
            try {
                EncodingSet encodingSet = encodingSetIterator.next();
                encodingSets.add(encodingSet);
            }
            catch (Exception | ServiceConfigurationError e) {
                String message = "Could not load encoding set (skipping)";
                log.error(message + ": " + e + "; see debug level for stacktrace");
                log.debug(message, e);
            }
        }
        return encodingSets;
    }

    private void processEncodingSet(EncodingSet encodingSet) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Processing EncodingSet %s with preference weight %d", encodingSet.getClass().getName(), encodingSet.getPreferenceWeight()));
        }
        for (EncodingDefinition encodingDefinition : encodingSet.getEncodings()) {
            this.processEncodingDefinition(encodingDefinition);
        }
    }

    private void processEncodingDefinition(EncodingDefinition encodingDefinition) {
        String firebirdEncodingName = encodingDefinition.getFirebirdEncodingName();
        int firebirdCharacterSetId = encodingDefinition.getFirebirdCharacterSetId();
        if (this.firebirdEncodingToDefinition.containsKey(firebirdEncodingName.toLowerCase())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skipped loading encoding definition for Firebird encoding %s, already loaded a definition for that name", firebirdEncodingName));
            }
            return;
        }
        if (firebirdCharacterSetId == 127) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skipped loading encoding definition for Firebird encoding %s, as it declared itself as the connection character set (FirebirdCharacterSetId 127 or CS_dynamic)", firebirdEncodingName));
            }
            return;
        }
        if (firebirdCharacterSetId < 0 || firebirdCharacterSetId > 255) {
            log.warn(String.format("Skipped loading encoding definition for Firebird encoding %s, as it declared itself as FirebirdCharacterSetId %d, which is outside the range [0, 255]", firebirdEncodingName, firebirdCharacterSetId));
            return;
        }
        this.firebirdEncodingToDefinition.put(firebirdEncodingName.toLowerCase(), encodingDefinition);
        this.firebirdCharacterSetIdToDefinition[firebirdCharacterSetId] = encodingDefinition;
    }

    private void registerJavaMappingForEncodingDefinition(EncodingDefinition encodingDefinition) {
        Charset charset = encodingDefinition.getJavaCharset();
        if (encodingDefinition.isInformationOnly() || encodingDefinition.isFirebirdOnly() || charset == null) {
            return;
        }
        EncodingDefinition currentEncodingDefinition = this.javaCharsetToDefinition.get(charset);
        if (currentEncodingDefinition == null) {
            this.javaCharsetToDefinition.put(charset, encodingDefinition);
            this.javaAliasesToDefinition.put(charset.name().toLowerCase(), encodingDefinition);
            for (String charsetAlias : charset.aliases()) {
                this.javaAliasesToDefinition.put(charsetAlias.toLowerCase(), encodingDefinition);
            }
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("Not mapping java charset %s to Firebird encoding %s, already mapped to Firebird encoding %s", charset.name(), encodingDefinition.getEncoding(), currentEncodingDefinition.getFirebirdEncodingName()));
        }
    }

    private Encoding returnEncodingOrFallback(EncodingDefinition encodingDefinition, Encoding fallbackEncoding) {
        if (fallbackEncoding == null) {
            fallbackEncoding = this.getDefaultEncoding();
        }
        if (encodingDefinition == null || encodingDefinition.isInformationOnly()) {
            return fallbackEncoding;
        }
        Encoding encoding = encodingDefinition.getEncoding();
        if (encoding != null) {
            return encoding;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("EncodingDefinition for Firebird encoding %s returned null for getEncoding(), using fallback encoding", encodingDefinition.getFirebirdEncodingName()));
        }
        return fallbackEncoding;
    }

    static EncodingFactory getRootEncodingFactory() {
        return DefaultEncodingFactory.ROOT_ENCODING_FACTORY;
    }

    public static IEncodingFactory getPlatformDefault() {
        return DefaultEncodingFactory.PLATFORM_DEFAULT_INSTANCE;
    }

    public static IEncodingFactory createInstance(EncodingDefinition encodingDefinition) {
        if (encodingDefinition == null || encodingDefinition.isInformationOnly()) {
            return EncodingFactory.getPlatformDefault();
        }
        return EncodingFactory.getRootEncodingFactory().withDefaultEncodingDefinition(encodingDefinition);
    }

    public static IEncodingFactory createInstance(Charset charset) {
        if (charset == null) {
            return EncodingFactory.getPlatformDefault();
        }
        return EncodingFactory.getRootEncodingFactory().withDefaultEncodingDefinition(charset);
    }

    private static EncodingFactory createInstance() {
        NavigableSet<EncodingSet> encodingSets = EncodingFactory.loadEncodingSets();
        if (encodingSets.isEmpty()) {
            log.warn("No encoding sets were loaded. Make sure at least one valid /META-INF/services/org.firebirdsql.encodings.EncodingSet exists on the classpath (it is normally part of the jaybird jar-file). Falling back to default definition.");
            encodingSets.add(new DefaultEncodingSet());
        }
        return new EncodingFactory(encodingSets.descendingIterator());
    }

    public static EncodingFactory createInstance(EncodingSet ... encodingSets) {
        TreeSet<EncodingSet> sortedEncodingSets = new TreeSet<EncodingSet>(ENCODING_SET_COMPARATOR);
        Collections.addAll(sortedEncodingSets, encodingSets);
        return new EncodingFactory(sortedEncodingSets.descendingIterator());
    }

    @Deprecated
    public static int getCharacterSetSize(int characterSetId) {
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByCharacterSetId(characterSetId);
        return encodingDefinition != null ? encodingDefinition.getMaxBytesPerChar() : 1;
    }

    @Deprecated
    public static Encoding getEncoding(String javaCharsetAlias) {
        return EncodingFactory.getRootEncodingFactory().getEncodingForCharsetAlias(javaCharsetAlias, null);
    }

    @Deprecated
    public static Encoding getEncoding(Charset charset) {
        return EncodingFactory.getRootEncodingFactory().getOrCreateEncodingForCharset(charset);
    }

    @Deprecated
    public static String getIscEncoding(String javaCharsetAlias) {
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByCharsetAlias(javaCharsetAlias);
        return encodingDefinition != null ? encodingDefinition.getFirebirdEncodingName() : null;
    }

    @Deprecated
    public static String getIscEncoding(Charset javaCharset) {
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByCharset(javaCharset);
        return encodingDefinition != null ? encodingDefinition.getFirebirdEncodingName() : null;
    }

    @Deprecated
    public static int getIscEncodingSize(String iscEncoding) {
        if (iscEncoding == null) {
            return 1;
        }
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByFirebirdName(iscEncoding);
        return encodingDefinition != null ? encodingDefinition.getMaxBytesPerChar() : 1;
    }

    @Deprecated
    public static String getJavaEncoding(String iscEncoding) {
        if (iscEncoding == null) {
            return null;
        }
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByFirebirdName(iscEncoding);
        if (encodingDefinition == null || DEFAULT_CHARSET.equals(encodingDefinition.getJavaCharset())) {
            return null;
        }
        return encodingDefinition.getJavaEncodingName();
    }

    @Deprecated
    public static String getJavaEncodingForAlias(String javaAlias) {
        EncodingDefinition encodingDefinition = EncodingFactory.getRootEncodingFactory().getEncodingDefinitionByCharsetAlias(javaAlias);
        if (encodingDefinition == null || DEFAULT_CHARSET.equals(encodingDefinition.getJavaCharset())) {
            return null;
        }
        return encodingDefinition.getJavaEncodingName();
    }

    private EncodingDefinition resolveEncodingDefinitionByCharset(String charsetAlias) {
        try {
            Charset charset = Charset.forName(charsetAlias);
            return this.getEncodingDefinitionByCharset(charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    private static Set<String> toLowerCaseAliasSet(Charset charset) {
        Set<String> aliases = charset.aliases();
        HashSet<String> potentialNames = new HashSet<String>(aliases.size() + 1);
        potentialNames.add(charset.name().toLowerCase());
        for (String alias : aliases) {
            potentialNames.add(alias.toLowerCase());
        }
        return potentialNames;
    }

    static /* synthetic */ EncodingFactory access$000() {
        return EncodingFactory.createInstance();
    }

    private static class DefaultEncodingFactory {
        private static final EncodingFactory ROOT_ENCODING_FACTORY = EncodingFactory.access$000();
        private static final IEncodingFactory PLATFORM_DEFAULT_INSTANCE = ROOT_ENCODING_FACTORY.withDefaultEncodingDefinition();

        private DefaultEncodingFactory() {
        }
    }
}

