/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model.plan;

import com.dbeaver.db.couchbase3.exec.CouchbaseSession;
import com.dbeaver.db.couchbase3.model.plan.CouchbaseExecutionPlan;
import com.dbeaver.db.couchbase3.model.plan.CouchbasePlanNode;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;

public class CouchbasePlanAnalyser
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private final DBPDataSource dataSource;

    public CouchbasePlanAnalyser(@NotNull DBPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        return CouchbasePlanAnalyser.explain((CouchbaseSession)session, query);
    }

    private static CouchbaseExecutionPlan explain(CouchbaseSession session, String query) throws DBCException {
        return new CouchbaseExecutionPlan(query, session);
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public void serialize(@NotNull Writer planData, @NotNull DBCPlan plan) throws IOException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return "Couchbase JSON";
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonObject attributes = new JsonObject();
                CouchbasePlanNode jsNode = (CouchbasePlanNode)node;
                for (Map.Entry<String, String> e : jsNode.getNodeProps().entrySet()) {
                    attributes.add(e.getKey(), (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)e.getValue())));
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws InvocationTargetException {
        JsonObject jo = (JsonObject)new Gson().fromJson(planData, JsonObject.class);
        String query = this.getQuery(jo);
        ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
        List rootNodes = loader.loadRoot(this.dataSource, jo, (datasource, node, parent) -> new CouchbasePlanNode((CouchbasePlanNode)parent, CouchbasePlanAnalyser.getNodeAttributes(node)));
        return new CouchbaseExecutionPlan(query, rootNodes);
    }

    @NotNull
    private static Map<String, String> getNodeAttributes(@NotNull JsonObject nodeObject) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        JsonObject attrs = nodeObject.getAsJsonObject("attributes");
        for (Map.Entry attr : attrs.entrySet()) {
            attributes.put((String)attr.getKey(), ((JsonElement)attr.getValue()).getAsString());
        }
        return attributes;
    }
}

