/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="createMode")
@JsonTypeName(value="Default")
public final class ServerPropertiesForDefaultCreate
extends ServerPropertiesForCreate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerPropertiesForDefaultCreate.class);
    @JsonProperty(value="administratorLogin", required=true)
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword", required=true)
    private String administratorLoginPassword;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerPropertiesForDefaultCreate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerPropertiesForDefaultCreate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withVersion(ServerVersion version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        super.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        super.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        super.withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withStorageProfile(StorageProfile storageProfile) {
        super.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.administratorLogin() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ServerPropertiesForDefaultCreate"));
        }
        if (this.administratorLoginPassword() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ServerPropertiesForDefaultCreate"));
        }
    }
}

