/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.models.ResourceIdentity;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ServerForCreate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerForCreate.class);
    @JsonProperty(value="identity")
    private ResourceIdentity identity;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties", required=true)
    private ServerPropertiesForCreate properties;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerForCreate withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerForCreate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ServerPropertiesForCreate properties() {
        return this.properties;
    }

    public ServerForCreate withProperties(ServerPropertiesForCreate properties) {
        this.properties = properties;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ServerForCreate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerForCreate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.properties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property properties in model ServerForCreate"));
        }
        this.properties().validate();
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model ServerForCreate"));
        }
    }
}

