/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresql.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresql.implementation.ServerImpl;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.Replicas;
import com.azure.resourcemanager.postgresql.models.Server;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ReplicasImpl
implements Replicas {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ReplicasImpl.class);
    private final ReplicasClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ReplicasImpl(ReplicasClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ServerImpl((ServerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ServerImpl((ServerInner)((Object)inner1), this.manager()));
    }

    private ReplicasClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

