/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.LogFilesClient;
import com.azure.resourcemanager.postgresql.fluent.models.LogFileInner;
import com.azure.resourcemanager.postgresql.implementation.LogFileImpl;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.LogFile;
import com.azure.resourcemanager.postgresql.models.LogFiles;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class LogFilesImpl
implements LogFiles {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LogFilesImpl.class);
    private final LogFilesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public LogFilesImpl(LogFilesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    private LogFilesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

