/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresql.fluent.LocationBasedPerformanceTiersClient;
import com.azure.resourcemanager.postgresql.fluent.models.PerformanceTierPropertiesInner;
import com.azure.resourcemanager.postgresql.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresql.models.PerformanceTierListResult;
import reactor.core.publisher.Mono;

public final class LocationBasedPerformanceTiersClientImpl
implements LocationBasedPerformanceTiersClient {
    private final ClientLogger logger = new ClientLogger(LocationBasedPerformanceTiersClientImpl.class);
    private final LocationBasedPerformanceTiersService service;
    private final PostgreSqlManagementClientImpl client;

    LocationBasedPerformanceTiersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (LocationBasedPerformanceTiersService)RestProxy.create(LocationBasedPerformanceTiersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PerformanceTierPropertiesInner>> listSinglePageAsync(String locationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        String apiVersion = "2017-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2017-12-01", this.client.getSubscriptionId(), locationName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PerformanceTierListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PerformanceTierPropertiesInner>> listSinglePageAsync(String locationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        String apiVersion = "2017-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2017-12-01", this.client.getSubscriptionId(), locationName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PerformanceTierListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PerformanceTierPropertiesInner> listAsync(String locationName) {
        return new PagedFlux(() -> this.listSinglePageAsync(locationName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PerformanceTierPropertiesInner> listAsync(String locationName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(locationName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PerformanceTierPropertiesInner> list(String locationName) {
        return new PagedIterable(this.listAsync(locationName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PerformanceTierPropertiesInner> list(String locationName, Context context) {
        return new PagedIterable(this.listAsync(locationName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    private static interface LocationBasedPerformanceTiersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/locations/{locationName}/performanceTiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PerformanceTierListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="locationName") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

