/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.FirewallRulesClient;
import com.azure.resourcemanager.postgresql.fluent.models.FirewallRuleInner;
import com.azure.resourcemanager.postgresql.implementation.FirewallRuleImpl;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.FirewallRule;
import com.azure.resourcemanager.postgresql.models.FirewallRules;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class FirewallRulesImpl
implements FirewallRules {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FirewallRulesImpl.class);
    private final FirewallRulesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public FirewallRulesImpl(FirewallRulesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String firewallRuleName) {
        this.serviceClient().delete(resourceGroupName, serverName, firewallRuleName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String firewallRuleName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, firewallRuleName, context);
    }

    @Override
    public FirewallRule get(String resourceGroupName, String serverName, String firewallRuleName) {
        FirewallRuleInner inner = this.serviceClient().get(resourceGroupName, serverName, firewallRuleName);
        if (inner != null) {
            return new FirewallRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<FirewallRule> getWithResponse(String resourceGroupName, String serverName, String firewallRuleName, Context context) {
        Response<FirewallRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, firewallRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FirewallRuleImpl((FirewallRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<FirewallRule> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<FirewallRuleInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new FirewallRuleImpl((FirewallRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FirewallRule> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<FirewallRuleInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new FirewallRuleImpl((FirewallRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public FirewallRule getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String firewallRuleName = Utils.getValueFromIdByName(id, "firewallRules");
        if (firewallRuleName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firewallRules'.", id)));
        }
        return (FirewallRule)this.getWithResponse(resourceGroupName, serverName, firewallRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<FirewallRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String firewallRuleName = Utils.getValueFromIdByName(id, "firewallRules");
        if (firewallRuleName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firewallRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, firewallRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String firewallRuleName = Utils.getValueFromIdByName(id, "firewallRules");
        if (firewallRuleName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firewallRules'.", id)));
        }
        this.delete(resourceGroupName, serverName, firewallRuleName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String firewallRuleName = Utils.getValueFromIdByName(id, "firewallRules");
        if (firewallRuleName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firewallRules'.", id)));
        }
        this.delete(resourceGroupName, serverName, firewallRuleName, context);
    }

    private FirewallRulesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public FirewallRuleImpl define(String name) {
        return new FirewallRuleImpl(name, this.manager());
    }
}

