/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresql.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.postgresql.implementation.ConfigurationImpl;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.Configuration;
import com.azure.resourcemanager.postgresql.models.Configurations;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ConfigurationsImpl
implements Configurations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConfigurationsImpl.class);
    private final ConfigurationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ConfigurationsImpl(ConfigurationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Configuration get(String resourceGroupName, String serverName, String configurationName) {
        ConfigurationInner inner = this.serviceClient().get(resourceGroupName, serverName, configurationName);
        if (inner != null) {
            return new ConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Configuration> getWithResponse(String resourceGroupName, String serverName, String configurationName, Context context) {
        Response<ConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationImpl((ConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Configuration getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String configurationName = Utils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return (Configuration)this.getWithResponse(resourceGroupName, serverName, configurationName, Context.NONE).getValue();
    }

    @Override
    public Response<Configuration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String configurationName = Utils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, configurationName, context);
    }

    private ConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationImpl define(String name) {
        return new ConfigurationImpl(name, this.manager());
    }
}

