/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.alts.internal.AltsAuthContext;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiFrameHandler;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AltsProtocolNegotiator
implements ProtocolNegotiator {
    private static final Logger logger = Logger.getLogger(AltsProtocolNegotiator.class.getName());
    public static final Attributes.Key<TsiPeer> TSI_PEER_KEY = Attributes.Key.create((String)"TSI_PEER");
    public static final Attributes.Key<AltsAuthContext> ALTS_CONTEXT_KEY = Attributes.Key.create((String)"ALTS_CONTEXT_KEY");
    private static final AsciiString scheme = AsciiString.of((CharSequence)"https");

    public static AltsProtocolNegotiator createClientNegotiator(final TsiHandshakerFactory handshakerFactory, final LazyChannel lazyHandshakerChannel) {
        final class ClientAltsProtocolNegotiator
        extends AltsProtocolNegotiator {
            ClientAltsProtocolNegotiator() {
            }

            public ProtocolNegotiator.Handler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                TsiHandshaker handshaker = handshakerFactory.newHandshaker(grpcHandler.getAuthority());
                return new BufferUntilAltsNegotiatedHandler(grpcHandler, new ChannelHandler[]{new TsiHandshakeHandler(new NettyTsiHandshaker(handshaker)), new TsiFrameHandler()});
            }

            public void close() {
                logger.finest("ALTS Client ProtocolNegotiator Closed");
                lazyHandshakerChannel.close();
            }
        }
        return new ClientAltsProtocolNegotiator();
    }

    public static AltsProtocolNegotiator createServerNegotiator(final TsiHandshakerFactory handshakerFactory, final LazyChannel lazyHandshakerChannel) {
        final class ServerAltsProtocolNegotiator
        extends AltsProtocolNegotiator {
            ServerAltsProtocolNegotiator() {
            }

            public ProtocolNegotiator.Handler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                TsiHandshaker handshaker = handshakerFactory.newHandshaker(null);
                return new BufferUntilAltsNegotiatedHandler(grpcHandler, new ChannelHandler[]{new TsiHandshakeHandler(new NettyTsiHandshaker(handshaker)), new TsiFrameHandler()});
            }

            public void close() {
                logger.finest("ALTS Server ProtocolNegotiator Closed");
                lazyHandshakerChannel.close();
            }
        }
        return new ServerAltsProtocolNegotiator();
    }

    @VisibleForTesting
    static final class BufferUntilAltsNegotiatedHandler
    extends ProtocolNegotiators.AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        private final GrpcHttp2ConnectionHandler grpcHandler;

        BufferUntilAltsNegotiatedHandler(GrpcHttp2ConnectionHandler grpcHandler, ChannelHandler ... negotiationhandlers) {
            super(negotiationhandlers);
            this.grpcHandler = grpcHandler;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.log(Level.FINEST, "Exception while buffering for ALTS Negotiation", cause);
            this.fail(ctx, cause);
            ctx.fireExceptionCaught(cause);
        }

        public AsciiString scheme() {
            return scheme;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "User Event triggered while negotiating ALTS", new Object[]{evt});
            }
            if (evt instanceof TsiHandshakeHandler.TsiHandshakeCompletionEvent) {
                TsiHandshakeHandler.TsiHandshakeCompletionEvent altsEvt = (TsiHandshakeHandler.TsiHandshakeCompletionEvent)evt;
                if (altsEvt.isSuccess()) {
                    if (this.grpcHandler != null) {
                        ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)this.grpcHandler);
                        AltsAuthContext altsContext = (AltsAuthContext)altsEvt.context();
                        Preconditions.checkNotNull((Object)altsContext);
                        RpcProtocolVersionsUtil.RpcVersionsCheckResult checkResult = RpcProtocolVersionsUtil.checkRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions(), altsContext.getPeerRpcVersions());
                        if (!checkResult.getResult()) {
                            String errorMessage = "Local Rpc Protocol Versions " + RpcProtocolVersionsUtil.getRpcProtocolVersions().toString() + "are not compatible with peer Rpc Protocol Versions " + altsContext.getPeerRpcVersions().toString();
                            logger.finest(errorMessage);
                            this.fail(ctx, (Throwable)Status.UNAVAILABLE.withDescription(errorMessage).asRuntimeException());
                        }
                        this.grpcHandler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(TSI_PEER_KEY, (Object)altsEvt.peer()).set(ALTS_CONTEXT_KEY, (Object)altsContext).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).build(), new InternalChannelz.Security(new InternalChannelz.OtherSecurity("alts", (Object)Any.pack((Message)altsContext.context))));
                    }
                    logger.finest("Flushing ALTS buffered data");
                    this.writeBufferedAndRemove(ctx);
                } else {
                    logger.log(Level.FINEST, "ALTS handshake failed", altsEvt.cause());
                    this.fail(ctx, BufferUntilAltsNegotiatedHandler.unavailableException("ALTS handshake failed", altsEvt.cause()));
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        private static RuntimeException unavailableException(String msg, Throwable cause) {
            return Status.UNAVAILABLE.withCause(cause).withDescription(msg).asRuntimeException();
        }
    }

    public static class LazyChannel {
        private final ObjectPool<Channel> channelPool;
        private Channel channel;

        public LazyChannel(ObjectPool<Channel> channelPool) {
            this.channelPool = channelPool;
        }

        public synchronized Channel get() {
            if (this.channel == null) {
                this.channel = (Channel)this.channelPool.getObject();
            }
            return this.channel;
        }

        public synchronized void close() {
            if (this.channel != null) {
                this.channelPool.returnObject((Object)this.channel);
            }
        }
    }
}

