/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.exec;

import com.dbeaver.ee.influxdb2.exec.Influx2BaseStatement;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.query.FluxTable;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.CommonUtils;

public class Influx2SelectStatement
extends Influx2BaseStatement {
    private static final Log log = Log.getLog(Influx2SelectStatement.class);
    private static final Pattern TZ_PATTERN = Pattern.compile("tz\\('.*?'\\)\\s*$", 2);
    private String tableName;

    public Influx2SelectStatement(Influx2Session session, Influx2Database database, String query) {
        super(session, database, query);
    }

    public Influx2SelectStatement(Influx2Session session, Influx2Database database, String query, String tableName) {
        super(session, database, query);
        this.tableName = tableName;
    }

    public boolean executeStatement() throws DBCException {
        String queryString = this.getQueryString();
        this.beforeExecute();
        try {
            Influx2Database curDatabase = this.getCurrentDatabase();
            if (curDatabase == null) {
                throw new DBCException("Can't execute query - no active database");
            }
            InfluxDBClient influxDB = this.getSession().getClient();
            List influxQueryResult = influxDB.getQueryApi().query(queryString);
            if (influxQueryResult.size() == 0) {
                this.setQueryResult(null);
                this.setTableName(this.tableName);
                return false;
            }
            FluxTable result = (FluxTable)influxQueryResult.get(0);
            if (CommonUtils.isEmpty((Collection)result.getRecords())) {
                this.setQueryResult(null);
                this.setTableName(this.tableName);
                return false;
            }
            this.setQueryResult(influxQueryResult);
            this.setTableName(this.tableName);
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

