/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model.session;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class NetezzaSession
extends AbstractServerSession {
    private long sid;
    private final long pid;
    private String userName;
    private final String dbName;
    private String schema;
    private String type;
    private Date connectTime;
    private String state;
    private String briefSqlText;
    private String priorityName;
    private long clientPid;
    private String clientIp;
    private String clientOsUsername;

    public NetezzaSession(ResultSet dbResult) {
        this.sid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SESSION_ID");
        this.pid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PID");
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USERNAME");
        this.dbName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DBNAME");
        this.schema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
        this.connectTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CONNECT_TIME");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SESSION_STATE_NAME");
        this.briefSqlText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQLTEXT");
        this.priorityName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRIORITY_NAME");
        this.clientPid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CLIENT_PID");
        this.clientIp = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_IP");
        this.clientOsUsername = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_OS_USERNAME");
    }

    @Property(viewable=true, order=1)
    public long getSid() {
        return this.sid;
    }

    @Property(viewable=true, order=2)
    public long getPid() {
        return this.pid;
    }

    @Property(viewable=true, order=3)
    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, order=4)
    public String getDbName() {
        return this.dbName;
    }

    @Property(viewable=true, order=5)
    public String getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=6)
    public Date getConnectTime() {
        return this.connectTime;
    }

    @Property(viewable=true, order=7)
    public String getState() {
        return this.state;
    }

    @Property(viewable=true, order=8)
    public String getBriefSqlText() {
        if (this.briefSqlText != null && this.briefSqlText.length() > 50) {
            return String.valueOf(CommonUtils.truncateString((String)this.briefSqlText, (int)50)) + " ...";
        }
        return this.briefSqlText;
    }

    public String getActiveQuery() {
        return this.briefSqlText;
    }

    public String getType() {
        return this.type;
    }

    public String getPriorityName() {
        return this.priorityName;
    }

    public long getClientPid() {
        return this.clientPid;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClientOsUsername() {
        return this.clientOsUsername;
    }

    public String toString() {
        if (!CommonUtils.isEmpty((String)this.dbName)) {
            return String.valueOf(this.sid) + "@" + this.dbName;
        }
        return String.valueOf(this.sid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NetezzaSession that = (NetezzaSession)((Object)o);
        return this.pid == that.pid && Objects.equals(this.dbName, that.dbName);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.dbName);
    }
}

