/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.sql;

import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPDatabaseEngine;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.gcp.sql.GCPCloudSQLBaseInstance;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.IpMapping;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public class GCPCloudSQLInstance
extends GCPCloudSQLBaseInstance {
    private static Log log = Log.getLog(GCPCloudSQLInstance.class);
    public static final GCPDatabaseEngine[] SUPPORTED_RDS_ENGINES = new GCPDatabaseEngine[]{GCPDatabaseEngine.MYSQL, GCPDatabaseEngine.POSTGRES, GCPDatabaseEngine.SQLSERVER};
    private final DatabaseInstance dbInstance;

    public GCPCloudSQLInstance(GCPCloudSession session, GCPProject project, DatabaseInstance dbInstance) {
        super(session, project);
        this.dbInstance = dbInstance;
    }

    @NotNull
    public String getNodeId() {
        return this.dbInstance.getName();
    }

    @NotNull
    public String getNodeName() {
        return this.dbInstance.getName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return this.dbInstance.getName();
    }

    @Override
    @NotNull
    public GCPCloudZone getZone() {
        return GCPCloudZone.valueOf(this.dbInstance.getRegion());
    }

    @Nullable
    public String getInstanceEndpoint() {
        for (IpMapping ip : this.dbInstance.getIpAddresses()) {
            if (!"PRIMARY".equals(ip.getType())) continue;
            return ip.getIpAddress();
        }
        return "";
    }

    @Override
    protected void setDataSourceConfiguration(DataSourceDescriptor dataSource, DBPConnectionConfiguration configuration) throws DBException {
        configuration.setHostName(this.dbInstance.getConnectionName());
        String userName = this.getInstanceUserName();
        if (userName == null) {
            userName = this.getCloudService().getInstanceDriver().getDefaultUser();
        }
        configuration.setUserName(userName);
        configuration.setDatabaseName(this.getCloudService().getInstanceDriver().getDefaultDatabase());
        configuration.setAuthModelId("gcp_sql_iam");
    }

    @Override
    protected GCPCloudService getCloudService() {
        GCPDatabaseEngine instanceEngineFamily = GCPCloudSQLInstance.getInstanceFamilyByDatabaseVersion(this.dbInstance.getDatabaseVersion());
        if (instanceEngineFamily == null) {
            log.debug((Object)("Instance backend type '" + this.dbInstance.getBackendType() + "' wasn't recognized"));
            return GCPCloudService.UNKNOWN;
        }
        return instanceEngineFamily.getCloudService();
    }

    @Nullable
    public static GCPDatabaseEngine getInstanceFamilyByDatabaseVersion(String dbVersion) {
        GCPDatabaseEngine instanceEngineFamily = null;
        GCPDatabaseEngine[] gCPDatabaseEngineArray = GCPDatabaseEngine.values();
        int n = gCPDatabaseEngineArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCPDatabaseEngine engine = gCPDatabaseEngineArray[n2];
            if (engine.matchesDatabaseVersion(dbVersion)) {
                instanceEngineFamily = engine;
                break;
            }
            ++n2;
        }
        return instanceEngineFamily;
    }

    @Override
    protected String getInstanceUserName() {
        return this.dbInstance.getOnPremisesConfiguration() == null ? null : this.dbInstance.getOnPremisesConfiguration().getUsername();
    }

    @Override
    protected String getInstanceARN() {
        return String.valueOf(this.dbInstance.getProject()) + ":" + this.dbInstance.getRegion() + ":" + this.dbInstance.getName();
    }

    @Override
    protected String getExternalLink() {
        return "https://console.cloud.google.com/sql/instances/" + this.dbInstance.getName() + "/overview?&project=" + this.dbInstance.getProject();
    }

    @Property(viewable=true, order=40)
    @NotNull
    public String getSqlInstanceIdentifier() {
        return this.getInstanceARN();
    }

    @Property(viewable=true, order=41)
    @NotNull
    public String getSqlInstanceBackendType() {
        return this.dbInstance.getBackendType();
    }

    @Property(viewable=true, order=52)
    @NotNull
    public String getSqlEngineVersion() {
        return this.dbInstance.getDatabaseVersion();
    }

    @Property(viewable=true, order=53)
    @NotNull
    public String getSqlInstanceStatus() {
        return this.dbInstance.getState();
    }

    @Property(viewable=true, order=54)
    @NotNull
    public String getSqlInstanceType() {
        return this.dbInstance.getInstanceType();
    }
}

