/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.spanner;

import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.google.api.services.spanner.v1.model.Database;
import com.google.api.services.spanner.v1.model.Instance;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.utils.CommonUtils;

public class GCPSpannerInstance
extends GCPCloudAbstractInstance {
    private Instance instance;
    private Database database;
    private String databaseName;

    public GCPSpannerInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull Instance instance, @NotNull Database database) {
        super(session, project);
        this.instance = instance;
        this.database = database;
        this.databaseName = this.getDatabaseName();
    }

    private String getDatabaseName() {
        String resultName;
        String name = this.database.getName();
        if (name.contains("/") && !name.endsWith("/") && CommonUtils.isNotEmpty((String)(resultName = name.substring(name.lastIndexOf("/") + 1)))) {
            return resultName;
        }
        return name;
    }

    @NotNull
    public String getNodeId() {
        return this.instance.getName();
    }

    @NotNull
    public String getNodeName() {
        return String.valueOf(this.instance.getDisplayName()) + "-" + this.databaseName;
    }

    @Override
    @NotNull
    public GCPCloudZone getZone() {
        String result;
        String config = this.instance.getConfig();
        if (config.contains("/regional-") && CommonUtils.isNotEmpty((String)(result = config.substring(config.lastIndexOf("/regional-") + "/regional-".length())))) {
            return GCPCloudZone.valueOf(result);
        }
        return GCPCloudZone.valueOf("us-central1");
    }

    @Override
    protected void setDataSourceConfiguration(DataSourceDescriptor dataSource, DBPConnectionConfiguration configuration) {
        configuration.setServerName(this.getFolder().getProjectId());
        configuration.setHostName(this.instance.getDisplayName());
        configuration.setDatabaseName(this.databaseName);
        configuration.setAuthModelId("gcp_cloud_iam_spanner");
    }

    @Override
    protected GCPCloudService getCloudService() {
        return GCPCloudService.SPANNER;
    }

    @Override
    protected String getInstanceARN() {
        return String.valueOf(this.instance.getName()) + ":" + this.databaseName;
    }

    @Override
    protected String getExternalLink() {
        return "https://console.cloud.google.com/spanner/instances/" + this.instance.getDisplayName() + "/databases/" + this.databaseName;
    }

    @Nullable
    public String getInstanceEndpoint() {
        return String.join((CharSequence)";", this.instance.getEndpointUris());
    }

    @Property(viewable=true, order=3)
    public String getState() {
        return this.instance.getState();
    }
}

