/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudUtils;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GCPCloudSession
implements CPCloudSession<GCPCloudZone>,
DBACredentialsProvider {
    private final SMSessionContext context;
    private final SMSession parentSession;
    private final GCPCloud cloud;
    private final String arn;
    private final AuthModelGCPCredentials iamCredentials;
    private GCPCloudZone[] useZones;
    private GCPProject[] projects;

    public GCPCloudSession(@NotNull SMSessionContext context, SMSession parentSession, @NotNull GCPCloud cloud, String arn, @NotNull AuthModelGCPCredentials iamCredentials) {
        this.context = context;
        this.parentSession = parentSession;
        this.cloud = cloud;
        this.arn = arn;
        this.iamCredentials = iamCredentials;
    }

    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.cloud;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.context;
    }

    public SMSessionPrincipal getSessionPrincipal() {
        return this.parentSession.getSessionPrincipal();
    }

    @NotNull
    public String getSessionId() {
        return this.parentSession.getSessionId();
    }

    @NotNull
    public LocalDateTime getSessionStart() {
        return this.parentSession.getSessionStart();
    }

    @NotNull
    public GCPCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public GCPCloudZone[] getDefaultZones() {
        return this.useZones;
    }

    public void setDefaultZones(@NotNull GCPCloudZone[] zones) {
        this.useZones = zones;
    }

    public String[] getDefaultZoneIds() {
        return (String[])Arrays.stream(this.useZones).map(GCPCloudZone::getZoneId).toArray(String[]::new);
    }

    public String getArn() {
        return this.arn;
    }

    public String getUserArn() {
        return this.arn;
    }

    public AuthModelGCPCredentials getCredentials() {
        return this.iamCredentials;
    }

    public void closeSession() {
        this.context.removeSession((SMSession)this);
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) {
        configuration.setRuntimeAttribute("gcp.iam_credentials", (Object)this.iamCredentials);
        return true;
    }

    @NotNull
    public String getAuthContextType() {
        return "gcp";
    }

    public GCPProject[] getAvailableProjects(DBRProgressMonitor monitor) throws DBException {
        if (this.projects == null) {
            monitor.subTask("Read GCP projects");
            AuthModelGCPCredentials credentials = this.getCredentials();
            CloudResourceManager crm = (CloudResourceManager)GCPCloudUtils.buildClient(new CloudResourceManager.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            try {
                ListProjectsResponse listProjectsResponse = (ListProjectsResponse)crm.projects().list().execute();
                if (CommonUtils.isEmpty((Collection)listProjectsResponse.getProjects())) {
                    throw new DBException("The projects list is empty. Please try to refresh your session, use another account, or another type of authorization.");
                }
                this.projects = (GCPProject[])listProjectsResponse.getProjects().stream().map(GCPProject::new).toArray(GCPProject[]::new);
            }
            catch (IOException e) {
                throw new DBException("Error reading project list", (Throwable)e);
            }
        }
        return this.projects;
    }

    public void close() {
        this.closeSession();
    }
}

