/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudUtils;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.gcp.bigquery.GCPBigQueryInstance;
import com.dbeaver.cloud.gcp.spanner.GCPSpannerInstance;
import com.dbeaver.cloud.gcp.sql.GCPCloudSQLInstance;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.google.api.services.spanner.v1.Spanner;
import com.google.api.services.spanner.v1.model.Database;
import com.google.api.services.spanner.v1.model.Instance;
import com.google.api.services.spanner.v1.model.ListDatabasesResponse;
import com.google.api.services.spanner.v1.model.ListInstancesResponse;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.InstancesListResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GCPCloudExplorer
implements CPCloudExplorer<GCPCloudZone> {
    private static final Log log = Log.getLog(GCPCloudExplorer.class);
    private final GCPCloud cloud;
    private GCPCloudSession session;

    public GCPCloudExplorer(GCPCloud cloud, GCPCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public GCPCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public GCPProject[] getRootFolders(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.session.getAvailableProjects(monitor);
    }

    @NotNull
    public GCPCloudAbstractInstance[] getDatabaseInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category) throws DBException {
        log.debug((Object)("[" + this.session.getSessionId() + "] Explore GCP zones: " + Arrays.toString(this.session.getDefaultZones())));
        try {
            GCPProject project = (GCPProject)category;
            if (project == null) {
                throw new DBException("Project not specified");
            }
            ArrayList<GCPBigQueryInstance> instances = new ArrayList<GCPBigQueryInstance>();
            try {
                List<GCPCloudAbstractInstance> regionInstances;
                switch (serviceID) {
                    case "sql": {
                        regionInstances = this.findSqlInstances(monitor, this.session, project);
                        break;
                    }
                    case "gcp-spanner": {
                        regionInstances = this.findSpannerInstances(monitor, this.session, project);
                        break;
                    }
                    case "gcp-bigquery": {
                        regionInstances = Collections.singletonList(this.findBigQueryInstance(this.session, project));
                        break;
                    }
                    default: {
                        throw new DBException("Service '" + serviceID + "' not supported yet");
                    }
                }
                instances.addAll(regionInstances);
            }
            catch (Exception e) {
                throw new DBException("Error loading " + serviceID + " instances", (Throwable)e);
            }
            return instances.toArray(new GCPCloudAbstractInstance[0]);
        }
        catch (Exception e) {
            throw new DBException("Error reading GCP instances", (Throwable)e);
        }
    }

    public GCPCloudAbstractInstance getDatabaseInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category, @NotNull GCPCloudZone zone, @NotNull String instanceId) throws DBException {
        GCPProject project = (GCPProject)category;
        if (project == null) {
            throw new DBException("Project not specified");
        }
        switch (serviceID) {
            case "sql": {
                return this.findRdsInstance(monitor, this.session, project, instanceId);
            }
            case "gcp-spanner": {
                return this.findSpannerInstance(monitor, this.session, project, instanceId);
            }
            case "gcp-bigquery": {
                return this.findBigQueryInstance(this.session, project);
            }
        }
        throw new DBException("Service '" + serviceID + "' not supported yet");
    }

    public void refreshSession(@NotNull CPCloudSession cloudSession) {
        this.session = (GCPCloudSession)cloudSession;
    }

    private List<GCPCloudSQLInstance> findSqlInstances(DBRProgressMonitor monitor, GCPCloudSession session, GCPProject project) throws DBException {
        monitor.subTask("List SQL instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            SQLAdmin sqlAdmin = (SQLAdmin)GCPCloudUtils.buildClient(new SQLAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            InstancesListResponse instancesListResponse = (InstancesListResponse)sqlAdmin.instances().list(project.getFolderId()).execute();
            ArrayList<GCPCloudSQLInstance> instances = new ArrayList<GCPCloudSQLInstance>();
            for (DatabaseInstance dbInstance : CommonUtils.safeList((List)instancesListResponse.getItems())) {
                instances.add(new GCPCloudSQLInstance(session, project, dbInstance));
            }
            return instances;
        }
        catch (IOException e) {
            throw new DBException("Error reading SQL instances", (Throwable)e);
        }
    }

    private GCPCloudSQLInstance findRdsInstance(DBRProgressMonitor monitor, GCPCloudSession session, GCPProject project, String instanceId) throws DBException {
        monitor.subTask("Find SQL instance");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            SQLAdmin sqlAdmin = (SQLAdmin)GCPCloudUtils.buildClient(new SQLAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            DatabaseInstance instance = (DatabaseInstance)sqlAdmin.instances().get(project.getFolderId(), instanceId).execute();
            return new GCPCloudSQLInstance(session, project, instance);
        }
        catch (IOException e) {
            throw new DBException("Error reading SQL instance " + instanceId, (Throwable)e);
        }
    }

    private List<GCPSpannerInstance> findSpannerInstances(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project) throws DBException {
        monitor.subTask("List Spanner instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            Spanner spannerAdmin = (Spanner)GCPCloudUtils.buildClient(new Spanner.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            ListInstancesResponse instancesResponse = (ListInstancesResponse)spannerAdmin.projects().instances().list("projects/" + project.getProjectId()).execute();
            ArrayList<GCPSpannerInstance> instances = new ArrayList<GCPSpannerInstance>();
            for (Instance instance : CommonUtils.safeCollection((Collection)instancesResponse.getInstances())) {
                ListDatabasesResponse databasesResponse = (ListDatabasesResponse)spannerAdmin.projects().instances().databases().list(instance.getName()).execute();
                List databases = databasesResponse.getDatabases();
                for (Database database : CommonUtils.safeCollection((Collection)databases)) {
                    instances.add(new GCPSpannerInstance(session, project, instance, database));
                }
            }
            return instances;
        }
        catch (IOException e) {
            throw new DBException("Error reading Spanner instances", (Throwable)e);
        }
    }

    private GCPSpannerInstance findSpannerInstance(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull String instanceId) throws DBException {
        monitor.subTask("Find Spanner instance");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            Spanner spannerAdmin = (Spanner)GCPCloudUtils.buildClient(new Spanner.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            Instance instance = (Instance)spannerAdmin.projects().instances().get(instanceId).execute();
            ListDatabasesResponse databasesResponse = (ListDatabasesResponse)spannerAdmin.projects().instances().databases().list(instance.getName()).execute();
            List databases = databasesResponse.getDatabases();
            if (!CommonUtils.isEmpty((Collection)databases)) {
                return new GCPSpannerInstance(session, project, instance, (Database)databases.get(0));
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading Spanner instance " + instanceId, (Throwable)e);
        }
        return null;
    }

    private GCPBigQueryInstance findBigQueryInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project) {
        return new GCPBigQueryInstance(session, project);
    }
}

