/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security;

import java.util.HashSet;
import java.util.Set;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMObjectPermissions;

public class SMObjectPermissionsGrant {
    private final String subjectId;
    private final SMSubjectType subjectType;
    private final SMObjectPermissions objectPermissions;

    public SMObjectPermissionsGrant(String subjectId, SMSubjectType subjectType, SMObjectPermissions objectPermissions) {
        this.subjectId = subjectId;
        this.subjectType = subjectType;
        this.objectPermissions = objectPermissions;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public SMSubjectType getSubjectType() {
        return this.subjectType;
    }

    public SMObjectPermissions getObjectPermissions() {
        return this.objectPermissions;
    }

    public static Builder builder(String subjectId, SMSubjectType subjectType, String objectId) {
        return new Builder(subjectId, subjectType, objectId);
    }

    public static final class Builder {
        private final String subjectId;
        private final SMSubjectType subjectType;
        private final String objectId;
        private final Set<String> objectPermissions = new HashSet<String>();

        public Builder(String subjectId, SMSubjectType subjectType, String objectId) {
            this.subjectId = subjectId;
            this.subjectType = subjectType;
            this.objectId = objectId;
        }

        public Builder addPermission(String permission) {
            this.objectPermissions.add(permission);
            return this;
        }

        public SMObjectPermissionsGrant build() {
            return new SMObjectPermissionsGrant(this.subjectId, this.subjectType, new SMObjectPermissions(this.objectId, Set.copyOf(this.objectPermissions)));
        }
    }
}

