-- Major schema update
-- Note: we can't drop columns to support backward compatibility when older version is run with newer workspace.

-- Deployment host information
CREATE TABLE QM_DBEAVER_HOST (
    HOST_ID INTEGER AUTO_INCREMENT NOT NULL,

    MAC_ADDRESS CHAR(12) NOT NULL,
    HOST_NAME VARCHAR(1024) NOT NULL,
    IP_ADDRESS VARCHAR(48) NOT NULL,

    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (HOST_ID),
    UNIQUE (MAC_ADDRESS)
);

INSERT INTO QM_DBEAVER_HOST(HOST_ID, MAC_ADDRESS, HOST_NAME, IP_ADDRESS, UPDATE_TIME)
    VALUES (0, '000000000000', 'localhost', '127.0.0.1', CURRENT_TIMESTAMP);

-- User information
CREATE TABLE QM_USER (
    USER_ID INTEGER AUTO_INCREMENT NOT NULL,

    DOMAIN_NAME VARCHAR(128) NOT NULL,
    USER_NAME VARCHAR(255) NOT NULL,

    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (USER_ID),
    UNIQUE (DOMAIN_NAME,USER_NAME)
);

INSERT INTO QM_USER(USER_ID, USER_NAME, DOMAIN_NAME, UPDATE_TIME)
    VALUES (0, 'unknown', 'unknown', CURRENT_TIMESTAMP);

ALTER TABLE QM_DBEAVER_DEPLOYMENT ALTER COLUMN HOST_NAME SET NULL;
ALTER TABLE QM_DBEAVER_DEPLOYMENT ADD HOST_ID INTEGER NOT NULL DEFAULT 0;
ALTER TABLE QM_DBEAVER_DEPLOYMENT ADD PORT_NUMBER INTEGER NOT NULL DEFAULT 0;
ALTER TABLE QM_DBEAVER_DEPLOYMENT ADD UNIQUE (HOST_ID,INSTALL_PATH);

ALTER TABLE QM_DBEAVER_VERSION ADD PRODUCT_NAME VARCHAR(64) NOT NULL DEFAULT 'DBeaver';
ALTER TABLE QM_DBEAVER_VERSION ALTER COLUMN UPDATE_DEPLOY_ID SET NULL;

ALTER TABLE QM_DBEAVER_WORKSPACE ADD HOST_ID INTEGER NOT NULL DEFAULT 0;
ALTER TABLE QM_DBEAVER_WORKSPACE ADD UNIQUE (HOST_ID,WORKSPACE_PATH);
ALTER TABLE QM_DBEAVER_WORKSPACE ADD FOREIGN KEY (HOST_ID) REFERENCES QM_DBEAVER_HOST(HOST_ID);

ALTER TABLE QM_DBEAVER_RUN ALTER COLUMN HOST_NAME SET NULL;
ALTER TABLE QM_DBEAVER_RUN ADD USER_ID INTEGER NOT NULL DEFAULT 0;

CREATE TABLE QM_USER_SESSION (
    SESSION_ID BIGINT AUTO_INCREMENT NOT NULL,

    RUN_ID INTEGER NOT NULL,
    APP_SESSION_ID VARCHAR(64) NOT NULL,     -- Application-specific session ID. Unique within application run.

    USER_ID INTEGER NOT NULL,

    START_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (SESSION_ID),
    UNIQUE (RUN_ID,APP_SESSION_ID),
    FOREIGN KEY (USER_ID) REFERENCES QM_USER(USER_ID),
    FOREIGN KEY (RUN_ID) REFERENCES QM_DBEAVER_RUN(RUN_ID)
);

-- We can not change datasource primary key here.
-- We do this in QM model
ALTER TABLE QM_DATASOURCE ADD WORKSPACE_ID INTEGER NOT NULL DEFAULT 1;
ALTER TABLE QM_DATASOURCE ADD FOREIGN KEY (WORKSPACE_ID) REFERENCES QM_DBEAVER_WORKSPACE(WORKSPACE_ID);

ALTER TABLE QM_CONNECTION ADD SESSION_ID BIGINT;
ALTER TABLE QM_CONNECTION ADD WORKSPACE_ID INTEGER NOT NULL DEFAULT 1;
ALTER TABLE QM_CONNECTION ADD FOREIGN KEY (SESSION_ID) REFERENCES QM_USER_SESSION(SESSION_ID);
