/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskWizardPageSettings
extends ActiveWizardPage<DCCompareTaskWizard> {
    private Button openViewerOnFinishCheckbox;
    private Button saveOutputToFileCheckbox;
    private TextWithOpenFile outputFileText;
    private Text comparedRowsLimitText;
    private Text differentRowsLimitText;
    private Text fetchSizeText;
    private Button showModifiedRowsCheckbox;
    private Button showDeletedRowsCheckbox;
    private Button showInsertedRowsCheckbox;
    private Button openNewConnectionCheckbox;
    private Button queryRowsCountCheckbox;

    protected DCCompareTaskWizardPageSettings() {
        super(DCMessages.data_compare_wizard_name);
        this.setTitle(DCMessages.data_compare_wizard_settings_title);
        this.setDescription(DCMessages.data_compare_wizard_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)DCMessages.data_compare_wizard_settings_group_general_title, (int)2, (int)2, (int)0);
        this.openViewerOnFinishCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_open_compare_viewer_label, (String)DCMessages.data_compare_wizard_settings_group_general_open_compare_viewer_tip, (boolean)false, (int)2);
        this.openViewerOnFinishCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenViewerOnFinish(DCCompareTaskWizardPageSettings.this.openViewerOnFinishCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.saveOutputToFileCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_export_to_file_label, (String)DCMessages.data_compare_wizard_settings_group_general_export_to_file_tip, (boolean)false, (int)2);
        this.saveOutputToFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DCCompareTaskWizardPageSettings.this.outputFileText.setEnabled(DCCompareTaskWizardPageSettings.this.saveOutputToFileCheckbox.getSelection());
                settings.setOutputFilePath(DCCompareTaskWizardPageSettings.this.saveOutputToFileCheckbox.getSelection() ? DCCompareTaskWizardPageSettings.this.outputFileText.getText() : null);
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_output_file_label);
        this.outputFileText = new TextWithOpenFile((Composite)group, DCMessages.data_compare_wizard_settings_group_general_output_file_title, new String[]{"*.sql"}, 8196);
        this.outputFileText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(UIUtils.getFontHeight((Control)group) * 50, -1).create());
        this.outputFileText.getTextControl().addModifyListener(e -> {
            settings.setOutputFilePath(CommonUtils.isEmptyTrimmed((String)this.outputFileText.getText()) ? null : this.outputFileText.getText());
            this.updatePageCompletion();
        });
        group = UIUtils.createControlGroup((Composite)composite, (String)DCMessages.data_compare_wizard_settings_group_performance_title, (int)2, (int)2, (int)0);
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_compared_rows_limit_label);
        this.comparedRowsLimitText = new Text((Composite)group, 2048);
        this.comparedRowsLimitText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(UIUtils.getFontHeight((Control)group) * 10, -1).create());
        this.comparedRowsLimitText.setToolTipText(DCMessages.data_compare_wizard_settings_group_performance_compared_rows_limit_tip);
        this.comparedRowsLimitText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.comparedRowsLimitText.addModifyListener(e -> {
            String text = this.comparedRowsLimitText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setComparedRowsLimit(CommonUtils.toLong((Object)text));
            }
            this.updatePageCompletion();
        });
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_different_rows_limit_label);
        this.differentRowsLimitText = new Text((Composite)group, 2048);
        this.differentRowsLimitText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(UIUtils.getFontHeight((Control)group) * 10, -1).create());
        this.differentRowsLimitText.setToolTipText(DCMessages.data_compare_wizard_settings_group_performance_different_rows_limit_tip);
        this.differentRowsLimitText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.differentRowsLimitText.addModifyListener(e -> {
            String text = this.differentRowsLimitText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setDifferentRowsLimit(CommonUtils.toLong((Object)text));
            }
            this.updatePageCompletion();
        });
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_fetch_size_label);
        this.fetchSizeText = new Text((Composite)group, 2048);
        this.fetchSizeText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(UIUtils.getFontHeight((Control)group) * 10, -1).create());
        this.fetchSizeText.setToolTipText(DCMessages.data_compare_wizard_settings_group_performance_fetch_size_tip);
        this.fetchSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.fetchSizeText.addModifyListener(e -> {
            String text = this.fetchSizeText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setFetchSize(CommonUtils.toInt((Object)text));
            }
            this.updatePageCompletion();
        });
        this.showModifiedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_show_modified_rows_label, (String)DCMessages.data_compare_wizard_settings_group_performance_show_modified_rows_tip, (boolean)false, (int)2);
        this.showModifiedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeModifiedRows(DCCompareTaskWizardPageSettings.this.showModifiedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.showDeletedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_show_deleted_rows_label, (String)DCMessages.data_compare_wizard_settings_group_performance_show_deleted_rows_tip, (boolean)false, (int)2);
        this.showDeletedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeDeletedRows(DCCompareTaskWizardPageSettings.this.showDeletedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.showInsertedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_show_inserted_rows_label, (String)DCMessages.data_compare_wizard_settings_group_performance_show_inserted_rows_tip, (boolean)false, (int)2);
        this.showInsertedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeInsertedRows(DCCompareTaskWizardPageSettings.this.showInsertedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.openNewConnectionCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_open_new_connections_label, (String)DCMessages.data_compare_wizard_settings_group_performance_open_new_connections_tip, (boolean)false, (int)2);
        this.openNewConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(DCCompareTaskWizardPageSettings.this.openNewConnectionCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.queryRowsCountCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_query_rows_count_label, (String)DCMessages.data_compare_wizard_settings_group_performance_query_rows_count_tip, (boolean)false, (int)2);
        this.queryRowsCountCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setQueryRowsCount(DCCompareTaskWizardPageSettings.this.queryRowsCountCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        String outputFile = settings.getOutputFilePath();
        this.openViewerOnFinishCheckbox.setSelection(settings.isOpenViewerOnFinish());
        this.saveOutputToFileCheckbox.setSelection(outputFile != null);
        this.outputFileText.setEnabled(outputFile != null);
        this.outputFileText.setText(outputFile != null ? outputFile : "");
        this.comparedRowsLimitText.setText(String.valueOf(settings.getComparedRowsLimit()));
        this.differentRowsLimitText.setText(String.valueOf(settings.getDifferentRowsLimit()));
        this.fetchSizeText.setText(String.valueOf(settings.getFetchSize()));
        this.showModifiedRowsCheckbox.setSelection(settings.isIncludeModifiedRows());
        this.showDeletedRowsCheckbox.setSelection(settings.isIncludeDeletedRows());
        this.showInsertedRowsCheckbox.setSelection(settings.isIncludeInsertedRows());
        this.openNewConnectionCheckbox.setSelection(settings.isOpenNewConnections());
        this.queryRowsCountCheckbox.setSelection(settings.isQueryRowsCount());
        this.updatePageCompletion();
    }

    public void performHelp() {
        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        ((DCCompareTaskWizard)this.getWizard()).updateSaveTaskButtons();
    }

    protected boolean determinePageCompletion() {
        if (!this.openViewerOnFinishCheckbox.getSelection() && !this.saveOutputToFileCheckbox.getSelection()) {
            this.setErrorMessage("Either choose to open viewer or to export diff");
            return false;
        }
        if (this.saveOutputToFileCheckbox.getSelection() && CommonUtils.isEmptyTrimmed((String)this.outputFileText.getText())) {
            this.setErrorMessage("Output file path cannot be empty");
            return false;
        }
        return !CommonUtils.isEmpty((String)this.comparedRowsLimitText.getText()) && !CommonUtils.isEmpty((String)this.differentRowsLimitText.getText()) && !CommonUtils.isEmpty((String)this.fetchSizeText.getText()) && (this.showModifiedRowsCheckbox.getSelection() || this.showDeletedRowsCheckbox.getSelection() || this.showInsertedRowsCheckbox.getSelection());
    }
}

