/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Utility {
    public static final int HELP_SESSION_CURRENT_DATABASE_INDEX = 5;
    public static final int HELP_SESSION_FULL_CURRENT_DATABASE_INDEX = 75;
    public static final int HELP_SESSION_QUERY_BAND_INDEX = 44;
    public static final int HELP_SESSION_TRANSACTION_QUERY_BAND_INDEX = 122;
    public static final int HELP_SESSION_SESSION_QUERY_BAND_INDEX = 123;
    public static final int HELP_SESSION_PROFILE_QUERY_BAND_INDEX = 124;
    public static final int HELP_SESSION_UNICODE_PASS_THROUGH_INDEX = 125;
    public static final int QUERY_BAND_TRANSACTION_INDEX = 0;
    public static final int QUERY_BAND_SESSION_INDEX = 1;
    public static final int QUERY_BAND_PROFILE_INDEX = 2;
    private static HostnameVerifier sm_trustAllHosts = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };
    private static SecureRandom sm_rand = new SecureRandom();

    public static String getCurrentDatabaseFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        int n = resultSet.getMetaData().getColumnCount();
        if (n >= 75) {
            return resultSet.getString(75);
        }
        if (n >= 5) {
            return resultSet.getString(5);
        }
        return "";
    }

    public static String getQueryBandFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        String string = "";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 44) {
            string = resultSet.getString(44);
        }
        return string;
    }

    public static String[] parseQueryBand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("queryBand argument must not be null");
        }
        String[] stringArray = new String[]{"", "", ""};
        if (!string.equals("")) {
            String string2 = "=T> ";
            String string3 = "=S> ";
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n >= 0 && n2 >= 0) {
                if (n < n2) {
                    stringArray[0] = string.substring(n + string2.length(), n2).trim();
                    stringArray[1] = string.substring(n2 + string3.length()).trim();
                } else {
                    stringArray[0] = string.substring(n + string2.length()).trim();
                    stringArray[1] = string.substring(n2 + string3.length(), n).trim();
                }
            } else if (n >= 0) {
                stringArray[0] = string.substring(n + string2.length()).trim();
            } else if (n2 >= 0) {
                stringArray[1] = string.substring(n2 + string3.length()).trim();
            }
        }
        return stringArray;
    }

    public static void tokenizeQueryBand(Map map, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n < 0) continue;
            map.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
    }

    public static void sleepForSeconds(int n) {
        long l = (long)n * 1000L;
        Utility.sleepForMilliseconds(l);
    }

    public static void sleepForMilliseconds(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            sQLException.setNextException(sQLException2);
        }
        return sQLException;
    }

    public static String[] getQueryBandStringsFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 124) {
            String[] stringArray = new String[]{resultSet.getString(122), resultSet.getString(123), resultSet.getString(124)};
            return stringArray;
        }
        String string = resultSetMetaData.getColumnCount() >= 44 ? resultSet.getString(44) : "";
        return Utility.parseQueryBand(string);
    }

    public static boolean getUnicodePassThroughFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        if (resultSet.getMetaData().getColumnCount() < 125) {
            return false;
        }
        String string = resultSet.getString(125);
        if (string == null) {
            return false;
        }
        return string.trim().equals("S");
    }

    public static SQLException wrapEx(Throwable throwable, SQLException sQLException) {
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static SQLException logEx(Log log, String string, SQLException sQLException) {
        if (log.isDebugEnabled()) {
            for (Throwable throwable = sQLException; throwable != null; throwable = throwable.getCause()) {
                log.debug(string + ": " + (throwable != sQLException ? "Caused by " : "") + throwable, null);
            }
        }
        return sQLException;
    }

    public static String getHTTPSProtocol(URLParameters uRLParameters) {
        String string = uRLParameters.getSSLProtocol();
        if (string == null) {
            string = "TLSv1.2";
        }
        return string;
    }

    public static SSLSocketFactory obtainSSLSocketFactory(URLParameters uRLParameters, String[] stringArray, Log log) throws SQLException {
        SSLContext sSLContext;
        if (uRLParameters.getSSLDebug()) {
            System.setProperty("javax.net.debug", "ssl:handshake");
        }
        String string = Utility.getHTTPSProtocol(uRLParameters);
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: sHTTPSProtocol=" + string);
        }
        try {
            sSLContext = SSLContext.getInstance(string);
            sSLContext.init(null, new TrustManager[]{new MinimalTrustManager(stringArray)}, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Utility.logEx(log, "obtainSSLSocketFactory", Utility.wrapEx(generalSecurityException, ErrorFactory.makeDriverJDBCException("TJ1555", string)));
        }
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: sm_socketFactory.getDefaultCipherSuites=" + Arrays.asList(sSLSocketFactory.getDefaultCipherSuites()));
        }
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doHttpRequest(URLParameters uRLParameters, Log log, String string, String string2, String[][] stringArray, byte[] byArray, boolean bl, String string3, int[] nArray) throws SQLException {
        HttpResponse httpResponse;
        block24: {
            HttpResponse httpResponse2 = new HttpResponse();
            long l = System.currentTimeMillis();
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            if (httpURLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(Utility.obtainSSLSocketFactory(uRLParameters, null, log));
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(sm_trustAllHosts);
            }
            if (byArray != null) {
                httpURLConnection.setDoOutput(true);
            }
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setRequestProperty("Accept", "*/*");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                httpURLConnection.setRequestProperty(stringArray[i][0], stringArray[i][1]);
            }
            if (byArray != null) {
                httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
            }
            httpURLConnection.connect();
            if (byArray != null) {
                OutputStream outputStream = httpURLConnection.getOutputStream();
                try {
                    outputStream.write(byArray);
                }
                finally {
                    outputStream.close();
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            try {
                String string4;
                StringBuffer stringBuffer = new StringBuffer();
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (bl) {
                        string4 = string4.trim();
                    }
                    if (stringBuffer.length() > 0 && string3 != null) {
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append(string4);
                }
                httpResponse2.nCode = httpURLConnection.getResponseCode();
                httpResponse2.sMessage = httpURLConnection.getResponseMessage();
                httpResponse2.sBody = stringBuffer.toString();
                if (nArray != null) {
                    boolean bl2 = false;
                    for (int i = 0; !bl2 && i < nArray.length; ++i) {
                        bl2 = httpResponse2.nCode == nArray[i];
                    }
                    if (!bl2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ1549", "" + httpResponse2.nCode, string2);
                    }
                }
                httpResponse = httpResponse2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var19_23 = null;
                        if (log.isTimingEnabled()) {
                            log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse2.nCode < 0 ? "failed" : "completed with " + httpResponse2.nCode + " " + httpResponse2.sMessage));
                        }
                        throw throwable2;
                    }
                }
                catch (IOException iOException) {
                    throw Utility.logEx(log, "doHttpRequest", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1543", string2)));
                }
            }
            bufferedReader.close();
            {
                Object var19_22 = null;
                if (!log.isTimingEnabled()) break block24;
                log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse2.nCode < 0 ? "failed" : "completed with " + httpResponse2.nCode + " " + httpResponse2.sMessage));
            }
        }
        return httpResponse;
    }

    public static String getStringFromJSON(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        Pattern pattern = Pattern.compile("\"" + string + "\"\\s*:\\s*\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(string2);
        String string6 = string5 = matcher.find() ? matcher.group(1) : null;
        if (string5 == null && string3 != null) {
            throw ErrorFactory.makeDriverJDBCException(string3, string, string4);
        }
        return string5;
    }

    public static void waitForThreadDeath(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String safeForURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        sm_rand.nextBytes(byArray);
        return byArray;
    }

    public static String base64Encode(boolean bl, byte[] byArray) {
        int n = byArray.length * 8 % 6;
        int n2 = n == 0 ? 0 : 1;
        int n3 = byArray.length * 8 / 6 + n2;
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 1;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        String string = new BigInteger(byArray2).toString(2).substring(1);
        if (n == 2) {
            string = string + "0000";
        }
        if (n == 4) {
            string = string + "00";
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(string.substring(i * 6, (i + 1) * 6), 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n4 < 26) {
                stringBuffer.append((char)(n4 + 65));
                continue;
            }
            if (n4 < 52) {
                stringBuffer.append((char)(n4 - 26 + 97));
                continue;
            }
            if (n4 < 62) {
                stringBuffer.append((char)(n4 - 52 + 48));
                continue;
            }
            if (n4 == 62) {
                stringBuffer.append(bl ? (char)'-' : '+');
                continue;
            }
            stringBuffer.append(bl ? (char)'_' : '/');
        }
        if (!bl && n == 2) {
            stringBuffer.append("==");
        }
        if (!bl && n == 4) {
            stringBuffer.append("=");
        }
        return stringBuffer.toString();
    }

    public static byte[] hashBytes(Log log, String string, byte[] byArray) throws SQLException {
        try {
            return MessageDigest.getInstance(string).digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Utility.logEx(log, "hashBytes", Utility.wrapEx(noSuchAlgorithmException, ErrorFactory.makeDriverJDBCException("TJ215", string)));
        }
    }

    public static class HttpResponse {
        public int nCode = -1;
        public String sMessage = null;
        public String sBody = null;
    }

    private static class MinimalTrustManager
    implements X509TrustManager {
        private String[] m_asAuthType;

        public MinimalTrustManager(String[] stringArray) {
            this.m_asAuthType = stringArray;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            if (this.m_asAuthType != null && this.m_asAuthType.length > 0) {
                this.m_asAuthType[0] = string;
            }
        }
    }
}

