/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log log = new Log("TeraDriver/" + (class$com$teradata$jdbc$TeraDriver == null ? (class$com$teradata$jdbc$TeraDriver = TeraDriver.class$("com.teradata.jdbc.TeraDriver")) : class$com$teradata$jdbc$TeraDriver).getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    static /* synthetic */ Class class$com$teradata$jdbc$TeraDriver;

    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)((Object)connection);
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    public int getMajorVersion() {
        return 17;
    }

    public int getMinorVersion() {
        return 10;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)((Object)clob);
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)((Object)blob);
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        Object object;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)((Object)currentThreadIO.getConnection())).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (object = (TDResultSet)((Object)resultSetArray[i])) == null || ((TDResultSet)object).isClosed()) continue;
            long l = ((TDResultSet)object).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)object).getRequestNumber() + " stmtnum=" + ((TDResultSet)object).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)object).getStatementNumber(), ((TDResultSet)object).getRequestNumber(), l));
            ((TDResultSet)object).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        object = (TDStatement)((Object)tDSession.createStatement());
        StatementController statementController = new StatementController((TDStatement)object, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + (string2 == null ? "null" : TeraDriver.quoteText(string2));
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws IOException, SQLException {
        if (stringArray.length == 0) {
            System.err.println("Arguments: Command...");
            System.err.println("version prints the Teradata JDBC Driver version");
            System.err.println("echo:message prints the specified message");
            System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
            System.err.println("props:null specifies null Properties for DriverManager.getConnection (the default)");
            System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
            System.err.println("props:list prints the Properties for DriverManager.getConnection");
            System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
            System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
            System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
            System.err.println("input:filename reads commands from the specified file until EOF");
            System.err.println("output:stdout sends output to System.out (the default)");
            System.err.println("output:filename sends output to specified file");
            System.err.println("format:text formats output as text (the default)");
            System.err.println("format:raw avoids formatting output");
            System.err.println("format:csv formats output as comma-separated values");
            System.err.println("System.setProperty:name=value sets the System property name to value");
            System.err.println("System.getProperty:name prints the specified System property");
            System.err.println("System.getProperties prints the Properties from System.getProperties");
            System.err.println("Security.setProperty:name=value sets the Security property name to value");
            System.err.println("Security.getProperty:name prints the specified Security property");
            System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
            System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
            System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
            System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
            System.err.println("Otherwise Statement.execute is called for the command");
            return;
        }
        int n = 1;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        BufferedReader bufferedReader2 = null;
        try {
            PrintWriter printWriter;
            PrintWriter printWriter2 = printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            try {
                Connection connection = null;
                try {
                    Properties properties = null;
                    int n2 = 0;
                    block17: while (true) {
                        Object object;
                        String string = "";
                        if (bufferedReader2 != null && (string = bufferedReader2.readLine()) == null) {
                            if (bufferedReader2 != bufferedReader) {
                                bufferedReader2.close();
                            }
                            bufferedReader2 = null;
                        }
                        if (bufferedReader2 == null) {
                            if (n2 >= stringArray.length) break;
                            string = stringArray[n2++];
                        }
                        if (string.equals("version")) {
                            TeraDriver.printNameValue(printWriter2, n, string, Const.DRIVER_VERSION);
                            continue;
                        }
                        if (string.startsWith("echo:")) {
                            object = string.substring("echo:".length());
                            printWriter2.println((String)object);
                            continue;
                        }
                        if (string.startsWith("prop:")) {
                            object = Pattern.compile("prop:([^=]+)=(.*)").matcher(string);
                            if (!((Matcher)object).matches()) {
                                throw new IllegalArgumentException(string);
                            }
                            if (properties == null) {
                                properties = new Properties();
                            }
                            properties.setProperty(((Matcher)object).group(1), ((Matcher)object).group(2));
                            continue;
                        }
                        if (string.startsWith("props:")) {
                            object = string.substring("props:".length());
                            if (((String)object).equals("null")) {
                                properties = null;
                                continue;
                            }
                            if (((String)object).equals("new")) {
                                properties = new Properties();
                                continue;
                            }
                            if (((String)object).equals("list")) {
                                TeraDriver.printProps(printWriter2, n, properties);
                                continue;
                            }
                            properties = new Properties();
                            FileInputStream fileInputStream = new FileInputStream((String)object);
                            try {
                                properties.load(fileInputStream);
                            }
                            finally {
                                fileInputStream.close();
                            }
                            continue;
                        }
                        if (string.startsWith("jdbc:")) {
                            if (connection != null) {
                                object = connection;
                                connection = null;
                                object.close();
                            }
                            connection = DriverManager.getConnection(string, properties);
                            TeraDriver.printArray(printWriter2, n, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {connection.isClosed() ? "Closed" : "Connected", connection.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), connection.getMetaData().getDatabaseProductVersion(), connection.isClosed() ? null : connection.nativeSQL("{fn teradata_session_number}")}});
                            continue;
                        }
                        if (string.startsWith("input:")) {
                            object = string.substring("input:".length());
                            if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                                bufferedReader2.close();
                            }
                            bufferedReader2 = null;
                            if (((String)object).equals("stdin")) {
                                bufferedReader2 = bufferedReader;
                                continue;
                            }
                            bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)object), "UTF-8"));
                            continue;
                        }
                        if (string.startsWith("output:")) {
                            object = string.substring("output:".length());
                            if (printWriter2 != printWriter) {
                                printWriter2.close();
                            }
                            printWriter2 = printWriter;
                            if (((String)object).equals("stdout")) continue;
                            printWriter2 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), "UTF-8"), true);
                            continue;
                        }
                        if (string.startsWith("format:")) {
                            object = string.substring("format:".length());
                            if (((String)object).equals("text")) {
                                n = 1;
                                continue;
                            }
                            if (((String)object).equals("raw")) {
                                n = 2;
                                continue;
                            }
                            if (!((String)object).equals("csv")) throw new IllegalArgumentException("Unknown format " + (String)object);
                            n = 3;
                            continue;
                        }
                        if (string.startsWith("System.setProperty:")) {
                            object = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(string);
                            if (!((Matcher)object).matches()) {
                                throw new IllegalArgumentException(string);
                            }
                            System.setProperty(((Matcher)object).group(1), ((Matcher)object).group(2));
                            continue;
                        }
                        if (string.startsWith("System.getProperty:")) {
                            object = string.substring("System.getProperty:".length());
                            TeraDriver.printNameValue(printWriter2, n, (String)object, System.getProperty((String)object));
                            continue;
                        }
                        if (string.equals("System.getProperties")) {
                            TeraDriver.printProps(printWriter2, n, System.getProperties());
                            continue;
                        }
                        if (string.startsWith("Security.setProperty:")) {
                            object = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(string);
                            if (!((Matcher)object).matches()) {
                                throw new IllegalArgumentException(string);
                            }
                            Security.setProperty(((Matcher)object).group(1), ((Matcher)object).group(2));
                            continue;
                        }
                        if (string.startsWith("Security.getProperty:")) {
                            object = string.substring("Security.getProperty:".length());
                            TeraDriver.printNameValue(printWriter2, n, (String)object, Security.getProperty((String)object));
                            continue;
                        }
                        if (connection == null) {
                            throw new IllegalArgumentException("No connection available for " + string);
                        }
                        if (string.equals("getDatabaseProductVersion")) {
                            TeraDriver.printNameValue(printWriter2, n, string, connection.getMetaData().getDatabaseProductVersion());
                            continue;
                        }
                        if (string.equals("getDriverVersion")) {
                            TeraDriver.printNameValue(printWriter2, n, string, connection.getMetaData().getDriverVersion());
                            continue;
                        }
                        if (string.equals("getURL")) {
                            TeraDriver.printNameValue(printWriter2, n, string, connection.getMetaData().getURL());
                            continue;
                        }
                        if (string.startsWith("nativeSQL:")) {
                            TeraDriver.printNameValue(printWriter2, n, "nativeSQL", connection.nativeSQL(string.substring("nativeSQL:".length())));
                            continue;
                        }
                        object = connection.createStatement();
                        try {
                            boolean bl = object.execute(string);
                            while (true) {
                                if (!bl && object.getUpdateCount() == -1) continue block17;
                                if (bl) {
                                    ResultSet resultSet = object.getResultSet();
                                    try {
                                        int n3;
                                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                                        if (n == 3) {
                                            for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                                                TeraDriver.printValue(printWriter2, n, false, n3, resultSetMetaData.getColumnCount(), null, resultSetMetaData.getColumnName(n3));
                                            }
                                        }
                                        while (resultSet.next()) {
                                            for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                                                String string2 = "Row " + resultSet.getRow() + " Column " + n3 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n3)) + " " + resultSetMetaData.getColumnTypeName(n3) + "(" + resultSetMetaData.getPrecision(n3) + ")";
                                                TeraDriver.printValue(printWriter2, n, false, n3, resultSetMetaData.getColumnCount(), string2, resultSet.getString(n3));
                                            }
                                        }
                                    }
                                    finally {
                                        resultSet.close();
                                    }
                                } else {
                                    TeraDriver.printNameValue(printWriter2, n, "getUpdateCount", "" + object.getUpdateCount());
                                }
                                bl = object.getMoreResults();
                            }
                        }
                        finally {
                            object.close();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                if (printWriter2 != printWriter) {
                    printWriter2.close();
                }
            }
            Object var21_22 = null;
            if (bufferedReader2 == null) return;
            if (bufferedReader2 == bufferedReader) return;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (bufferedReader2 == null || bufferedReader2 == bufferedReader) throw throwable;
            bufferedReader2.close();
            throw throwable;
        }
        bufferedReader2.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
    }
}

