/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model.plan;

import com.dbeaver.db.mssql.model.plan.SQLServerPlanNode;
import com.dbeaver.db.mssql.model.plan.schemas.BaseStmtInfoType;
import com.dbeaver.db.mssql.model.plan.schemas.ObjectType;
import com.dbeaver.db.mssql.model.plan.schemas.QueryPlanType;
import com.dbeaver.db.mssql.model.plan.schemas.RelOpBaseType;
import com.dbeaver.db.mssql.model.plan.schemas.RelOpType;
import com.dbeaver.db.mssql.model.plan.schemas.RowsetType;
import com.dbeaver.db.mssql.model.plan.schemas.ShowPlanXML;
import com.dbeaver.db.mssql.model.plan.schemas.StmtBlockType;
import com.dbeaver.db.mssql.model.plan.schemas.StmtSimpleType;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.xml.sax.InputSource;

public class SQLServerPlanParser {
    public static final String rootNodeXPath = "/*[local-name() = 'ShowPlanXML']";
    public static final String VERSION_ATTR = "Version";
    private static final Log log = Log.getLog(SQLServerPlanParser.class);
    private JAXBContext jaxbContext = null;
    private Unmarshaller jaxbUnmarshaller = null;
    public static SQLServerPlanParser instance = new SQLServerPlanParser();

    private SQLServerPlanParser() {
    }

    public static SQLServerPlanParser getInstance() {
        return instance;
    }

    private ShowPlanXML parseXML(String planString) throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ShowPlanXML.class});
        }
        if (this.jaxbUnmarshaller == null) {
            this.jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        }
        return (ShowPlanXML)this.jaxbUnmarshaller.unmarshal(new InputSource(new StringReader(planString)));
    }

    private QueryPlanType findQueryPlan(ShowPlanXML plan, String query) {
        for (ShowPlanXML.BatchSequence.Batch batch : plan.getBatchSequence().getBatch()) {
            for (StmtBlockType stmt : batch.getStatements()) {
                List<BaseStmtInfoType> stmtCursorList = stmt.getStmtSimpleOrStmtCondOrStmtCursor();
                for (BaseStmtInfoType s : stmtCursorList) {
                    if (!(s instanceof StmtSimpleType) || stmtCursorList.size() != 1 && !query.startsWith(((StmtSimpleType)s).getStatementText())) continue;
                    return ((StmtSimpleType)s).getQueryPlan();
                }
            }
        }
        return null;
    }

    public List<Method> getAccessibleMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (clazz != null) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int modifiers = method.getModifiers();
                if (Modifier.isPublic(modifiers) && RelOpBaseType.class.isAssignableFrom(method.getReturnType())) {
                    result.add(method);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private RowsetType findRowset(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                RowsetType res;
                Method method = methodArray[n2];
                int modifiers = method.getModifiers();
                if (Modifier.isPublic(modifiers) && RowsetType.class.isAssignableFrom(method.getReturnType()) && (res = (RowsetType)method.invoke(obj, new Object[0])) != null) {
                    return res;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private List<RelOpType> getRelOpChild(Object object) {
        ArrayList<RelOpType> child = new ArrayList<RelOpType>();
        try {
            Method method = object.getClass().getMethod("getRelOp", new Class[0]);
            if (RelOpType.class.isAssignableFrom(method.getReturnType())) {
                child.add((RelOpType)method.invoke(object, new Object[0]));
            } else if (List.class.isAssignableFrom(method.getReturnType())) {
                child.addAll((List)method.invoke(object, new Object[0]));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug((Object)("Leaf node " + object.getClass()));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            log.debug((Object)("Ignored in getRelOp in " + object.getClass()), (Throwable)e);
        }
        return child;
    }

    private String parseObject(ObjectType o, SQLServerPlanNode planNode) {
        StringBuilder sb = new StringBuilder();
        if (o.getIndex() != null) {
            if (o.getIndex() != null) {
                sb.append(o.getIndex());
            }
            if (o.getIndexKind() != null) {
                sb.append(" [").append((Object)o.getIndexKind()).append("]");
            }
            sb.append(" ");
        } else if (o.getTable() != null) {
            if (o.getDatabase() != null) {
                sb.append(o.getDatabase()).append(".");
            }
            if (o.getSchema() != null) {
                sb.append(o.getSchema()).append(".");
            }
            if (o.getTable() != null) {
                sb.append(o.getTable());
            }
            if (o.getAlias() != null) {
                sb.append(" ").append(o.getAlias());
            }
            sb.append(" ");
        } else {
            return "";
        }
        return sb.toString();
    }

    private void setObjectProperties(RelOpType object, SQLServerPlanNode planNode) {
        this.setObjectName(object, planNode);
        planNode.setEstimatedTotalSubtreeCost(object.getEstimatedTotalSubtreeCost());
        planNode.setEstimateRows(object.getEstimateRows());
        planNode.setEstimatedRowsRead(object.getEstimatedRowsRead());
        planNode.setAvgRowSize(object.getAvgRowSize());
        planNode.setEstimateCPU(object.getEstimateCPU());
        planNode.setEstimateIO(object.getEstimateIO());
        planNode.setEstimateRebinds(object.getEstimateRebinds());
        planNode.setEstimateRewinds(object.getEstimateRewinds());
        planNode.setGroupExecuted(object.getGroupExecuted());
        planNode.setNodeId(object.getNodeId());
        planNode.setParallel(object.isParallel());
        planNode.setRemoteDataAccess(object.getRemoteDataAccess());
        planNode.setPartitioned(object.getPartitioned());
        planNode.setAdaptive(object.getIsAdaptive());
        planNode.setAdaptiveThresholdRows(object.getAdaptiveThresholdRows());
        planNode.setTableCardinality(object.getTableCardinality());
        planNode.setStatsCollectionId(object.getStatsCollectionId());
    }

    private void setObjectName(Object obj, SQLServerPlanNode planNode) {
        StringBuilder sb = new StringBuilder();
        try {
            RowsetType rowset = this.findRowset(obj);
            if (rowset == null) {
                return;
            }
            rowset.getObject().stream().forEach(o -> {
                sb.append(this.parseObject((ObjectType)o, planNode));
                if (sb.length() > 0) {
                    sb.append(" ");
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            log.debug((Object)(String.valueOf(obj.getClass().getName()) + " has no name"));
            return;
        }
        planNode.setName(sb.toString());
    }

    private void addChilds(SQLServerPlanNode nodeParent) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<RelOpType> childs = this.getChilds(nodeParent.getNode());
        for (RelOpType child : childs) {
            if (child == null) continue;
            SQLServerPlanNode node = new SQLServerPlanNode("", child.getLogicalOp().value(), child, nodeParent);
            this.setObjectProperties(child, node);
            nodeParent.addNested(node);
            this.addChilds(node);
        }
    }

    private List<RelOpType> getChilds(RelOpType node) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<RelOpType> childs = new ArrayList<RelOpType>();
        List<Method> allChildMethods = this.getAccessibleMethods(node.getClass());
        for (Method method : allChildMethods) {
            Object result = method.invoke((Object)node, new Object[0]);
            if (result == null) continue;
            childs.addAll(this.getRelOpChild(result));
        }
        return childs;
    }

    public List<DBCPlanNode> parse(String planString, String sqlString) throws DBCException {
        ArrayList<DBCPlanNode> nodes = new ArrayList<DBCPlanNode>();
        try {
            ShowPlanXML plan = this.parseXML(planString);
            QueryPlanType queryPlan = this.findQueryPlan(plan, sqlString);
            if (queryPlan == null) {
                throw new DBCException("Unable to find plan");
            }
            RelOpType relOpRoot = queryPlan.getRelOp();
            SQLServerPlanNode root = new SQLServerPlanNode("", relOpRoot.getLogicalOp().value(), relOpRoot, null);
            this.setObjectProperties(relOpRoot, root);
            this.addChilds(root);
            nodes.add((DBCPlanNode)root);
            return nodes;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JAXBException e) {
            throw new DBCException("Error parsing plan", e);
        }
    }
}

