/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.util.StructuredBytes;
import java.io.PrintStream;
import java.util.StringTokenizer;

class DbPacketLayout
implements PacketLayout {
    private int maxDataLength;
    private int maxSegmentSize;
    private int minReplySize;
    private int packetSize;
    private int portNumber = 0;
    private int replyMessType = 0;
    private boolean supportsChallengeResponse = false;
    public static final int safePacketSizeC = 0;

    DbPacketLayout() {
        this(0, 32768, 0, 0);
    }

    DbPacketLayout(int maxData, int maxSegment, int minReply, int packetS) {
        this.maxDataLength = maxData;
        this.maxSegmentSize = maxSegment;
        this.minReplySize = minReply;
        this.packetSize = packetS;
    }

    DbPacketLayout(StructuredBytes reply, boolean trustReply, boolean parseVarData) {
        this.getPacketLayoutFromReply(reply, trustReply, parseVarData);
    }

    public void dumpOn(PrintStream out, String comment) {
        out.println("DbPacketLayout: " + comment);
        out.println("    packetSize: " + this.packetSize);
        out.println("    maxSegmentSize: " + this.maxSegmentSize);
        out.println("    maxDataLength: " + this.maxDataLength);
        out.println("    minReplySize: " + this.minReplySize);
    }

    public int maxCmdDataLength() {
        return this.maxDataLength() - this.minReplySize();
    }

    public int maxDataLength() {
        return this.maxDataLength;
    }

    public int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int minReplySize() {
        return this.minReplySize;
    }

    public int packetSize() {
        return this.packetSize;
    }

    public boolean isChallengeResponseSupported() {
        return this.supportsChallengeResponse;
    }

    private void getPacketLayoutFromReply(StructuredBytes reply, boolean trustReply, boolean parseVarData) {
        this.replyMessType = reply.getInt1(5);
        this.maxDataLength = reply.getInt4(36);
        this.minReplySize = reply.getInt4(44);
        this.packetSize = reply.getInt4(40);
        this.maxSegmentSize = trustReply ? reply.getInt4(32) : this.packetSize;
        if (parseVarData) {
            this.parseVardataPart(reply);
        }
    }

    private void parseVardataPart(StructuredBytes reply) {
        byte len;
        int vardataOffest = 64;
        int vardataLen = reply.bytes().length - vardataOffest;
        block4: for (int pos = vardataOffest; pos < vardataLen && (len = reply.getInt1(pos)) > 0; pos += len) {
            switch ((char)reply.getInt1(pos + 1)) {
                case 'P': {
                    int lowerByte = reply.getUInt1(pos + 3);
                    this.portNumber = reply.getUInt1(pos + 2) * 256 + lowerByte;
                    continue block4;
                }
                case 'a': {
                    String auth = reply.getString(pos + 2, len - 3);
                    StringTokenizer st = new StringTokenizer(auth, ",");
                    while (st.hasMoreTokens()) {
                        if (!st.nextToken().equals("SCRAMMD5")) continue;
                        this.supportsChallengeResponse = true;
                        continue block4;
                    }
                    continue block4;
                }
            }
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getReplyMessType() {
        return this.replyMessType;
    }
}

