/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.WrapperDummy;
import com.sap.dbtech.jdbcext.translators.RowSetTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class AbstractRowSetSapDB
extends WrapperDummy
implements Serializable,
Cloneable {
    protected String command = null;
    protected String URL = null;
    protected String dataSource = null;
    protected transient String username = null;
    protected transient String password = null;
    protected int rowSetType = 1005;
    protected boolean showDeleted = false;
    protected int queryTimeout = 0;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int concurrency = 1007;
    protected boolean readOnly = true;
    protected boolean escapeProcessing = true;
    protected int isolation = 2;
    protected int fetchDir = 1000;
    protected int fetchSize = 30000;
    protected Map map = null;
    protected ArrayList listeners = new ArrayList();
    protected Vector params = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowSetListener(RowSetListener rlistener) {
        if (rlistener == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int list_sz = this.listeners.size();
            for (int i = 0; i < list_sz; ++i) {
                if (this.listeners.get(i) != rlistener) continue;
                return;
            }
            this.listeners.add(rlistener);
        }
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public Map getTypeMap() {
        return this.map;
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public String getUsername() {
        return this.username;
    }

    protected void initParams() {
        this.params = new Vector();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int list_sz = this.listeners.size();
                for (int i = 0; i < list_sz; ++i) {
                    RowSetListener rl = (RowSetListener)this.listeners.get(i);
                    rl.cursorMoved(rowsetevent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int list_sz = this.listeners.size();
                for (int i = 0; i < list_sz; ++i) {
                    RowSetListener rl = (RowSetListener)this.listeners.get(i);
                    rl.rowChanged(rowsetevent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowSetChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int list_sz = this.listeners.size();
                for (int i = 0; i < list_sz; ++i) {
                    RowSetListener rl = (RowSetListener)this.listeners.get(i);
                    rl.rowSetChanged(rowsetevent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowSetListener(RowSetListener rowsetlistener) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int list_sz = this.listeners.size();
            for (int i = 0; i < list_sz; ++i) {
                if (this.listeners.get(i) != rowsetlistener) continue;
                this.listeners.remove(i);
                return;
            }
        }
    }

    public void setArray(int i, Array array) throws SQLException {
        this.params.add(new RowSetTranslator(0, i, (Object)array));
    }

    public void setAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        this.params.add(new RowSetTranslator(1, i, (Object)inputstream, (Object)new Integer(j)));
    }

    public void setBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        this.params.add(new RowSetTranslator(2, i, (Object)bigdecimal));
    }

    public void setBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        this.params.add(new RowSetTranslator(3, i, (Object)inputstream, (Object)new Integer(j)));
    }

    public void setBlob(int i, Blob blob) throws SQLException {
        this.params.add(new RowSetTranslator(4, i, (Object)blob));
    }

    public void setBoolean(int i, boolean flag) throws SQLException {
        this.params.add(new RowSetTranslator(5, i, (Object)new Boolean(flag)));
    }

    public void setByte(int i, byte byte0) throws SQLException {
        this.params.add(new RowSetTranslator(7, i, (Object)new Byte(byte0)));
    }

    public void setBytes(int i, byte[] abyte0) throws SQLException {
        this.params.add(new RowSetTranslator(6, i, (Object)abyte0));
    }

    public void setCharacterStream(int i, Reader reader, int j) throws SQLException {
        this.params.add(new RowSetTranslator(8, i, (Object)reader, (Object)new Integer(j)));
    }

    public void setClob(int i, Clob clob) throws SQLException {
        this.params.add(new RowSetTranslator(9, i, (Object)clob));
    }

    public void setCommand(String s) throws SQLException {
        this.command = s;
        this.params.clear();
    }

    public void setConcurrency(int i) {
        this.concurrency = i;
    }

    public void setDataSourceName(String s) {
        this.dataSource = s == null ? null : new String(s);
        this.URL = null;
    }

    public void setDate(int i, Date date) throws SQLException {
        this.params.add(new RowSetTranslator(10, i, (Object)date));
    }

    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        this.params.add(new RowSetTranslator(10, i, (Object)date, (Object)calendar));
    }

    public void setDouble(int i, double d) throws SQLException {
        this.params.add(new RowSetTranslator(11, i, (Object)new Double(d)));
    }

    public void setEscapeProcessing(boolean flag) throws SQLException {
        this.escapeProcessing = flag;
    }

    public void setFetchDirection(int i) throws SQLException {
        this.fetchDir = i;
    }

    public void setFetchSize(int i) throws SQLException {
        this.fetchSize = i;
    }

    public void setFloat(int i, float f) throws SQLException {
        this.params.add(new RowSetTranslator(12, i, (Object)new Float(f)));
    }

    public void setInt(int i, int j) throws SQLException {
        this.params.add(new RowSetTranslator(13, i, (Object)new Integer(j)));
    }

    public void setLong(int i, long l) throws SQLException {
        this.params.add(new RowSetTranslator(14, i, (Object)new Long(l)));
    }

    public void setMaxFieldSize(int i) throws SQLException {
        this.maxFieldSize = i;
    }

    public void setMaxRows(int i) throws SQLException {
        this.maxRows = i;
    }

    public void setNull(int i, int j) throws SQLException {
        this.params.add(new RowSetTranslator(15, i, (Object)new Integer(j)));
    }

    public void setNull(int i, int j, String s) throws SQLException {
        this.params.add(new RowSetTranslator(15, i, (Object)new Integer(j)));
    }

    public void setObject(int i, Object obj) throws SQLException {
        this.params.add(new RowSetTranslator(16, i, obj));
    }

    public void setObject(int i, Object obj, int j) throws SQLException {
        this.params.add(new RowSetTranslator(16, i, obj, (Object)new Integer(j)));
    }

    public void setObject(int i, Object obj, int j, int k) throws SQLException {
        this.params.add(new RowSetTranslator(16, i, obj, (Object)new Integer(j), (Object)new Integer(k)));
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setQueryTimeout(int i) throws SQLException {
        this.queryTimeout = i;
    }

    public void setReadOnly(boolean flag) {
        this.readOnly = flag;
    }

    public void setRef(int i, Ref ref) throws SQLException {
        this.params.add(new RowSetTranslator(17, i, (Object)ref));
    }

    public void setShort(int i, short word0) throws SQLException {
        this.params.add(new RowSetTranslator(18, i, (Object)new Short(word0)));
    }

    public void setString(int i, String s) throws SQLException {
        this.params.add(new RowSetTranslator(19, i, (Object)s));
    }

    public void setTime(int i, Time time) throws SQLException {
        this.params.add(new RowSetTranslator(21, i, (Object)time));
    }

    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        this.params.add(new RowSetTranslator(21, i, (Object)time, (Object)calendar));
    }

    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.params.add(new RowSetTranslator(20, i, (Object)timestamp));
    }

    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.params.add(new RowSetTranslator(20, i, (Object)timestamp, (Object)calendar));
    }

    public void setTransactionIsolation(int i) {
        this.isolation = i;
    }

    public void setType(int i) {
        this.rowSetType = i;
    }

    public void setTypeMap(Map map1) {
        this.map = map1;
    }

    public void setUnicodeStream(int i, InputStream inputstream, int j) throws SQLException {
        this.params.add(new RowSetTranslator(22, i, (Object)inputstream, (Object)new Integer(j)));
    }

    public void setUrl(String s) throws SQLException {
        this.URL = s == null ? null : s;
        this.dataSource = null;
    }

    public void setUsername(String s) {
        this.username = new String(s);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.params.add(new RowSetTranslator(1, parameterIndex, (Object)x));
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.params.add(new RowSetTranslator(1, parameterName, (Object)x));
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.params.add(new RowSetTranslator(1, parameterName, (Object)x, (Object)new Integer(length)));
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.params.add(new RowSetTranslator(2, parameterName, (Object)x));
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.params.add(new RowSetTranslator(3, parameterIndex, (Object)x));
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.params.add(new RowSetTranslator(3, parameterName, (Object)x));
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.params.add(new RowSetTranslator(3, parameterName, (Object)x));
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.params.add(new RowSetTranslator(4, parameterIndex, (Object)inputStream));
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.params.add(new RowSetTranslator(4, parameterName, (Object)x));
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.params.add(new RowSetTranslator(4, parameterName, (Object)inputStream));
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.params.add(new RowSetTranslator(27, parameterIndex, (Object)inputStream, (Object)new Long(length)));
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.params.add(new RowSetTranslator(27, parameterName, (Object)inputStream, (Object)new Long(length)));
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.params.add(new RowSetTranslator(5, parameterName, (Object)new Boolean(x)));
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.params.add(new RowSetTranslator(7, parameterName, (Object)new Byte(x)));
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.params.add(new RowSetTranslator(6, parameterName, (Object)x));
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(8, parameterIndex, (Object)reader));
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(8, parameterName, (Object)reader));
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.params.add(new RowSetTranslator(8, parameterName, (Object)reader, (Object)new Integer(length)));
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(9, parameterIndex, (Object)reader));
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.params.add(new RowSetTranslator(9, parameterName, (Object)x));
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(9, parameterName, (Object)reader));
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.params.add(new RowSetTranslator(28, parameterIndex, (Object)reader, (Object)new Long(length)));
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.params.add(new RowSetTranslator(28, parameterName, (Object)reader, (Object)new Long(length)));
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.params.add(new RowSetTranslator(10, parameterName, (Object)x));
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.params.add(new RowSetTranslator(10, parameterName, (Object)x, (Object)cal));
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.params.add(new RowSetTranslator(11, parameterName, (Object)new Double(x)));
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.params.add(new RowSetTranslator(12, parameterName, (Object)new Float(x)));
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.params.add(new RowSetTranslator(13, parameterName, (Object)new Integer(x)));
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.params.add(new RowSetTranslator(14, parameterName, (Object)new Long(x)));
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.params.add(new RowSetTranslator(30, parameterIndex, (Object)value));
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.params.add(new RowSetTranslator(30, parameterName, (Object)value));
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.params.add(new RowSetTranslator(30, parameterIndex, (Object)value, (Object)new Long(length)));
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.params.add(new RowSetTranslator(30, parameterName, (Object)value, (Object)new Long(length)));
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.params.add(new RowSetTranslator(35, parameterName, (Object)value));
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(31, parameterName, (Object)reader));
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.params.add(new RowSetTranslator(31, parameterIndex, (Object)value));
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.params.add(new RowSetTranslator(31, parameterIndex, (Object)reader));
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.params.add(new RowSetTranslator(31, parameterName, (Object)reader, (Object)new Long(length)));
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.params.add(new RowSetTranslator(31, parameterIndex, (Object)reader, (Object)new Long(length)));
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.params.add(new RowSetTranslator(32, parameterIndex, (Object)value));
    }

    public void setNString(String parameterName, String value) throws SQLException {
        this.params.add(new RowSetTranslator(32, parameterName, (Object)value));
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.params.add(new RowSetTranslator(15, parameterName, (Object)new Integer(sqlType)));
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.params.add(new RowSetTranslator(15, parameterName, (Object)new Integer(sqlType)));
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.params.add(new RowSetTranslator(16, parameterName, x));
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.params.add(new RowSetTranslator(16, parameterName, x, (Object)new Integer(targetSqlType)));
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.params.add(new RowSetTranslator(30, parameterName, x, (Object)new Integer(targetSqlType), (Object)new Integer(scale)));
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.params.add(new RowSetTranslator(33, parameterIndex, (Object)x));
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.params.add(new RowSetTranslator(33, parameterName, (Object)x));
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.params.add(new RowSetTranslator(34, parameterIndex, (Object)xmlObject));
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.params.add(new RowSetTranslator(34, parameterName, (Object)xmlObject));
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.params.add(new RowSetTranslator(18, parameterName, (Object)new Short(x)));
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.params.add(new RowSetTranslator(19, parameterName, (Object)x));
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.params.add(new RowSetTranslator(21, parameterName, (Object)x));
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.params.add(new RowSetTranslator(21, parameterName, (Object)x, (Object)cal));
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.params.add(new RowSetTranslator(20, parameterName, (Object)x));
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.params.add(new RowSetTranslator(20, parameterName, (Object)x, (Object)cal));
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.params.add(new RowSetTranslator(23, parameterIndex, (Object)x));
    }
}

