/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.exceptions.jdbc40.SQLClientInfoException;
import java.sql.ClientInfoStatus;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class ClientInfo {
    private final Properties m_properties = new Properties();
    boolean m_propertiesAreSet = false;

    public static ClientInfo setClientInfo(Object ci, Properties props) throws java.sql.SQLClientInfoException {
        ClientInfo erg = ci == null ? new ClientInfo() : (ClientInfo)ci;
        erg.parseProperties(props);
        return erg;
    }

    public static Properties getClientInfo(Object ci) {
        if (ci == null) {
            return new Properties();
        }
        return ((ClientInfo)ci).getProperties();
    }

    public static String getClientInfo(Object ci, String name) {
        if (ci == null) {
            return null;
        }
        return ((ClientInfo)ci).getProperties().getProperty(name, null);
    }

    public static ClientInfo setClientInfo(Object ci, String name, String value) throws java.sql.SQLClientInfoException {
        ClientInfo erg = ci == null ? new ClientInfo() : (ClientInfo)ci;
        if (!erg.setProperty(name, value)) {
            HashMap<String, ClientInfoStatus> failureProps = new HashMap<String, ClientInfoStatus>();
            failureProps.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw SQLClientInfoException.createException(failureProps);
        }
        return erg;
    }

    public void parseProperties(Properties props) throws java.sql.SQLClientInfoException {
        if (props == null || props.isEmpty()) {
            this.m_properties.clear();
            this.m_propertiesAreSet = false;
            return;
        }
        Enumeration<Object> e = props.keys();
        HashMap<String, ClientInfoStatus> failureProps = null;
        while (e.hasMoreElements()) {
            String val;
            String key = (String)e.nextElement();
            if (this.setProperty(key, val = props.getProperty(key))) continue;
            if (failureProps == null) {
                failureProps = new HashMap<String, ClientInfoStatus>();
            }
            failureProps.put(key, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        if (failureProps != null) {
            throw SQLClientInfoException.createException(failureProps);
        }
    }

    private boolean setProperty(String key, String value) {
        if (this.m_properties.containsKey(key)) {
            this.m_properties.put(key, value);
            this.m_propertiesAreSet = true;
            return true;
        }
        return false;
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

