/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.jalapeno.annotations.AccessLevel;
import com.jalapeno.annotations.AccessType;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.JPAAnnotationProcessor;
import com.jalapeno.tools.objects.JalapenoAnnotationProcessor;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.NamedQuery;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.ProviderTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationProvider
implements Java2DBMapping {
    private HashMap<Class, ClassMetadata> classMetadata = new HashMap();
    private Java2DBMapping nameHelper;

    @Override
    public String cacheClassNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassName();
    }

    @Override
    public String sqlSchemaNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getSQLSchemaName();
    }

    @Override
    public String packageNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPackageName();
    }

    @Override
    public String sqlTableNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getSQLTableName();
    }

    @Override
    public String primaryKeyNameFor(Class clazz) {
        return null;
    }

    @Override
    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getIndices();
    }

    @Override
    public int getAccessLevel(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessLevel();
    }

    @Override
    public int getAccessType(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessType();
    }

    @Override
    public String getJavaProjectionPackage(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionPackageName();
    }

    @Override
    public String getJavaProjectionClassName(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionClassName();
    }

    @Override
    public String cacheFieldNameFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getName();
    }

    @Override
    public String cacheFieldTypeFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getType();
    }

    @Override
    public int getPropertyKind(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return -1;
        }
        return propertyMetadata.getKind();
    }

    @Override
    public boolean isFetchTypeEager(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isFetchTypeEager();
    }

    @Override
    public CacheRelationshipInfo relationshipFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getRelationshipMetadata();
    }

    @Override
    public boolean isSerial(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.getIsSerial();
    }

    @Override
    public String getVersionID(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getVersionID();
    }

    @Override
    public boolean isClassTransient(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isTransient();
    }

    @Override
    public boolean isPropertyRequired(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isRequired();
    }

    @Override
    public String sqlColumnNameFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getSQLColumnName();
    }

    @Override
    public boolean isMemberTransient(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isTransient();
    }

    @Override
    public Map getPropertyParameters(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getPropertyParameters();
    }

    @Override
    public String getDatabaseID(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getDatabaseID();
    }

    @Override
    public int getDatabaseIDType(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getDatabaseIDType();
    }

    @Override
    public boolean isPopulatable(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isPopulatable();
    }

    @Override
    public boolean isXMLSerializable(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isXMLSerializable();
    }

    @Override
    public Map getClassParameters(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassParameters();
    }

    @Override
    public String getExtendedClass(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getExtendedClass();
    }

    @Override
    public String[] getImplementedClasses(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getImplementedClasses();
    }

    @Override
    public void close() {
        this.classMetadata.clear();
    }

    @Override
    public void setHelperMapping(Java2DBMapping java2DBMapping) {
        this.nameHelper = java2DBMapping;
    }

    private ClassMetadata getAnnotationInfo(Class clazz) {
        String string;
        ClassMetadata classMetadata = this.classMetadata.get(clazz);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = new ClassMetadata();
        this.classMetadata.put(clazz, classMetadata);
        boolean bl = AnnotationProvider.checkIfJPAAnnotationsPresent(clazz);
        AnnotationProvider.processClassAnnotations(clazz, classMetadata, bl);
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = this.processPropertyAnnotations(fieldArray[i], classMetadata, bl);
            if (string2 == null) continue;
            if (this.nameHelper != null) {
                string2 = this.nameHelper.cacheFieldNameFor(fieldArray[i]);
            }
            arrayList.add(string2);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!AnnotationProvider.isAccessor(methodArray[i])) continue;
            try {
                clazz.getField(methodArray[i].getName().substring(3));
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                string = this.processPropertyAnnotations(methodArray[i], classMetadata, bl);
                if (string == null) continue;
                if (this.nameHelper != null) {
                    string = this.nameHelper.cacheFieldNameFor(methodArray[i]);
                }
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = string = (String)arrayList.get(i);
            }
            String string3 = "CompositeIndex";
            if (arrayList.size() == 1) {
                string3 = (String)arrayList.get(0);
            }
            classMetadata.setIndex(null, "", false, string3, true, stringArray, null, null, true, null);
        }
        if (bl) {
            int n = classMetadata.getNAnnotatedFields();
            int n2 = classMetadata.getNAnnotatedMethods();
            if (n > 0 && n2 == 0) {
                classMetadata.setAccessType(AccessType.FIELD);
            }
        }
        return classMetadata;
    }

    private static void processClassAnnotations(Class clazz, ClassMetadata classMetadata, boolean bl) {
        if (bl) {
            JPAAnnotationProcessor.processEntityAndTableAnnotations(clazz, classMetadata);
            JPAAnnotationProcessor.processEmbeddableAnnotation(clazz, classMetadata);
            JPAAnnotationProcessor.processTransientAnnotation(clazz, classMetadata);
            JPAAnnotationProcessor.processIdClassAnnotation(clazz, classMetadata);
            JPAAnnotationProcessor.processNamedNativeQueriesAnnotation(clazz, classMetadata);
            JPAAnnotationProcessor.processNamedNativeQueryAnnotation(clazz, classMetadata);
        }
        JalapenoAnnotationProcessor.processCacheClassAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processIndexAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processIndicesAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processEmbeddableAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processAccessAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processTransientAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processExtendsAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processImplementsAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processClassParametersAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processClassParameterAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processQueriesAnnotation(clazz, classMetadata);
        JalapenoAnnotationProcessor.processQueryAnnotation(clazz, classMetadata);
    }

    private String processPropertyAnnotations(Member member, ClassMetadata classMetadata, boolean bl) {
        boolean bl2;
        PropertyMetadata propertyMetadata = new PropertyMetadata();
        String string = null;
        boolean bl3 = false;
        if (bl) {
            JPAAnnotationProcessor.processVersionAnnotation(member, classMetadata);
            string = JPAAnnotationProcessor.processIdAnnotation(member, classMetadata);
            if (string == null) {
                string = JPAAnnotationProcessor.processEmbeddedIdAnnotation(member, classMetadata);
            }
            bl3 = JPAAnnotationProcessor.processGeneratedValueAnnotation(member, classMetadata);
            bl3 |= string != null;
            bl2 = JPAAnnotationProcessor.processColumnAnnotation(member, classMetadata, propertyMetadata);
            bl2 |= JPAAnnotationProcessor.processTransientAnnotation(member, propertyMetadata);
            bl2 |= JPAAnnotationProcessor.processOneToManyAnnotation(member, propertyMetadata, this.nameHelper);
            bl2 |= JPAAnnotationProcessor.processManyToOneAnnotation(member, propertyMetadata);
            bl2 |= JPAAnnotationProcessor.processLobAnnotation(member, propertyMetadata);
            bl2 |= JPAAnnotationProcessor.processBasicAnnotation(member, propertyMetadata);
            bl2 |= JPAAnnotationProcessor.processTemporalAnnotation(member, propertyMetadata);
        } else {
            bl2 = false;
        }
        JalapenoAnnotationProcessor.processVersionAnnotation(member, classMetadata);
        JalapenoAnnotationProcessor.processDatabaseIDAnnotation(member, classMetadata);
        bl2 |= JalapenoAnnotationProcessor.processPropertyAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processTransientAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processPropertyParameterAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processPropertyParametersAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processOneToManyAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processManyToOneAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processRelationshipAnnotation(member, propertyMetadata);
        bl2 |= JalapenoAnnotationProcessor.processCollectionAnnotation(member, propertyMetadata);
        if (bl2 |= JalapenoAnnotationProcessor.processLobAnnotation(member, propertyMetadata)) {
            classMetadata.addPropertyMetadata(member, propertyMetadata);
        }
        if (bl && (bl2 || bl3)) {
            if (member instanceof Field) {
                classMetadata.incAnnotatedFields();
            } else {
                classMetadata.incAnnotatedMethods();
            }
        }
        if (bl && bl2 && member instanceof Field) {
            if (Modifier.isPrivate(member.getModifiers())) {
                classMetadata.setAccessLevel(AccessLevel.PRIVATE);
            } else if (classMetadata.getAccessLevel() != 2 && Modifier.isProtected(member.getModifiers())) {
                classMetadata.setAccessLevel(AccessLevel.PROTECTED);
            }
        }
        return string;
    }

    private static boolean isAccessor(Method method) {
        String string = method.getName();
        if (!(string.startsWith("set") || string.startsWith("get") || string.startsWith("is"))) {
            return false;
        }
        if (string.length() < 3) {
            return false;
        }
        return !(string.startsWith("get") ? method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE : (string.startsWith("set") ? method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE : method.getParameterTypes().length != 0 || method.getReturnType() != Boolean.TYPE));
    }

    private PropertyMetadata getPropertyMetadata(Object object) {
        Member member = (Member)object;
        ((AccessibleObject)((Object)member)).setAccessible(true);
        ClassMetadata classMetadata = this.getAnnotationInfo(member.getDeclaringClass());
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPropertyMetadata(member);
    }

    public boolean isPropertyAnnotated(Member member) {
        return this.getPropertyMetadata(member) != null;
    }

    public static void main(String[] stringArray) throws Throwable {
        ProviderTest.test(new AnnotationProvider(), Class.forName(stringArray[0]));
    }

    private static boolean checkIfJPAAnnotationsPresent(Class clazz) {
        Annotation[] annotationArray = clazz.getAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Class<? extends Annotation> clazz2 = annotationArray[i].annotationType();
            if (!clazz2.getName().startsWith("javax.persistence")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<NamedQuery> getNamedQueries(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getNamedQueries();
    }

    public List<String[]> getUniqueConstraints(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getUniqueConstraints();
    }
}

