/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.ObjectManager;
import com.jalapeno.runtime.CacheObjectManager;
import com.jalapeno.runtime.Dependency;
import com.jalapeno.runtime.JalapenoHelperInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class JalapenoBasicHelper
implements JalapenoHelperInterface {
    private CacheField[] mFieldsToCheckForDeps;
    private int[] mFieldsToCheckForDepsFlag;
    private int mDependencyCheck = -1;
    private boolean mBackRefs = false;
    private static boolean NULLIFY_RELATIONSHIPS = true;
    protected CacheClass mCacheClass;

    public JalapenoBasicHelper(CacheClass cacheClass) {
        this.mCacheClass = cacheClass;
    }

    @Override
    public abstract Object get(Object var1, int var2) throws Exception;

    @Override
    public abstract void set(Object var1, int var2, Object var3) throws Exception;

    @Override
    public abstract Serializable getPojoId(Object var1) throws Exception;

    @Override
    public abstract boolean setPojoId(Object var1, Serializable var2) throws Exception;

    @Override
    public abstract Object getVersionProperty(Object var1) throws Exception;

    @Override
    public abstract void setVersionProperty(Object var1, Object var2) throws Exception;

    @Override
    public abstract boolean hasIdPlaceholder() throws CacheException;

    private static Collection toCollection(Object object) {
        if (object.getClass().isArray()) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Map) {
            return ((Map)object).values();
        }
        throw new IllegalArgumentException("Not a collection: " + object.getClass().getName());
    }

    private void setBackReferences(Object object, CacheObjectManager cacheObjectManager, CacheField cacheField, Collection collection, Dependency dependency) throws Exception {
        if (!this.mBackRefs) {
            return;
        }
        HashMap<Object, Integer> hashMap = null;
        if (collection.size() > 1) {
            hashMap = new HashMap<Object, Integer>();
        }
        for (Object e : collection) {
            int n;
            Class<?> clazz;
            if (hashMap != null) {
                clazz = e.getClass();
                Integer n2 = (Integer)hashMap.get(clazz);
                if (n2 == null) {
                    CacheField cacheField2 = cacheObjectManager.getInverseField(cacheField, clazz);
                    n = cacheField2.getII();
                    hashMap.put(clazz, new Integer(n));
                } else {
                    n = n2;
                }
            } else {
                clazz = cacheObjectManager.getInverseField(cacheField, e.getClass());
                n = clazz.getII();
            }
            clazz = cacheObjectManager.getHelper(e);
            if (clazz.get(e, n) == null) {
                clazz.set(e, n, object);
            }
            dependency.addReference(e);
        }
    }

    private boolean clearRelationships(Object object) throws Exception {
        boolean bl = false;
        if (!this.mBackRefs) {
            return bl;
        }
        for (int i = 0; i < this.mFieldsToCheckForDeps.length; ++i) {
            CacheField cacheField = this.mFieldsToCheckForDeps[i];
            if (!cacheField.isCollection() || !cacheField.isRelationship()) continue;
            if (NULLIFY_RELATIONSHIPS) {
                this.set(object, cacheField.getII(), null);
            } else {
                Object object2 = this.get(object, cacheField.getII());
                if (object2 == null) continue;
                if (object2 instanceof Collection) {
                    ((Collection)object2).clear();
                } else if (object2 instanceof Map) {
                    ((Map)object2).clear();
                }
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized Dependency prepareDependency(Object object, ObjectManager objectManager, boolean bl) throws Exception {
        int n;
        this.setUpDependencyCheck();
        if (this.mDependencyCheck == 0) {
            return Dependency.LITERAL_OBJECT;
        }
        Dependency dependency = new Dependency();
        for (n = 0; n < this.mFieldsToCheckForDeps.length; ++n) {
            CacheField cacheField = this.mFieldsToCheckForDeps[n];
            Object object2 = this.get(object, cacheField.getII());
            if (object2 == null) continue;
            if (cacheField.isCollection() && cacheField.isElementSerial()) {
                JalapenoBasicHelper.calculateRefsForCollectionOfSerial(object2, objectManager, dependency);
                continue;
            }
            if (cacheField.isSerial()) {
                JalapenoBasicHelper.calculateRefsForSerial(object2, objectManager, dependency);
                continue;
            }
            if (cacheField.isCollection()) {
                Collection collection = null;
                collection = JalapenoBasicHelper.toCollection(object2);
                if (bl && cacheField.isRelationship()) {
                    this.setBackReferences(object, (CacheObjectManager)objectManager, cacheField, collection, dependency);
                    continue;
                }
                dependency.addReferences(collection);
                continue;
            }
            dependency.addReference(object2);
        }
        if (bl && (n = (int)(this.clearRelationships(object) ? 1 : 0)) != 0) {
            dependency.setDirty(n != 0);
        }
        return dependency;
    }

    @Override
    public synchronized void calculateDependency(Object object, Dependency dependency, ObjectManager objectManager) throws Exception {
        this.setUpDependencyCheck();
        if (this.mDependencyCheck == 0) {
            return;
        }
        for (int i = 0; i < this.mFieldsToCheckForDeps.length; ++i) {
            CacheField cacheField = this.mFieldsToCheckForDeps[i];
            Object object2 = this.get(object, cacheField.getII());
            if (object2 == null) continue;
            if (cacheField.isCollection() && cacheField.isElementSerial()) {
                JalapenoBasicHelper.calculateRefsForCollectionOfSerial(object2, objectManager, dependency);
                continue;
            }
            if (cacheField.isSerial()) {
                JalapenoBasicHelper.calculateDepsForSerial(object2, objectManager, dependency);
                continue;
            }
            Collection collection = null;
            if (cacheField.isCollection()) {
                collection = JalapenoBasicHelper.toCollection(object2);
            }
            if (this.mFieldsToCheckForDepsFlag[i] < 2) continue;
            boolean bl = false;
            if (cacheField.isCollection()) {
                for (Object e : collection) {
                    Serializable serializable = objectManager.getId(e);
                    if (serializable != null) continue;
                    dependency.addDependency(e);
                    bl = true;
                }
            } else {
                Serializable serializable = objectManager.getId(object2);
                if (serializable == null) {
                    dependency.addDependency(object2);
                    bl = true;
                }
            }
            if (!bl || this.mFieldsToCheckForDepsFlag[i] < 3) continue;
            dependency.addRequiredDependency(object2);
        }
    }

    private static void calculateDepsForSerial(Object object, ObjectManager objectManager, Dependency dependency) throws Exception {
        if (object == null) {
            return;
        }
        CacheObjectManager cacheObjectManager = (CacheObjectManager)objectManager;
        CacheClass cacheClass = cacheObjectManager.findImplementation(object.getClass());
        JalapenoHelperInterface jalapenoHelperInterface = cacheObjectManager.getHelper(object);
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            Object object2;
            Object object3;
            CacheField cacheField = cacheFieldArray[i];
            if (cacheField.isLiteral() || (object3 = jalapenoHelperInterface.get(object, cacheField.getII())) == null) continue;
            if (cacheField.isCollection()) {
                object2 = JalapenoBasicHelper.toCollection(object3);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Serializable serializable = objectManager.getId(e);
                    if (serializable != null) continue;
                    dependency.addDependency(e);
                }
                continue;
            }
            if (cacheField.isPersistent()) {
                object2 = objectManager.getId(object3);
                if (object2 != null) continue;
                dependency.addDependency(object3);
                if (!cacheField.isRequired()) continue;
                dependency.addRequiredDependency(object3);
                continue;
            }
            if (!cacheField.isSerial()) continue;
            JalapenoBasicHelper.calculateDepsForSerial(object3, objectManager, dependency);
        }
    }

    private static void calculateRefsForCollectionOfSerial(Object object, ObjectManager objectManager, Dependency dependency) throws Exception {
        Collection collection = object instanceof Map ? ((Map)object).values() : (Collection)object;
        for (Object v : collection) {
            JalapenoBasicHelper.calculateRefsForSerial(v, objectManager, dependency);
        }
    }

    private static void calculateRefsForSerial(Object object, ObjectManager objectManager, Dependency dependency) throws Exception {
        if (object == null) {
            return;
        }
        CacheObjectManager cacheObjectManager = (CacheObjectManager)objectManager;
        CacheClass cacheClass = cacheObjectManager.findImplementation(object.getClass());
        JalapenoHelperInterface jalapenoHelperInterface = cacheObjectManager.getHelper(object);
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            Object object2;
            CacheField cacheField = cacheFieldArray[i];
            if (cacheField.isLiteral() || (object2 = jalapenoHelperInterface.get(object, cacheField.getII())) == null) continue;
            if (cacheField.isCollection()) {
                Collection collection = JalapenoBasicHelper.toCollection(object2);
                dependency.addReferences(collection);
                continue;
            }
            if (cacheField.isPersistent()) {
                dependency.addReference(object2);
                continue;
            }
            if (!cacheField.isSerial()) continue;
            JalapenoBasicHelper.calculateRefsForSerial(object2, objectManager, dependency);
        }
    }

    private void setUpDependencyCheck() throws CacheException {
        int n;
        Object object;
        int n2;
        if (this.mDependencyCheck >= 0) {
            return;
        }
        ArrayList<CacheField> arrayList = new ArrayList<CacheField>();
        CacheField[] cacheFieldArray = this.mCacheClass.getFields();
        for (n2 = 0; n2 < cacheFieldArray.length; ++n2) {
            CacheField cacheField = cacheFieldArray[n2];
            if (cacheField.isLiteral() || cacheField.isCollection() && cacheField.isElementDatatype()) continue;
            if (cacheField.isCollection()) {
                arrayList.add(cacheField);
                continue;
            }
            if (cacheField.isPersistent()) {
                arrayList.add(cacheField);
                continue;
            }
            if (!cacheField.isSerial() || JalapenoBasicHelper.checkIfSerialObjectLiteral((CacheClass)(object = cacheField.getType()))) continue;
            arrayList.add(cacheField);
        }
        if (arrayList.isEmpty()) {
            this.mDependencyCheck = 0;
            return;
        }
        n2 = arrayList.size();
        this.mFieldsToCheckForDeps = new CacheField[n2];
        this.mFieldsToCheckForDeps = arrayList.toArray(this.mFieldsToCheckForDeps);
        this.mFieldsToCheckForDepsFlag = new int[n2];
        for (n = 0; n < n2; ++n) {
            object = this.mFieldsToCheckForDeps[n];
            if (object.isCollection()) {
                if (object.isRelationship()) {
                    this.mFieldsToCheckForDepsFlag[n] = 1;
                    this.mBackRefs = true;
                    continue;
                }
                this.mFieldsToCheckForDepsFlag[n] = 2;
                continue;
            }
            if (object.isPersistent()) {
                if (object.isRequired()) {
                    this.mFieldsToCheckForDepsFlag[n] = 3;
                    continue;
                }
                this.mFieldsToCheckForDepsFlag[n] = 2;
                continue;
            }
            if (!object.isSerial()) continue;
            this.mFieldsToCheckForDepsFlag[n] = 3;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.mFieldsToCheckForDepsFlag[n];
            if (n3 <= this.mDependencyCheck) continue;
            this.mDependencyCheck = n3;
            if (n3 == 3) break;
        }
    }

    public static boolean checkIfSerialObjectLiteral(CacheClass cacheClass) throws CacheException {
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            if (cacheField.isLiteral()) continue;
            if (cacheField.isSerial()) {
                CacheClass cacheClass2 = cacheField.getType();
                if (JalapenoBasicHelper.checkIfSerialObjectLiteral(cacheClass2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

