/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep.test;

import com.intersys.xep.Event;
import com.intersys.xep.EventQuery;
import com.intersys.xep.EventQueryIterator;
import com.intersys.xep.samples.DaysEnum;
import com.intersys.xep.samples.InterfaceTestImpl;
import com.intersys.xep.samples.NestedOne;
import com.intersys.xep.samples.NestedThree;
import com.intersys.xep.samples.NestedTwo;
import com.intersys.xep.samples.Sample;
import com.intersys.xep.samples.SampleCore;
import com.intersys.xep.samples.SamplesInterfaceResolver;
import com.intersys.xep.samples.Serialized;
import com.intersys.xep.samples.SingleString;
import com.intersys.xep.samples._Inner_Class_Sample;
import com.intersys.xep.test.Core;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class Basic
extends Core {
    private static Sample[] data;

    Basic(String string, int n) throws Exception {
        super(string);
        objectCount = n;
        Basic.generateSampleData(objectCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Basic.checkParameters(stringArray, "(2) total number of objects [optional, defaulfs to 10,000 objects]\r\n");
        int n = 10000;
        if (stringArray.length == 2) {
            n = Integer.parseInt(stringArray[1]);
        }
        Basic basic = new Basic(stringArray[0], n);
        try {
            basic.importSchema(new SamplesInterfaceResolver());
            basic.deleteExtent();
            basic.store();
            basic.loadCheckUpdate();
        }
        finally {
            basic.close();
        }
    }

    void store() throws Exception {
        Event event = this.persister.getEvent(className);
        System.out.println("\nStoring XEP sample data...");
        long l = Basic.getTime();
        for (int i = 0; i < objectCount; ++i) {
            event.store(data[i]);
            if (i == 0 || i % 1000 != 0) continue;
            System.out.println("Stored " + i + " objects");
        }
        Basic.report(false, objectCount, l);
        event.close();
    }

    void loadCheckUpdate() throws Exception {
        System.out.println("\nLoading XEP sample...");
        Event event = this.persister.getEvent(className);
        int n = 0;
        Sample sample = new Sample();
        long l = Core.getTime();
        EventQuery<Sample> eventQuery = event.createQuery(sqlquery);
        eventQuery.setParameter(1, 0);
        eventQuery.execute();
        while ((sample = eventQuery.getNext(sample)) != null) {
            if (n % 100 == 0) {
                if (Basic.data[n].typeInt != sample.typeInt) {
                    throw new Exception("XEP data does not match: typeInt");
                }
                if (!Basic.data[n].nestedField.nestedTwo.nestedThree.fieldOne.equals(sample.nestedField.nestedTwo.nestedThree.fieldOne)) {
                    throw new Exception("XEP data does not match: nested");
                }
                if (!Basic.data[n]._field_with_underscores.equals("underscore")) {
                    throw new Exception("XEP data does not match: underscore");
                }
                if (!Basic.data[n].innerClass.innerField.equals("innerField")) {
                    throw new Exception("XEP data does not match: inner field");
                }
                if (!Basic.data[n].serialized.name.equals("serialized field " + sample.typeInt) || Basic.data[n].serialized.value != sample.typeInt) {
                    throw new Exception("XEP data does not match: serialized");
                }
                if (Basic.data[n].quadIntArray[0][0][0][0] != 2 || Basic.data[n].quadIntArray[1][0][1][0] != 2048) {
                    throw new Exception("XEP data does not match: quadIntArray");
                }
                if (!Basic.data[n].doubleStringArray[0][1].equals("string 0 1") || !Basic.data[n].doubleStringArray[1][0].equals("string 1 0")) {
                    throw new Exception("XEP data does not match: doubleStringArray");
                }
                if (!new String(Basic.data[n].arrayByte).equals("byteArrayTest " + Basic.data[n].typeInt)) {
                    throw new Exception("XEP data does not match: arrayByte");
                }
                if (!new String(Basic.data[n].arrayChar).equals("charArrayTest " + Basic.data[n].typeInt)) {
                    throw new Exception("XEP data does not match: arrayChar");
                }
                if (Basic.data[n].longMatrix[0][1][0] != 22L) {
                    throw new Exception("XEP data does not match: longMatrix");
                }
                if (Basic.data[n].floatMatrix[0][1][0][0].floatValue() != 3.2f) {
                    throw new Exception("XEP data does not match: floatMatrix");
                }
                if (!((String)((ArrayList)Basic.data[n].listListString.get(0)).get(0)).equals("List String 1")) {
                    throw new Exception("XEP data does not match: listListString");
                }
                if (((Integer[])Basic.data[n].listOfIntArrays.get(0))[1] != 21) {
                    throw new Exception("XEP data does not match: listOfIntArrays");
                }
                if (!((java.util.Date)((ArrayList)((ArrayList)Basic.data[n].dateList.get(0)).get(0)).get(0)).equals(Basic.data[n].utilDate)) {
                    throw new Exception("XEP data does not match: dateList");
                }
                if (!((SingleString)Basic.data[n].singleStringMap.get((Object)Integer.valueOf((int)77))).name.equals("Single String")) {
                    throw new Exception("XEP data does not match: singleStringMap");
                }
                if (!((ArrayList)Basic.data[n].hashTable.get("LIST STRING 1")).equals(Basic.data[n].listListString.get(0))) {
                    throw new Exception("XEP data does not match: hashTable");
                }
                if (!((SingleString)((Hashtable)Basic.data[n].mapOfMaps.get((Object)"Outside Map of Maps")).get((Object)"Inside Map of Maps")).name.equals("Single String")) {
                    throw new Exception("XEP data does not match: mapOfMaps");
                }
                if (!((String)Basic.data[n].objectKeyMap.get(Basic.data[n].singleStringMap.get(77))).equals("Object key map")) {
                    throw new Exception("XEP data does not match: mapOfMaps");
                }
                sample.typeInt = 1000;
                sample.typeString = "Changed Value";
                eventQuery.updateCurrent(sample);
            } else if (n % 101 == 0) {
                eventQuery.deleteCurrent();
            }
            ++n;
        }
        Basic.report(true, n, l);
        eventQuery.close();
        event.close();
    }

    void load() throws Exception {
        System.out.println("\nLoading XEP sample...");
        Event event = this.persister.getEvent(className);
        int n = 0;
        long l = Basic.getTime();
        EventQuery eventQuery = event.createQuery(sqlquery);
        eventQuery.setParameter(1, 0);
        eventQuery.execute();
        EventQueryIterator eventQueryIterator = eventQuery.getIterator();
        while (eventQueryIterator.hasNext()) {
            eventQueryIterator.next();
            ++n;
        }
        Basic.report(true, n, l);
        eventQuery.close();
        event.close();
    }

    static void generateSampleData(int n) {
        Random random = new Random(6284413247623391759L);
        data = new Sample[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Basic.data[i] = new Sample();
            Basic.data[i].typeByte = (byte)i;
            Basic.data[i].classByte = new Byte(Basic.data[i].typeByte);
            Basic.data[i].typeChar = (char)i;
            Basic.data[i].classChar = new Character(Basic.data[i].typeChar);
            Basic.data[i].typeBoolean = i % 2 == 0;
            Basic.data[i].classBoolean = new Boolean(Basic.data[i].typeBoolean);
            Basic.data[i].typeShort = (short)random.nextInt();
            Basic.data[i].classShort = new Short(Basic.data[i].typeShort);
            Basic.data[i].typeInt = random.nextInt();
            Basic.data[i].classInt = new Integer(Basic.data[i].typeInt);
            Basic.data[i].typeLong = random.nextLong();
            Basic.data[i].classLong = new Long(Basic.data[i].typeLong);
            Basic.data[i].typeFloat = random.nextFloat();
            Basic.data[i].classFloat = new Float(Basic.data[i].typeFloat);
            Basic.data[i].typeDouble = random.nextDouble();
            Basic.data[i].classDouble = new Double(Basic.data[i].typeDouble);
            Basic.data[i].typeString = "XEPTest";
            Basic.data[i].sqlDate = new Date(1000L * (long)random.nextInt(1000000000));
            Basic.data[i].sqlTime = new Time(1000L * (long)random.nextInt(1000000000));
            Basic.data[i].sqlTimestamp = new Timestamp(1000L * (long)random.nextInt(1000000000));
            Basic.data[i].utilDate = new java.util.Date(1000L * (long)random.nextInt(1000000000));
            Basic.data[i].arrayByte = ("byteArrayTest " + Basic.data[i].typeInt).getBytes();
            Basic.data[i].arrayChar = ("charArrayTest " + Basic.data[i].typeInt).toCharArray();
            Basic.data[i].arrayBoolean = new boolean[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayBoolean[n2] = n2 % 2 == 0;
            }
            Basic.data[i].arrayShort = new short[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayShort[n2] = (short)(Basic.data[i].typeShort + n2);
            }
            Basic.data[i].arrayInt = new int[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayInt[n2] = Basic.data[i].typeInt + n2;
            }
            Basic.data[i].arrayLong = new long[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayLong[n2] = Basic.data[i].typeInt + n2;
            }
            Basic.data[i].arrayDouble = new double[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayDouble[n2] = Basic.data[i].typeDouble + (double)n2;
            }
            Basic.data[i].arrayFloat = new float[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayFloat[n2] = Basic.data[i].typeFloat + (float)n2;
            }
            Basic.data[i].arrayString = new String[10];
            for (n2 = 0; n2 < 10; ++n2) {
                Basic.data[i].arrayString[n2] = Basic.data[i].typeString + " " + n2;
            }
            NestedThree nestedThree = new NestedThree("nested three");
            NestedTwo nestedTwo = new NestedTwo(nestedThree);
            Basic.data[i].nestedField = new NestedOne(Basic.data[i].typeInt, Basic.data[i].typeFloat, new String[]{"nestedOne"}, nestedTwo);
            Basic.data[i].nestedArrayField = new NestedOne[10];
            for (int j = 0; j < 10; ++j) {
                Basic.data[i].nestedArrayField[j] = Basic.data[i].nestedField;
            }
            Basic.data[i]._field_with_underscores = "underscore";
            Basic.data[i].innerClass = new _Inner_Class_Sample.InnerClass();
            Basic.data[i].innerClass.innerField = "innerField";
            Basic.data[i].month = SampleCore.Month.APRIL;
            Basic.data[i].day = DaysEnum.FRIDAY;
            Basic.data[i].months = new SampleCore.Month[2];
            Basic.data[i].months[0] = SampleCore.Month.JANUARY;
            Basic.data[i].months[1] = SampleCore.Month.AUGUST;
            Basic.data[i].serialized = new Serialized();
            Basic.data[i].serialized.name = "serialized field " + Basic.data[i].typeInt;
            Basic.data[i].serialized.value = Basic.data[i].typeInt;
            Basic.data[i].quadIntArray = new int[2][2][2][2];
            Basic.data[i].quadIntArray[0][0][0][0] = 2;
            Basic.data[i].quadIntArray[0][0][0][1] = 4;
            Basic.data[i].quadIntArray[0][0][1][0] = 8;
            Basic.data[i].quadIntArray[0][0][1][1] = 16;
            Basic.data[i].quadIntArray[0][1][0][0] = 32;
            Basic.data[i].quadIntArray[0][1][0][1] = 64;
            Basic.data[i].quadIntArray[0][1][1][0] = 128;
            Basic.data[i].quadIntArray[0][1][1][1] = 256;
            Basic.data[i].quadIntArray[1][0][0][0] = 512;
            Basic.data[i].quadIntArray[1][0][0][1] = 1024;
            Basic.data[i].quadIntArray[1][0][1][0] = 2048;
            Basic.data[i].quadIntArray[1][0][1][1] = 4096;
            Basic.data[i].quadIntArray[1][1][0][0] = 8192;
            Basic.data[i].quadIntArray[1][1][0][1] = 16384;
            Basic.data[i].quadIntArray[1][1][1][0] = 32768;
            Basic.data[i].quadIntArray[1][1][1][1] = 65536;
            Basic.data[i].doubleStringArray = new String[2][2];
            Basic.data[i].doubleStringArray[0][0] = "string 0 0";
            Basic.data[i].doubleStringArray[0][1] = "string 0 1";
            Basic.data[i].doubleStringArray[1][0] = "string 1 0";
            Basic.data[i].doubleStringArray[1][1] = "string 1 1";
            Basic.data[i].longMatrix = new long[2][2][2];
            Basic.data[i].longMatrix[0][0][0] = 11L;
            Basic.data[i].longMatrix[0][1][0] = 22L;
            Basic.data[i].longMatrix[1][0][0] = 33L;
            Basic.data[i].floatMatrix = new Float[2][2][2][2];
            Basic.data[i].floatMatrix[0][0][0][1] = Float.valueOf(1.0f);
            Basic.data[i].floatMatrix[0][0][1][0] = Float.valueOf(2.1f);
            Basic.data[i].floatMatrix[0][1][0][0] = Float.valueOf(3.2f);
            Basic.data[i].floatMatrix[1][0][0][0] = Float.valueOf(4.3f);
            Basic.data[i].timeVector = new Vector();
            Basic.data[i].timeVector.add(Basic.data[i].sqlTime);
            Basic.data[i].timeVector.add(Basic.data[i].sqlTime);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("List String 1");
            arrayList.add("List String 2");
            Basic.data[i].listListString = new ArrayList();
            Basic.data[i].listListString.add(arrayList);
            Basic.data[i].listOfIntArrays = new ArrayList();
            Integer[] integerArray = new Integer[]{17, 21, 25};
            Basic.data[i].listOfIntArrays.add(integerArray);
            Basic.data[i].dateList = new ArrayList();
            ArrayList<java.util.Date> arrayList2 = new ArrayList<java.util.Date>();
            arrayList2.add(Basic.data[i].utilDate);
            ArrayList<ArrayList<java.util.Date>> arrayList3 = new ArrayList<ArrayList<java.util.Date>>();
            arrayList3.add(arrayList2);
            Basic.data[i].dateList.add(arrayList3);
            Basic.data[i].shortSet = new HashSet();
            Basic.data[i].shortSet.add((short)501);
            Basic.data[i].shortSet.add((short)602);
            Basic.data[i].shortSet.add((short)703);
            Basic.data[i].shortSet.add((short)804);
            Basic.data[i].singleStringMap = new HashMap();
            SingleString singleString = new SingleString();
            singleString.name = "Single String";
            Basic.data[i].singleStringMap.put(77, singleString);
            Basic.data[i].hashTable = new Hashtable();
            Basic.data[i].hashTable.put("LIST STRING 1", arrayList);
            Basic.data[i].arrayOfStringLists = new ArrayList[2][2];
            Basic.data[i].arrayOfStringLists[0][0] = arrayList;
            Basic.data[i].arrayOfMaps = new HashMap[2];
            Basic.data[i].arrayOfMaps[0] = Basic.data[i].singleStringMap;
            Basic.data[i].mapOfMaps = new HashMap();
            Hashtable<String, SingleString> hashtable = new Hashtable<String, SingleString>();
            hashtable.put("Inside Map of Maps", singleString);
            Basic.data[i].mapOfMaps.put("Outside Map of Maps", hashtable);
            Basic.data[i].objectKeyMap = new HashMap();
            Basic.data[i].objectKeyMap.put(singleString, "Object key map");
            Basic.data[i].interfaceTest = new InterfaceTestImpl("Test interfaces");
        }
    }

    static {
        className = "com.intersys.xep.samples.Sample";
        sqlquery = "select * from com_intersys_xep_samples.Sample WHERE typeShort <> ?";
    }
}

