/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.classes.BinaryStream;
import com.intersys.classes.CharacterStream;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.SerialStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.IntegerHolder;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ObjectDump {
    private CacheClass mClass;
    private int mOref;
    private ObjectHandle mObject;
    private ObjectDump mParent;

    public ObjectDump(ObjectHandle objectHandle) throws CacheException {
        this.mObject = objectHandle;
        Database database = objectHandle.getDatabase();
        String string = objectHandle._className(new Boolean(true));
        this.mClass = database.getCacheClass(string);
        this.mOref = objectHandle.getOref();
    }

    public ObjectDump(ObjectHandle objectHandle, ObjectDump objectDump) throws CacheException {
        this(objectHandle);
        this.mParent = objectDump;
    }

    public void dump(OutputStream outputStream) throws Exception {
        this.dump(new PrintStreamDumper(outputStream));
    }

    public void dump(Dumper dumper) throws Exception {
        CacheField[] cacheFieldArray = this.mClass.getFields();
        HashSet<String> hashSet = new HashSet<String>(cacheFieldArray.length);
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            this.dumpField(dumper, cacheFieldArray[i]);
            hashSet.add(cacheFieldArray[i].getName());
        }
        CacheClass[] cacheClassArray = this.mClass.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            cacheFieldArray = cacheClassArray[i].getFields();
            for (int j = 0; j < cacheFieldArray.length; ++j) {
                if (hashSet.contains(cacheFieldArray[j].getName())) continue;
                this.dumpField(dumper, cacheFieldArray[j]);
                hashSet.add(cacheFieldArray[j].getName());
            }
        }
    }

    protected String getDisplayName() throws CacheException {
        CacheField cacheField = this.mClass.getField("Name");
        if (cacheField == null) {
            cacheField = this.mClass.getField("name");
        }
        if (cacheField != null) {
            return cacheField.get(this.mOref).toString();
        }
        return "<" + this.mClass.getName() + ">[" + this.mOref + ']';
    }

    protected boolean inStack(ObjectHandle objectHandle) throws CacheException {
        if (objectHandle.getOref() == this.mOref) {
            return true;
        }
        if (this.mParent == null) {
            return false;
        }
        return this.mParent.inStack(objectHandle);
    }

    protected void dumpField(Dumper dumper, CacheField cacheField) throws Exception {
        int n = cacheField.getModifiers();
        if (CacheModifier.isLiteral(n)) {
            this.dumpLiteral(dumper, cacheField);
        } else {
            this.dumpObject(dumper, cacheField);
        }
    }

    private void dumpLiteral(Dumper dumper, CacheField cacheField) throws CacheException {
        try {
            dumper.dump(cacheField.getName(), cacheField.get(this.mOref), this.mObject);
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Exception dumping field " + cacheField.getName());
        }
    }

    private void dumpObject(Dumper dumper, CacheField cacheField) throws Exception {
        Object object = cacheField.get(this.mOref);
        if (object instanceof SerialStream) {
            this.dumpStream(dumper, cacheField.getName(), (SerialStream)object);
        } else {
            dumper.print(cacheField.getName() + ": ");
            this.dumpObjectValue(dumper, cacheField.getName(), object);
        }
    }

    private void dumpObjectValue(Dumper dumper, String string, Object object) throws Exception {
        if (object == null) {
            dumper.handleNullObject(this.mObject, string);
            return;
        }
        if (object instanceof Collection) {
            this.dumpList(dumper, string, (Collection)object);
        } else if (object instanceof Map) {
            this.dumpArray(dumper, string, (Map)object);
        } else if (object instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object;
            ObjectDump objectDump = new ObjectDump(objectHandle, this);
            if (this.inStack(objectHandle)) {
                dumper.print(objectDump.getDisplayName());
                dumper.printReference(objectHandle, this.mObject, string);
                return;
            }
            if (dumper.indent(objectHandle, this.mObject, string)) {
                objectDump.dump(dumper);
                dumper.undent();
            }
        } else {
            dumper.println(object);
        }
    }

    private void dumpStream(Dumper dumper, String string, SerialStream serialStream) throws Exception {
        serialStream._rewind();
        IntegerHolder integerHolder = new IntegerHolder(serialStream._sizeGet());
        Object object = serialStream instanceof CharacterStream ? ((CharacterStream)serialStream)._read(integerHolder) : (serialStream instanceof BinaryStream ? (Object)((BinaryStream)serialStream)._read(integerHolder) : serialStream.getClass().getName());
        dumper.dump(string, object, this.mObject);
    }

    private void dumpList(Dumper dumper, String string, Collection collection) throws Exception {
        if (!dumper.indent(collection, this.mObject, string)) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.dumpObjectValue(dumper, string, iterator.next());
        }
        dumper.undent();
    }

    private void dumpArray(Dumper dumper, String string, Map map) throws Exception {
        if (!dumper.indent(map, this.mObject, string)) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            this.dumpObjectValue(dumper, string, iterator.next());
        }
        dumper.undent();
    }

    public static class PrintStreamDumper
    implements Dumper {
        private PrintWriter out;
        private int indentation;
        boolean terminated;

        public PrintStreamDumper(Writer writer) {
            this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
            this.indentation = 0;
            this.terminated = true;
        }

        public PrintStreamDumper(OutputStream outputStream) {
            this.out = new PrintWriter(outputStream, true);
            this.indentation = 0;
            this.terminated = true;
        }

        @Override
        public void print(Object object) {
            for (int i = 0; i < this.indentation; ++i) {
                this.out.print('\t');
            }
            this.out.print(object);
            this.terminated = false;
        }

        @Override
        public void println(Object object) {
            this.print(object);
            this.out.println();
            this.terminated = true;
        }

        @Override
        public void dump(String string, Object object, ObjectHandle objectHandle) {
            this.println(string + ": " + object);
        }

        @Override
        public boolean indent(Object object, ObjectHandle objectHandle, String string) {
            ++this.indentation;
            if (!this.terminated) {
                this.out.println();
            }
            this.terminated = true;
            return true;
        }

        @Override
        public void undent() {
            --this.indentation;
        }

        @Override
        public void printReference(ObjectHandle objectHandle, ObjectHandle objectHandle2, String string) {
            this.out.println(" ^");
        }

        @Override
        public void handleNullObject(ObjectHandle objectHandle, String string) {
            this.out.print((String)null);
        }
    }

    public static interface Dumper {
        public void dump(String var1, Object var2, ObjectHandle var3) throws IOException;

        public boolean indent(Object var1, ObjectHandle var2, String var3) throws IOException;

        public void undent() throws IOException;

        public void print(Object var1) throws IOException;

        public void println(Object var1) throws IOException;

        public void printReference(ObjectHandle var1, ObjectHandle var2, String var3) throws IOException;

        public void handleNullObject(ObjectHandle var1, String var2) throws IOException;
    }
}

