/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsse;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketFactory {
    public boolean debug = true;
    public String logFile;
    public String name;
    public String protocol;
    public String cipherSuites;
    public String keyStore;
    public String keyStoreType;
    public String keyStorePassword;
    public String keyRecoveryPassword;
    public String trustStore;
    public String trustStoreType;
    public String trustStorePassword;
    String algorithm = "SunX509";
    SSLContext ctx;
    javax.net.ssl.SSLSocketFactory sf;
    ArrayList enabled;

    public SSLSocketFactory(String string, String string2) throws Exception {
        Object object;
        Object object2;
        String string3 = System.getProperty("com.intersys.SSLConfigFile", "SSLConfig.properties");
        Properties properties = new Properties();
        properties.load(new FileInputStream(string3));
        this.autoConfig(properties, 0);
        if (string != null) {
            this.name = null;
            int n = 1;
            while ((object2 = properties.getProperty((String)(object = "name." + n))) != null) {
                if (((String)object2).equals(string)) {
                    this.autoConfig(properties, n);
                    break;
                }
                ++n;
            }
            if (this.name == null) {
                String string4 = "SSL/TLS: configuration " + string + " not found in file " + string3;
                if (this.debug) {
                    System.err.println(string4);
                }
                throw new Exception(string4);
            }
        }
        if (this.protocol == null) {
            String string5 = "SSL/TLS:  protocol must be specified";
            if (this.debug) {
                System.err.println(string5);
            }
            throw new Exception(string5);
        }
        object = null;
        if (this.keyStore != null) {
            if (this.keyStoreType == null) {
                String string6 = "SSL/TLS:  keyStoreType must be specified for keyStore " + this.keyStore;
                if (this.debug) {
                    System.err.println(string6);
                }
                throw new Exception(string6);
            }
            if (this.keyRecoveryPassword == null && string2 != null) {
                this.keyRecoveryPassword = string2;
            }
            if (this.keyRecoveryPassword == null) {
                String string7 = "SSL/TLS:  keyRecoveryPassword must be specified for keyStore " + this.keyStore;
                if (this.debug) {
                    System.err.println(string7);
                }
                throw new Exception(string7);
            }
            object2 = KeyStore.getInstance(this.keyStoreType);
            ((KeyStore)object2).load(new FileInputStream(this.keyStore), this.keyStorePassword.toCharArray());
            object = KeyManagerFactory.getInstance(this.algorithm);
            ((KeyManagerFactory)object).init((KeyStore)object2, this.keyRecoveryPassword.toCharArray());
        }
        object2 = null;
        if (this.trustStore != null) {
            if (this.trustStoreType == null) {
                String string8 = "SSL/TLS:  trustStoreType must be specified for trustStore " + this.trustStore;
                if (this.debug) {
                    System.err.println(string8);
                }
                throw new Exception(string8);
            }
            KeyStore keyStore = KeyStore.getInstance(this.trustStoreType);
            keyStore.load(new FileInputStream(this.trustStore), this.trustStorePassword.toCharArray());
            object2 = TrustManagerFactory.getInstance(this.algorithm);
            ((TrustManagerFactory)object2).init(keyStore);
        }
        SecureRandom secureRandom = new SecureRandom();
        long l = System.currentTimeMillis();
        secureRandom.nextBytes(new byte[1]);
        long l2 = System.currentTimeMillis();
        if (this.debug) {
            System.err.println("RNG seeding time " + (l2 - l) + " msec");
        }
        this.ctx = SSLContext.getInstance(this.protocol);
        this.ctx.init(object == null ? null : ((KeyManagerFactory)object).getKeyManagers(), object2 == null ? null : ((TrustManagerFactory)object2).getTrustManagers(), secureRandom);
        this.sf = this.ctx.getSocketFactory();
        List<String> list = Arrays.asList(this.sf.getSupportedCipherSuites());
        if (this.debug) {
            System.err.println("Supported CipherSuites:");
            System.err.println(list);
        }
        if (this.cipherSuites == null && this.debug) {
            System.err.println("Default CipherSuites:");
            System.err.println(Arrays.asList(this.sf.getSupportedCipherSuites()));
        } else {
            this.enabled = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.cipherSuites, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string9 = stringTokenizer.nextToken();
                if (!list.contains(string9)) continue;
                this.enabled.add(string9);
            }
            if (this.enabled.isEmpty()) {
                String string10 = "SSL/TLS:  No CipherSuites are enabled";
                if (this.debug) {
                    System.err.println(string10);
                }
                throw new Exception(string10);
            }
            if (this.debug) {
                System.err.println("Enabled CipherSuites:");
                System.err.println(this.enabled);
            }
        }
    }

    public SSLSocket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(string, n);
        if (this.enabled != null) {
            sSLSocket.setEnabledCipherSuites(this.enabled.toArray(new String[0]));
        }
        return sSLSocket;
    }

    void autoConfig(Properties properties, int n) throws Exception {
        Field[] fieldArray = this.getClass().getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string;
            if (Modifier.isFinal(fieldArray[i].getModifiers())) continue;
            String string2 = fieldArray[i].getName();
            if (n > 0) {
                string2 = string2 + "." + n;
            }
            Class<?> clazz = fieldArray[i].getType();
            if (this.debug) {
                System.err.println(string2 + " (" + clazz + ")");
            }
            if ((string = properties.getProperty(string2)) == null) continue;
            if (this.debug) {
                System.err.println("\t=" + string);
            }
            try {
                if (clazz == Integer.TYPE) {
                    fieldArray[i].setInt(this, Integer.parseInt(string));
                    continue;
                }
                if (clazz == Boolean.TYPE) {
                    fieldArray[i].setBoolean(this, Boolean.valueOf(string));
                    continue;
                }
                if (clazz != String.class) continue;
                fieldArray[i].set(this, string);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                System.err.println("Setting value for property " + string2);
                System.exit(1);
            }
        }
    }
}

