/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jgss;

import com.intersys.jgss.GSSCallbackHandler;
import com.intersys.jgss.GSSSocketInputStream;
import com.intersys.jgss.GSSSocketOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSSocket
extends Socket {
    private static final int MIN_CSL = 1;
    public static final int AUTHENTICATION = 1;
    public static final int INTEGRITY = 2;
    public static final int CONFIDENTIALITY = 3;
    private static final int MAX_CSL = 3;
    private int csl;
    private InputStream is;
    private OutputStream os;
    private DataInputStream dis;
    private DataOutputStream dos;
    private byte[] preamble = new byte[]{0, 0, 127, 1, 0};
    private GSSContext context;

    public GSSSocket(InetAddress inetAddress, int n, String string, int n2, String string2, String string3) throws IOException {
        super(inetAddress, n);
        this.initialize(string, n2, string2, string3);
    }

    public GSSSocket(String string, int n, String string2, int n2, String string3, String string4) throws UnknownHostException, IOException {
        super(string, n);
        this.initialize(string2, n2, string3, string4);
    }

    public GSSSocket(InetAddress inetAddress, int n, String string, int n2) throws IOException {
        this(inetAddress, n, string, n2, null, null);
    }

    public GSSSocket(String string, int n, String string2, int n2) throws UnknownHostException, IOException {
        this(string, n, string2, n2, null, null);
    }

    private void initialize(String string, int n, String string2, String string3) throws IOException {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Invalid connection security level");
        }
        this.csl = n;
        this.preamble[4] = (byte)n;
        this.is = super.getInputStream();
        this.os = super.getOutputStream();
        this.dis = new DataInputStream(this.is);
        this.dos = new DataOutputStream(this.os);
        this.dos.write(this.preamble);
        this.dos.flush();
        try {
            GSSCallbackHandler gSSCallbackHandler = new GSSCallbackHandler(string2, string3);
            LoginContext loginContext = null;
            try {
                loginContext = new LoginContext("com.sun.security.jgss.initiate", gSSCallbackHandler);
                loginContext.login();
            }
            catch (LoginException loginException) {
                throw new IOException(loginException.toString());
            }
            catch (SecurityException securityException) {
                throw new IOException(securityException.toString());
            }
            Subject subject = loginContext.getSubject();
            GSSInitializeAction gSSInitializeAction = new GSSInitializeAction(string, n, this.dis, this.dos);
            try {
                Subject.doAs(subject, gSSInitializeAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new IOException(privilegedActionException.toString());
            }
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                throw new IOException(loginException.toString());
            }
            this.context = gSSInitializeAction.getContext();
            if (!this.context.getMutualAuthState()) {
                throw new IOException("Mutual authentication failure");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        switch (this.csl) {
            case 1: {
                return this.is;
            }
            case 2: 
            case 3: {
                return new GSSSocketInputStream(this);
            }
        }
        throw new IOException();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        switch (this.csl) {
            case 1: {
                return this.os;
            }
            case 2: 
            case 3: {
                return new GSSSocketOutputStream(this);
            }
        }
        throw new IOException();
    }

    synchronized void sendToken(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        try {
            MessageProp messageProp = new MessageProp(0, this.csl == 3);
            byArray2 = this.context.wrap(byArray, n, n2, messageProp);
        }
        catch (GSSException gSSException) {
            throw new IOException(gSSException.toString());
        }
        this.dos.writeInt(byArray2.length);
        this.dos.write(byArray2);
        this.dos.flush();
    }

    boolean tokenAvailable() throws IOException {
        return this.dis.available() > 0;
    }

    synchronized byte[] receiveToken() throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[this.dis.readInt()];
        this.dis.readFully(byArray2);
        try {
            MessageProp messageProp = new MessageProp(0, false);
            byArray = this.context.unwrap(byArray2, 0, byArray2.length, messageProp);
        }
        catch (GSSException gSSException) {
            throw new IOException(gSSException.toString());
        }
        return byArray;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.context != null) {
                this.context.dispose();
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        super.close();
    }

    class GSSInitializeAction
    implements PrivilegedExceptionAction {
        String service;
        int csl;
        GSSContext context;
        DataInputStream dis;
        DataOutputStream dos;

        public GSSInitializeAction(String string, int n, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
            this.service = string;
            this.csl = n;
            this.dis = dataInputStream;
            this.dos = dataOutputStream;
        }

        public Object run() throws PrivilegedActionException {
            try {
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSManager gSSManager = GSSManager.getInstance();
                GSSName gSSName = gSSManager.createName(this.service, null);
                this.context = gSSManager.createContext(gSSName, oid, null, 0);
                this.context.requestMutualAuth(true);
                if (this.csl == 2) {
                    this.context.requestInteg(true);
                }
                if (this.csl == 3) {
                    this.context.requestConf(true);
                }
                byte[] byArray = new byte[]{};
                while (!this.context.isEstablished()) {
                    if ((byArray = this.context.initSecContext(byArray, 0, byArray.length)) != null) {
                        this.dos.writeInt(byArray.length);
                        this.dos.write(byArray);
                        this.dos.flush();
                    }
                    if (this.context.isEstablished()) continue;
                    byArray = new byte[this.dis.readInt()];
                    this.dis.readFully(byArray);
                }
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
            return null;
        }

        public GSSContext getContext() {
            return this.context;
        }
    }
}

