/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.VersionInfo;
import com.intersys.jdbc.SysList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public final class LogFileStream {
    static final int LOG_RECEIVED = 0;
    static final int LOG_SENT = 1;
    private static final String ls = System.getProperty("line.separator");
    private PrintWriter output;
    private String jobID = "-1";
    private StringBuffer buffer;
    private StringBuffer asciiDump;
    private boolean closed = false;

    public LogFileStream(PrintWriter printWriter) throws IOException {
        this.output = printWriter;
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        this.dumpHeader();
    }

    public LogFileStream(String string) throws IOException {
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        File file = new File(string);
        this.output = new PrintWriter(new FileOutputStream(file, true), true);
        this.dumpHeader();
    }

    public synchronized void setJobID(String string) {
        this.jobID = string;
    }

    public void dumpHeader() {
        this.output.print(ls + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        this.output.print(ls + "\tStarted At:\t" + DateFormat.getDateTimeInstance().format(new Date()));
        this.output.print(ls + "\tDriver Name:\tcom.intersys.jdbc.CacheDriver");
        this.output.print(ls + "\tJar File Name:\t" + VersionInfo.getJarFileName());
        this.output.print(ls + "\tClient Version:\t" + VersionInfo.getClientVersion());
        this.output.print(ls + "\tCompiled At:\t" + VersionInfo.compiledAt());
        this.output.print(ls + "\tJDBC Version:\t" + VersionInfo.getJDBCVersion());
        this.output.print(ls + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" + ls);
        this.output.flush();
    }

    public void dump(Object object, int n, int n2, byte[] byArray) {
        this.dump(((SysList)object).getm_aData(), n, ((SysList)object).getLength(), n2, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void dump(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        this.asciiDump.delete(0, this.asciiDump.length());
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            int n4;
            if (n3 == 1) {
                this.buffer.append(ls + "Sent: [Job number = " + this.jobID + "]" + ls);
            } else {
                this.buffer.append(ls + "Received: [Job number = " + this.jobID + "]" + ls);
            }
            if (byArray2 != null) {
                for (n4 = 0; n4 < 14; ++n4) {
                    this.appendCurrent(byArray2[n4]);
                }
                this.formatLine(0, false);
            }
            int n5 = n % 14 - 1;
            int n6 = n2;
            if (byArray.length > n + n2) {
                n6 += n;
            }
            for (n4 = n; n4 < n6; ++n4) {
                this.appendCurrent(byArray[n4]);
                if ((n4 - n5) % 14 != 0) continue;
                this.formatLine(0, false);
            }
            this.formatLine(14 - (n2 - n) % 14, true);
            PrintWriter printWriter = this.output;
            synchronized (printWriter) {
                this.output.println(this.buffer);
            }
            this.buffer.delete(0, this.buffer.length());
        }
        this.output.flush();
    }

    private synchronized void appendCurrent(byte by) {
        if (by < 0) {
            this.buffer.append(256 + by + " ");
        } else if (by < 10) {
            this.buffer.append("  " + by + " ");
        } else if (by < 100) {
            this.buffer.append(" " + by + " ");
        } else {
            this.buffer.append(by + " ");
        }
        if (by > 32 && by < 127) {
            this.asciiDump.append((char)by);
        } else {
            this.asciiDump.append(".");
        }
    }

    private synchronized void formatLine(int n, boolean bl) {
        this.asciiDump.insert(0, "     ");
        for (int i = 0; i < n; ++i) {
            this.asciiDump.insert(0, "    ");
        }
        if (bl) {
            this.buffer.append(this.asciiDump.toString());
        } else {
            this.buffer.append(this.asciiDump.toString() + ls);
        }
        this.asciiDump.delete(0, this.asciiDump.length());
    }

    public synchronized void logApi(String string) {
        this.output.println();
        this.output.println(string);
        this.output.flush();
    }

    public void close() {
        if (!this.closed) {
            this.output.close();
            this.closed = true;
        }
    }

    protected void finalize() {
        if (!this.closed) {
            this.output.close();
        }
    }
}

