/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.codegenerator.java;

import com.intersys.cache.metadata.CacheClassIntrospector;
import com.intersys.classes.CPPStoredProc;
import com.intersys.codegenerator.java.GenFlags;
import com.intersys.codegenerator.java.GeneratorDisplay;
import com.intersys.codegenerator.java.Java;
import com.intersys.codegenerator.java.Messages;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.SList;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SysListHolder;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.TableMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class JavaRoot {
    private Connection mCon;
    private Database mDB;
    private String mSuperClass;
    private String mHost;
    private String mPort;
    private String mNameSpace;
    private String mCommentNameSpace;
    private String mFlags;
    private String mRootDir;
    private String mUserName;
    private String mPassword;
    private HashMap mClassMap;
    private String mLogFile;
    private boolean mDisplay;
    private GeneratorDisplay mOutputList;
    public GenFlags mGenFlags;
    public Properties mProperties;

    public JavaRoot() throws CacheException {
        this.setRunTimeSwitches(System.getProperties());
    }

    public JavaRoot(Properties properties) throws CacheException {
        this.setRunTimeSwitches(properties);
    }

    public JavaRoot(Properties properties, String string) throws CacheException {
        properties.setProperty("password", string);
        this.setRunTimeSwitches(properties);
    }

    public void setRunTimeSwitches(Properties properties) throws CacheException {
        this.mHost = properties.getProperty("host", "localhost");
        this.mPort = properties.getProperty("port", "1972");
        this.mNameSpace = properties.getProperty("namespace", "SAMPLES");
        this.mCommentNameSpace = properties.getProperty("commentnamespace", this.mNameSpace);
        this.mFlags = properties.getProperty("flags", "/documatichost=" + this.mHost + "/documaticport=" + this.mPort);
        this.mUserName = properties.getProperty("user", "_SYSTEM");
        this.mPassword = properties.getProperty("password", "SYS");
        this.mRootDir = properties.getProperty("rootdir", Messages.getString("JavaRoot.15"));
        this.mLogFile = properties.getProperty("logfile", "");
        this.mDisplay = new Boolean(properties.getProperty("display", "true"));
        this.mGenFlags = new GenFlags(this.mFlags, this.mHost, this.mPort);
        this.mProperties = properties;
    }

    public void setRootDir(String string) {
        this.mRootDir = string;
    }

    public void setDisplay(boolean bl) {
        this.mDisplay = bl;
    }

    public void setNewCollections(boolean bl) {
        this.mFlags = this.mGenFlags.canonizeFlags(this.mGenFlags.mDocumaticHost, this.mGenFlags.mDocumaticPort, bl, this.mGenFlags.mPrimitiveDataTypes, this.mGenFlags.mGenerationType);
        try {
            this.mGenFlags = new GenFlags(this.mFlags, this.mHost, this.mPort);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void setGenerationType(int n) {
        this.mFlags = this.mGenFlags.canonizeFlags(this.mGenFlags.mDocumaticHost, this.mGenFlags.mDocumaticPort, this.mGenFlags.mNewCollections, this.mGenFlags.mPrimitiveDataTypes, n);
        try {
            this.mGenFlags = new GenFlags(this.mFlags, this.mHost, this.mPort);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void setPrimitiveDataTypes(boolean bl) {
        this.mFlags = this.mGenFlags.canonizeFlags(this.mGenFlags.mDocumaticHost, this.mGenFlags.mDocumaticPort, this.mGenFlags.mNewCollections, bl, this.mGenFlags.mGenerationType);
        try {
            this.mGenFlags = new GenFlags(this.mFlags, this.mHost, this.mPort);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public String getRootDir() {
        return this.mRootDir;
    }

    public static void main(String[] stringArray) {
        try {
            JavaRoot javaRoot = new JavaRoot();
            javaRoot.run(stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Database getDB() throws ClassNotFoundException, CacheException, SQLException {
        Class.forName("com.intersys.jdbc.CacheDriver");
        String string = "jdbc:Cache://" + this.mHost + ":" + this.mPort + "/" + this.mNameSpace;
        String string2 = "";
        if (!this.mLogFile.equals("")) {
            string2 = "/" + this.mLogFile;
        }
        string = string + string2;
        this.mCon = DriverManager.getConnection(string, this.mProperties);
        return CacheDatabase.getDatabase(this.mCon);
    }

    public void run(String[] stringArray) throws ClassNotFoundException, SQLException, CacheException, IOException {
        this.mDB = this.getDB();
        this.run(this.mDB, stringArray, null);
    }

    public void run(Database database, Object[] objectArray, GeneratorDisplay generatorDisplay) throws ClassNotFoundException, SQLException, CacheException, IOException {
        Object object2;
        this.mDB = database;
        this.mClassMap = new HashMap();
        String string = "";
        String string2 = "";
        this.mOutputList = generatorDisplay;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals("-package")) {
                String string3 = (String)objectArray[++i];
                object2 = this.getClassesInPackage(string3);
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    try {
                        this.validateClass(object2[j]);
                    }
                    catch (CacheException cacheException) {
                        System.out.println(Messages.getString("JavaRoot.30") + cacheException.getMessage());
                        continue;
                    }
                    string = string + string2 + object2[j];
                    string2 = ",";
                }
                continue;
            }
            string = string + string2 + objectArray[i];
            string2 = ",";
        }
        if (string.equals("")) {
            throw new CacheException(Messages.getString("JavaRoot.34"));
        }
        String[] stringArray = this.getDependencies(string);
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            this.validateClass((String)object2);
            CacheClassIntrospector cacheClassIntrospector = new CacheClassIntrospector(this.mDB, (String)object2);
            this.mClassMap.put(object2, cacheClassIntrospector);
        }
        for (Object object2 : this.mClassMap.values()) {
            this.export((CacheClassMetadata)object2, this.mRootDir);
            if (this.mGenFlags.mGenerationType != 2) continue;
            this.mGenFlags.setIsInterface(true);
            this.export((CacheClassMetadata)object2, this.mRootDir);
            this.mGenFlags.setIsInterface(false);
        }
    }

    public void test(String string) throws ClassNotFoundException, SQLException, CacheException, IOException {
        this.mDB = this.getDB();
        System.out.println(Messages.getString("JavaRoot.35"));
        CacheClassIntrospector cacheClassIntrospector = new CacheClassIntrospector(this.mDB, string, this.mFlags);
        System.out.println(Messages.getString("JavaRoot.36"));
        CacheField[] cacheFieldArray = cacheClassIntrospector.getDeclaredFields();
        System.out.println(Messages.getString("JavaRoot.37"));
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            TableMetadata tableMetadata = cacheFieldArray[i].getChildTableMetadata();
            if (tableMetadata == null) continue;
            System.out.println(cacheFieldArray[i].getName());
            System.out.println(Messages.getString("JavaRoot.38") + tableMetadata.getSchemaName());
            System.out.println(Messages.getString("JavaRoot.39") + tableMetadata.getName());
            System.out.println(Messages.getString("JavaRoot.40") + cacheFieldArray[i].getName());
            for (int j = tableMetadata.getMinColumnNumber(); j <= tableMetadata.getMaxColumnNumber(); ++j) {
                System.out.println("\t" + tableMetadata.getColumn(j).getName());
            }
        }
    }

    public void export(CacheClassMetadata cacheClassMetadata, String string) throws SQLException, CacheException, IOException {
        Holder holder = new Holder(null);
        File file = this.constructDir(string, cacheClassMetadata.getJavaPackage());
        String string2 = this.constructFileName(file, cacheClassMetadata.getJavaClassName(), this.mGenFlags.getIsInterface());
        if (this.mDisplay) {
            System.out.println(Messages.getString("JavaRoot.42") + string2);
        }
        if (this.mOutputList != null) {
            this.mOutputList.add(Messages.getString("JavaRoot.43") + string2);
        }
        file.mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
        Java java = new Java(printWriter, this.mDB, this.mCon, this.mHost, this.mPort, this.mNameSpace, this.mFlags, this.mCommentNameSpace, this.mGenFlags, this.mClassMap, !this.mGenFlags.getIsInterface());
        java.run(cacheClassMetadata);
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getClassExists(String string) throws SQLException, CacheException {
        CallableStatement callableStatement = null;
        try {
            boolean bl;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_getClassExists(?,?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.registerOutParameter(3, 16);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
            boolean bl2 = bl = callableStatement.getBoolean(3);
            return bl2;
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    public String[] getDependencies(String string) throws SQLException, CacheException {
        SysListHolder sysListHolder = new SysListHolder(null);
        CPPStoredProc.getClassDependencies(this.mDB, string, sysListHolder, 2, true);
        SList sList = sysListHolder.value;
        String[] stringArray = new String[sList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)sList.get(i);
        }
        return stringArray;
    }

    public String[] getClassesInPackage(String string) throws SQLException, CacheException {
        String[] stringArray;
        SysListHolder sysListHolder = new SysListHolder(null);
        CPPStoredProc.getClassesForPackage(this.mDB, string, sysListHolder, 2, true);
        SList sList = sysListHolder.value;
        if (sList != null) {
            stringArray = new String[sList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)sList.get(i);
            }
        } else {
            System.out.println(Messages.getString("JavaRoot.45") + string);
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateClass(String string) throws SQLException, CacheException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_ValidateClass(?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    public File constructDir(String string, String string2) {
        string2.replace('.', File.separatorChar);
        return new File(string, string2);
    }

    public String constructFileName(File file, String string, boolean bl) {
        String string2 = Java.shortName(string);
        if (bl) {
            string2 = "I" + string2;
        }
        return new File(file, string2 + ".java").getAbsolutePath();
    }

    private class Holder {
        public Object mValue;

        public Holder(Object object) {
            this.mValue = object;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object object) {
            this.mValue = object;
        }
    }
}

