/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.LazyList;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ArrayBackedStorage;
import com.intersys.cache.quick.ChildTableField;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.ColumnOnlyField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.PojoBackedStorage;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickRelationshipObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Persistent;
import com.intersys.classes.PersistentWrapper;
import com.intersys.classes.RelationshipObject;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TypeModifierHelper;
import com.intersys.objects.reflect.TypeModifiers;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.ObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class QuickPersistentObject
extends QuickCacheObject
implements Mappings {
    private static boolean ENABLE_DEBUG_CLOSED = false;
    private static final int INITIAL_FETCH_SIZE = 10;
    private static final int MAX_FETCH_SIZE = 100;
    private static final byte DIRTY = 1;
    private static final byte REF_DIRTY = 2;
    private static final byte INVALID = 4;
    private static final byte SAVED = 8;
    private static final byte CLEAN = 0;
    private static Object NULL_SYS_LIST = SysListProxy.createSysList();
    private Object mFieldValues;
    private byte[] mFieldState;
    private int mLoadMethod;
    protected boolean inSave = false;
    private LocalStorage mStorage;

    private QuickPersistentObject(TableBasedClass tableBasedClass) throws CacheException {
        super(tableBasedClass);
        this.mLoadMethod = 7503;
        int n = tableBasedClass.getNumberOfCachedElements();
        this.mFieldState = new byte[n];
        Arrays.fill(this.mFieldState, (byte)0);
        this.setStateInvalidated();
    }

    private QuickPersistentObject(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        super(tableBasedClass);
        this.mLoadMethod = n;
        if (Logger.getDebugCache()) {
            Logger.out.println("Loaded object: ");
            QuickPersistentObject.logData(object);
        }
        this.mFieldValues = object;
        int n2 = tableBasedClass.getNumberOfCachedElements();
        this.mFieldState = new byte[n2];
        Arrays.fill(this.mFieldState, (byte)0);
        this.mState = 65281;
    }

    public static QuickPersistentObject createPojoBackedObject(TableBasedClass tableBasedClass, Object object, Object object2) throws CacheException {
        QuickPersistentObject quickPersistentObject = QuickPersistentObject.createPojoBackedObject(tableBasedClass, object);
        quickPersistentObject.mStorage.setCachedId(new Dataholder(24, null));
        return quickPersistentObject;
    }

    public static QuickPersistentObject createPojoBackedObject(TableBasedClass tableBasedClass, Object object) throws CacheException {
        QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass);
        if (object == null) {
            PojoBackedStorage pojoBackedStorage = new PojoBackedStorage(quickPersistentObject);
            quickPersistentObject.setCleanStorage(pojoBackedStorage);
        } else {
            PojoBackedStorage pojoBackedStorage = new PojoBackedStorage(quickPersistentObject, object);
            quickPersistentObject.setDirtyStorage(pojoBackedStorage);
        }
        return quickPersistentObject;
    }

    public static QuickPersistentObject createArrayBackedObject(TableBasedClass tableBasedClass) throws CacheException {
        QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass);
        ArrayBackedStorage arrayBackedStorage = new ArrayBackedStorage(quickPersistentObject);
        quickPersistentObject.setCleanStorage(arrayBackedStorage);
        return quickPersistentObject;
    }

    public static QuickPersistentObject createPojoBackedObject(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass, object, n);
        PojoBackedStorage pojoBackedStorage = new PojoBackedStorage(quickPersistentObject);
        quickPersistentObject.setCleanStorage(pojoBackedStorage);
        return quickPersistentObject;
    }

    public static QuickPersistentObject createArrayBackedObject(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass, object, n);
        ArrayBackedStorage arrayBackedStorage = new ArrayBackedStorage(quickPersistentObject);
        quickPersistentObject.setCleanStorage(arrayBackedStorage);
        return quickPersistentObject;
    }

    private void setDirtyStorage(LocalStorage localStorage) {
        this.mStorage = localStorage;
        for (int i = 0; i < this.mFieldState.length; ++i) {
            this.makeDirty(i);
        }
        this.mState |= 0xFF10;
    }

    private void setCleanStorage(LocalStorage localStorage) throws CacheException {
        this.mStorage = localStorage;
        this.mStorage.initCachedValues();
    }

    @Override
    public void setPojo(Object object) throws CacheException {
        this.cleanupCachedValues();
        this.setDirtyStorage(new PojoBackedStorage(this, object));
    }

    @Override
    public boolean isClosed() {
        return !this.cachedValuesNotNull() || super.isClosed();
    }

    private void assertNotClosed() {
        if (this.cachedValuesNotNull()) {
            return;
        }
        QuickPersistentObject.throwClosedException("Access to closed object. Count = " + this.getCount());
    }

    @Override
    public Id getId() throws CacheException {
        if (!this.cachedValuesNotNull()) {
            return null;
        }
        String string = this.getIdValue();
        if (string == null) {
            return null;
        }
        return new Id(string);
    }

    @Override
    public Oid getOid() throws CacheException {
        if (!this.cachedValuesNotNull()) {
            return null;
        }
        String string = this.getIdValue();
        if (string == null) {
            return null;
        }
        return new Oid(string, this.mClass.getName());
    }

    @Override
    protected String getIdValue() throws CacheException {
        return this.getProperty(this.mClass.getIdField()).getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newJavaInstance() throws CacheException {
        LightDatabase lightDatabase;
        LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
        synchronized (lightDatabase2) {
            if (this.getCount() < 0) {
                this.reinstate();
                this.initCachedValues();
                String string = this.getProperty(this.mClass.getIdField()).getString();
                lightDatabase.addToMap(this, null, this.mClass.getName(), string);
            }
            return super.newJavaInstance();
        }
    }

    @Override
    public synchronized void forceClose() throws CacheException {
        ((LightDatabase)this.getDatabase()).closeObject(this.getOid(), this);
        this.cleanup();
        super.forceClose();
        this.mFieldValues = null;
        this.addStateInvalidated();
    }

    @Override
    protected synchronized void cleanup() {
        this.cleanupCachedValues();
        if (ENABLE_DEBUG_CLOSED) {
            // empty if block
        }
        this.setStateInvalidated();
        super.cleanup();
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected boolean isInSave() {
        return this.inSave;
    }

    @Override
    public synchronized int save(boolean bl) throws CacheException {
        return this.save(bl, false);
    }

    public final synchronized int save(boolean bl, boolean bl2) throws CacheException {
        Object object = ((LightDatabase)this.getDatabase()).createSysList();
        try {
            this.save(object, false, bl, bl2);
        }
        catch (CacheException cacheException) {
            if (this.mFieldState != null) {
                for (int i = 0; i < this.mFieldState.length; ++i) {
                    this.clearSaved(i);
                }
            }
            this.inSave = false;
            throw cacheException;
        }
        return 1;
    }

    @Override
    public int saveRequiredFields() throws CacheException {
        Object object = ((LightDatabase)this.getDatabase()).createSysList();
        this.save(object, false, false, true);
        return 1;
    }

    public synchronized int save(Object object, boolean bl, boolean bl2, boolean bl3) throws CacheException {
        Object object2;
        TypeModifiers typeModifiers;
        if (this.inSave) {
            if (bl) {
                try {
                    SysListProxy.setInteger(object, 0);
                }
                catch (SQLException sQLException) {
                    throw new SystemError("Failed to set number of columns");
                }
            }
            if (this.getId() != null) {
                if (bl) {
                    return 0;
                }
                return 1;
            }
            try {
                if (!bl) {
                    SysListProxy.setInteger(object, 0);
                }
            }
            catch (SQLException sQLException) {
                throw new SystemError("Failed to set number of columns");
            }
            Object object3 = ((LightDatabase)this.getDatabase()).create(this.mClass, object, this);
            this.setProperty(this.mClass.getIdField(), Dataholder.create(object3), false, true);
            if (bl) {
                return 0;
            }
            return 1;
        }
        this.inSave = true;
        boolean bl4 = false;
        int n = this.mClass.isChild() ? 2 : 1;
        try {
            SysListProxy.setInteger(object, this.mClass.getNumberOfColumnsForSet() - n);
        }
        catch (SQLException sQLException) {
            throw new SystemError("Failed to set number of columns");
        }
        boolean bl5 = false;
        boolean bl6 = false;
        Object object4 = null;
        int n2 = 0;
        int n3 = -1234567;
        if (this.mClass.isChild()) {
            n3 = ((ColumnBasedField)this.mClass.getParentField()).getColumnIndexForSet();
        }
        int n4 = -1;
        boolean bl7 = false;
        Object object5 = this.mClass.getAllSettableFieldsIterator();
        while (object5.hasNext()) {
            block70: {
                try {
                    boolean bl8;
                    typeModifiers = (ColumnBasedField)object5.next();
                    if (n2 != typeModifiers.getColumnIndexForSet()) {
                        throw new SystemError("Expected column " + n2 + ", instead got " + typeModifiers.getColumnIndexForSet());
                    }
                    if (n2 == this.mClass.getIdField().getColumnIndexForSet()) break block70;
                    this.assertNotClosed();
                    object2 = this.getInternalCachedValue((ColumnBasedField)typeModifiers);
                    if (typeModifiers.isVersionField()) {
                        if (object2 == null) {
                            object2 = this.getProperty((ColumnBasedField)typeModifiers);
                        }
                        if (object2 != null && object2 instanceof Dataholder) {
                            Dataholder dataholder = (Dataholder)object2;
                            if (dataholder.getObject() == null || dataholder.getLongValue() < 0L) {
                                dataholder = new Dataholder(0);
                            }
                            if (this.isSaved(n2)) {
                                SysListProxy.setUndefined(object);
                            } else {
                                dataholder.stuff(object);
                                this.markSaved(n2);
                            }
                            n4 = n2;
                            break block70;
                        }
                    }
                    boolean bl9 = bl8 = n2 == n3;
                    if (this.isSaved(n2)) {
                        object2 = null;
                    } else {
                        if (bl3 && !typeModifiers.isRequired()) {
                            if (!typeModifiers.isChildTable()) {
                                SysListProxy.setUndefined(object);
                            }
                            bl7 = true;
                            break block70;
                        }
                        if (!(bl8 || this.isValid(n2) || typeModifiers.isCollection() || QuickPersistentObject.isMutable(object2) || typeModifiers.isPersistent())) {
                            object2 = null;
                        } else if (this.isRefDirty(n2)) {
                            if ((object2 = this.valueToSave((ColumnBasedField)typeModifiers, object2, bl2)) != null) {
                                if (typeModifiers.isCollection()) {
                                    this.checkCollectionOldValue((ColumnBasedField)typeModifiers, object2);
                                } else if (typeModifiers.isStream()) {
                                    this.markDirty(n2);
                                }
                            }
                            if (typeModifiers.isOneToManyRelationship()) {
                                this.markSaved(n2);
                                this.invalidate(n2, true);
                                bl6 = true;
                            }
                        } else if (QuickPersistentObject.isMutable(object2) && this.mFieldValues != null) {
                            if ((object2 = this.valueToSave((ColumnBasedField)typeModifiers, object2, bl2)) == null) break block70;
                            int n5 = typeModifiers.getColumnIndexForGet();
                            byte[] byArray = SysListProxy.getByte(this.mFieldValues, n5 - 1);
                            if (object2.equals(byArray)) {
                                object2 = null;
                            } else {
                                this.markDirty(n2);
                            }
                        }
                    }
                    if (object2 == null || !this.isDirty(n2) && !bl8) {
                        if (!typeModifiers.isChildTable()) {
                            SysListProxy.setUndefined(object);
                        }
                        int n6 = n2;
                        this.mFieldState[n6] = (byte)(this.mFieldState[n6] & 0xFFFFFFFE);
                    } else {
                        Dataholder dataholder;
                        bl5 = true;
                        bl6 = true;
                        if (object2 instanceof Dataholder && (dataholder = (Dataholder)object2).getObject() == null) {
                            object2 = null;
                        }
                        if (object2 == UNCHANGED) {
                            bl4 = true;
                            if (!typeModifiers.isChildTable()) {
                                throw new SystemError("Unexpected value.");
                            }
                        } else if (bl8) {
                            if (!typeModifiers.isObject()) {
                                throw new SystemError("Reference class expected  for parent column: class: " + this.mClass.getName() + ", column: " + typeModifiers.getName());
                            }
                            object4 = object2;
                        } else {
                            if (object2 instanceof byte[] && ((byte[])object2).length == 0 && "%Library.List".equals(typeModifiers.getType().getName())) {
                                object2 = null;
                            }
                            if (typeModifiers.isReadOnly()) {
                                SysListProxy.setUndefined(object);
                            } else {
                                SysListProxy.setObject(object, object2);
                            }
                            this.markSaved(n2);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new SystemError(sQLException, "Failed to set value to col #" + n2 + " for Object of class " + this.mClass.getName() + "; id = " + this.getId());
                }
            }
            ++n2;
        }
        object5 = this.getProperty(this.mClass.getIdField());
        typeModifiers = (LightDatabase)this.getDatabase();
        if (bl) {
            this.inSave = false;
            if (!bl5) {
                if (n4 >= 0) {
                    return 1;
                }
                return 0;
            }
            if (bl4) {
                return 2;
            }
            return 1;
        }
        if (!bl5 && Logger.getDebugCache()) {
            Logger.out.println("Does not need save: " + object5 + "@" + this.mClass.getName());
        }
        if (((Dataholder)object5).getObject() == null && this.mFieldValues == null) {
            if (this.mClass.isChild()) {
                object2 = ((LightDatabase)typeModifiers).createChild(this.mClass, object4, object, this);
                object5 = new Dataholder((String)object2);
                if (bl7) {
                    this.setId((Dataholder)object5);
                }
            } else {
                object2 = ((LightDatabase)typeModifiers).create(this.mClass, object, this);
                object5 = Dataholder.create(object2);
                this.setId((Dataholder)object5);
            }
            bl5 = true;
        } else if (bl5) {
            ((LightDatabase)typeModifiers).save(this.getOid(), object);
        }
        this.inSave = false;
        if (bl4) {
            this.setId((Dataholder)object5);
            this.save(bl2);
        }
        if (bl5) {
            if (bl7) {
                ((LightDatabase)typeModifiers).myAdapter().clearStreamHandler(this);
            } else {
                this.afterSave((Dataholder)object5, bl2);
            }
        } else if (bl6) {
            this.addStateInvalidated();
            this.unswizzlePojo();
        }
        return 1;
    }

    private void checkCollectionOldValue(ColumnBasedField columnBasedField, Object object) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        if (object.equals(UNCHANGED)) {
            this.markDirty(n);
            return;
        }
        this.assertNotClosed();
        Dataholder dataholder = (Dataholder)this.getInternalCachedValue(columnBasedField);
        if (dataholder == null) {
            this.markDirty(n);
            return;
        }
        QuickCollectionObject quickCollectionObject = (QuickCollectionObject)dataholder.getObject();
        Object object2 = quickCollectionObject.getSerialValue();
        if (object.equals(object2)) {
            return;
        }
        if (SysListProxy.getBinaryLength(object) == 0 && NULL_SYS_LIST.equals(object2)) {
            return;
        }
        this.markDirty(n);
    }

    private static boolean isMutable(Object object) throws CacheException {
        if (object == null) {
            return false;
        }
        if (object instanceof Dataholder) {
            int n = ((Dataholder)object).getType();
            if (n == 384 || n == 385) {
                return true;
            }
            object = ((Dataholder)object).getObject();
        }
        if (object == null) {
            return false;
        }
        return object instanceof SList;
    }

    private void markDirty(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 1);
    }

    protected void makeDirty(int n) {
        this.mFieldState[n] = 1;
    }

    private void markSaved(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 8);
    }

    private void clearSaved(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] & 0xFFFFFFF7);
    }

    private void makeRefDirty(int n) {
        this.mFieldState[n] = 2;
    }

    private void makeClean(int n) {
        this.mFieldState[n] = 0;
    }

    private void checkBeforeInvalidate(int n) {
        if (Logger.debugOn() && this.isDirty(n) && !this.isSaved(n)) {
            String string;
            Object object;
            try {
                int n2;
                if (n == this.mClass.getIdField().getColumnIndexForSet()) {
                    return;
                }
                if (this.mClass.isChild() && n == (n2 = ((ColumnBasedField)this.mClass.getParentField()).getColumnIndexForSet())) {
                    return;
                }
                object = this.mClass.getSQLTableMetadata().getColumn(n).getField();
                if (object instanceof ColumnOnlyField) {
                    return;
                }
                if (object instanceof ChildTableField) {
                    return;
                }
                string = object.getName();
            }
            catch (Exception exception) {
                string = "column #" + n;
            }
            object = new CacheException("Invalidating dirty property: " + this.mClass.getName() + "[" + string + "]");
            ((Throwable)object).printStackTrace(Logger.out);
        }
    }

    private void invalidate(int n, boolean bl) {
        if (bl) {
            this.checkBeforeInvalidate(n);
        }
        this.clearSaved(n);
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 4);
    }

    private boolean isDirty(int n) {
        return (this.mFieldState[n] & 1) != 0;
    }

    private boolean isSaved(int n) {
        return (this.mFieldState[n] & 8) != 0;
    }

    private boolean isValid(int n) {
        return (this.mFieldState[n] & 4) == 0;
    }

    private boolean isRefDirty(int n) {
        byte by = this.mFieldState[n];
        return (by & 1) != 0 || (by & 2) != 0;
    }

    protected Iterator getAllProperties() throws CacheException {
        HashMap<String, Dataholder> hashMap = new HashMap<String, Dataholder>(this.mClass.getNumberOfColumnsForSet());
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            Dataholder dataholder;
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null || columnBasedField.getColumnIndexForGet() <= 0 || columnBasedField.equals(this.mClass.getIdField()) || (dataholder = this.getProperty(columnBasedField)) == null) continue;
            hashMap.put(columnBasedField.getName(), dataholder);
        }
        return hashMap.entrySet().iterator();
    }

    protected void objectDeleted() throws CacheException {
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField.getColumnIndexForSet() == 0) continue;
            Dataholder dataholder = this.getProperty(columnBasedField);
            this.setProperty(columnBasedField, dataholder, false, true);
        }
        this.setId(Dataholder.create(null));
        this.mFieldValues = null;
        this.addStateInvalidated();
    }

    protected void setId(Dataholder dataholder) throws CacheException {
        String string;
        ColumnBasedField columnBasedField = this.mClass.getIdField();
        String string2 = this.mClass.getName();
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        Dataholder dataholder2 = this.getProperty(columnBasedField);
        if (dataholder2 != null && dataholder2.equals(dataholder)) {
            return;
        }
        if (dataholder2 != null && (string = dataholder2.getString()) != null) {
            lightDatabase.removeFromMap(string2, string);
        }
        this.setCachedId(dataholder);
        if (dataholder != null && dataholder.getObject() != null) {
            lightDatabase.addToMap(this, null, string2, dataholder.getString());
        }
    }

    protected void setKeyValues(CandidateKey candidateKey) throws CacheException {
        SQLColumn[] sQLColumnArray = candidateKey.getMetadata().getColumns();
        if (sQLColumnArray == null || sQLColumnArray.length == 0) {
            return;
        }
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            Id id;
            SQLColumn sQLColumn = sQLColumnArray[i];
            ColumnBasedField columnBasedField = (ColumnBasedField)sQLColumn.getField();
            Dataholder dataholder = this.getProperty(columnBasedField);
            String string = dataholder == null ? null : (dataholder.getObject() instanceof Persistent ? ((id = ((Persistent)dataholder.getObject()).getId()) == null ? null : id.toString()) : dataholder.toString());
            candidateKey.set(i, string);
        }
    }

    public void afterSave(Dataholder dataholder, boolean bl) throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        lightDatabase.myAdapter().clearStreamHandler(this);
        this.invalidate(dataholder, bl, true);
        this.mState &= 0xFFFF00EF;
    }

    public void invalidate(boolean bl) throws CacheException {
        if ((this.mState & 0xFF02) == 65282) {
            return;
        }
        this.invalidate(null, true, bl);
    }

    private void setStateInvalidated() {
        this.mState = 65282;
    }

    private void addStateInvalidated() {
        this.mState |= 0xFF02;
    }

    private void clearStateInvalidated() {
        this.mState &= 0xFFFF00FD;
    }

    protected synchronized void invalidate(Dataholder dataholder, boolean bl, boolean bl2) throws CacheException {
        ColumnBasedField columnBasedField;
        if (dataholder == null) {
            dataholder = this.getProperty(this.mClass.getIdField());
        }
        this.mFieldValues = null;
        if (!this.mStorage.isReusable()) {
            this.replaceStorage();
        }
        this.assertNotClosed();
        int n = 0;
        Object object = this.mClass.getAllSettableFieldsIterator();
        while (object.hasNext()) {
            columnBasedField = (ColumnBasedField)object.next();
            if (n != columnBasedField.getColumnIndexForSet()) {
                throw new SystemError("Expected column " + n + ", instead got " + columnBasedField.getColumnIndexForSet());
            }
            Object object2 = this.getInternalCachedValue(columnBasedField);
            if (object2 instanceof Dataholder) {
                object2 = ((Dataholder)object2).getObject();
            }
            if (object2 instanceof QuickCollectionObject) {
                this.invalidate(n, bl2);
            } else {
                boolean bl3;
                boolean bl4 = bl3 = !bl && this.isRefDirty(n);
                if (bl2) {
                    this.checkBeforeInvalidate(n);
                }
                this.mFieldState[n] = 4;
                if (bl3) {
                    int n2 = n;
                    this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 2);
                }
            }
            ++n;
        }
        this.setProperty(this.mClass.getIdField(), dataholder, false, false);
        this.makeClean(this.mClass.getIdField().getColumnIndexForSet());
        if (this.cachedValuesNotNull() && (object = this.mClass.getVersionPropertyName()) != null) {
            columnBasedField = (ColumnBasedField)this.mClass.getField((String)object);
            this.getProperty(columnBasedField);
        }
        this.addStateInvalidated();
        this.unswizzlePojo();
    }

    private void unswizzlePojo() throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        DetachedObjectsManager detachedObjectsManager = lightDatabase.getDetachedObjectsManagerIfExists();
        if (detachedObjectsManager != null) {
            Object object = detachedObjectsManager.findPOJO(this.getOid(), true);
            ObjectFactory.unswizzle(object);
        }
    }

    @Override
    public Dataholder getProperty(String string, boolean bl) throws CacheException {
        ColumnBasedField columnBasedField = (ColumnBasedField)this.mClass.getField(string);
        return this.getProperty(columnBasedField);
    }

    protected Dataholder getProperty(ColumnBasedField columnBasedField) throws CacheException {
        Dataholder dataholder;
        Object object;
        this.assertNotClosed();
        int n = columnBasedField.getColumnIndexForSet();
        boolean bl = this.mClass.getIdField().getColumnIndexForSet() == n;
        Object object2 = object = bl ? this.getCachedId() : this.getInternalCachedValue(columnBasedField);
        if (object != null && object != UNCHANGED && this.isValid(n)) {
            return (Dataholder)object;
        }
        if (this.mFieldValues == null && (dataholder = this.getCachedId()) != null && dataholder.getObject() != null) {
            this.mFieldValues = ((LightDatabase)this.getDatabase()).loadObject(dataholder.getString(), this.mClass);
            this.clearStateInvalidated();
            this.mLoadMethod = 7502;
            this.mState |= 0xFF01;
        }
        int n2 = columnBasedField.getColumnIndexForGet();
        if (!this.isValid(n)) {
            this.makeClean(n);
        }
        if (columnBasedField.isEmbedded()) {
            object = this.getEmbeddedObject(columnBasedField);
        } else {
            if (n2 < 0 && columnBasedField.getChildTableName() == null) {
                throw new CacheException("Property " + columnBasedField.getName() + " of class " + this.mClass.getName() + " can not be accessed " + "with Quick interface");
            }
            if (this.mFieldValues == null && columnBasedField.getCollectionType() != 0) {
                object = SerialStorage.newCollection(columnBasedField);
                this.makeRefDirty(n);
            } else if (this.mFieldValues == null) {
                object = new Dataholder();
            } else {
                if (columnBasedField.isCollection() || columnBasedField.isStream()) {
                    try {
                        object = this.getCollection(columnBasedField);
                        this.makeRefDirty(n);
                    }
                    catch (SQLException sQLException) {
                        if (Logger.debugOn()) {
                            sQLException.printStackTrace(Logger.out);
                        }
                        throw new CacheException(sQLException, "Failed to get collection or stream for field " + columnBasedField.getName());
                    }
                }
                if (columnBasedField.isObject()) {
                    return this.getReferenceObject(columnBasedField, n2, n);
                }
                try {
                    Object object3 = SysListProxy.getWrappedItem(this.mFieldValues, n2 - 1);
                    object = columnBasedField.getTypeName().equals("%Library.List") ? QuickPersistentObject.getSList(object3) : new Dataholder(4096, object3);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                catch (SQLException sQLException) {
                    throw new CacheException(sQLException, "Failed to get property " + columnBasedField.getName());
                }
            }
        }
        if (bl) {
            this.setCachedId((Dataholder)object);
        } else {
            this.setCachedValue(columnBasedField, object, false);
        }
        return (Dataholder)object;
    }

    private static Dataholder getSList(Object object) throws SQLException {
        Object object2;
        try {
            object2 = SysListProxy.getSysList(object);
            SysListProxy.countItems(object2);
        }
        catch (Exception exception) {
            String string = SysListProxy.getString(object, 0);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            object2 = SysListProxy.createSysList();
            while (stringTokenizer.hasMoreTokens()) {
                SysListProxy.setString(object2, stringTokenizer.nextToken());
            }
        }
        return new Dataholder(384, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedValue(ColumnBasedField columnBasedField, Object object, boolean bl) throws CacheException {
        Object object2;
        Object object3;
        Object object4 = object3 = bl ? this.getCachedId() : this.getInternalCachedValue(columnBasedField);
        if (object3 != null && object != null && object3.equals(object)) {
            return;
        }
        if (object3 != null && object3 instanceof Dataholder) {
            object2 = ((Dataholder)object3).getObject();
            if (object2 instanceof QuickPersistentObject) {
                ((QuickPersistentObject)object2).decreaseCount();
            } else if (object2 instanceof QuickReaderObject) {
                ((QuickReaderObject)object2).close();
            }
        }
        if (object != null && object instanceof Dataholder && (object2 = ((Dataholder)object).getObject()) instanceof QuickPersistentObject) {
            LightDatabase lightDatabase;
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)object2;
            LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
            synchronized (lightDatabase2) {
                if (quickPersistentObject.isClosed()) {
                    Oid oid = quickPersistentObject.getOid();
                    quickPersistentObject = (QuickPersistentObject)lightDatabase.openCacheObject(oid, -1, 0);
                    object = new Dataholder(quickPersistentObject);
                }
                quickPersistentObject.increaseCount();
            }
        }
        if (bl) {
            this.setCachedId((Dataholder)object);
        } else {
            this.setInternalCachedValue(columnBasedField, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void increaseCount() throws CacheException {
        LightDatabase lightDatabase;
        if (!this.getCacheClass().isPersistent()) {
            super.increaseCount();
            return;
        }
        LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
        synchronized (lightDatabase2) {
            Object object = this.getZRef();
            Object object2 = lightDatabase.isInCache(object);
            if (object2 == null) {
                if (!this.mStorage.isReusable()) throw new IllegalStateException("Increasing count on closed object");
                this.registerInDbCache();
            } else if (object2 != this && object2 != object) {
                throw new IllegalStateException("Increasing count on closed object");
            }
            super.increaseCount();
            return;
        }
    }

    private void registerInDbCache() throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        lightDatabase.addToMap(this, null, this.getCacheClass().getName(), this.getIdValue());
    }

    @Override
    public void setProperty(String string, Dataholder dataholder) throws CacheException {
        ColumnBasedField columnBasedField = (ColumnBasedField)this.mClass.getField(string);
        this.setProperty(columnBasedField, dataholder, true, true);
    }

    protected void setProperty(ColumnBasedField columnBasedField, Dataholder dataholder, boolean bl, boolean bl2) throws CacheException {
        Object object;
        boolean bl3 = this.isId(columnBasedField);
        if (columnBasedField.isEmbedded() && !bl3) {
            this.setEmbeddedObject(columnBasedField, dataholder);
        } else if (columnBasedField.getCollectionType() != 0) {
            this.setCollection(columnBasedField, dataholder);
        }
        int n = columnBasedField.getColumnIndexForSet();
        this.assertNotClosed();
        boolean bl4 = false;
        if (this.mStorage.isReusable()) {
            Object object2 = object = bl3 ? this.getCachedId() : this.getInternalCachedValue(columnBasedField);
            if (object == null) {
                if (dataholder != null) {
                    bl4 = true;
                }
            } else if (!object.equals(dataholder)) {
                bl4 = true;
            }
        } else {
            bl4 = true;
        }
        if (bl4) {
            if (bl3) {
                this.setCachedId(dataholder);
            } else {
                this.setCachedValue(columnBasedField, dataholder, false);
            }
            if (bl) {
                this.mState |= 0xFF10;
                this.makeDirty(n);
            }
        }
        if (!bl4 || !bl2 || dataholder == null || dataholder.getObject() == null) {
            return;
        }
        object = columnBasedField.getInverseFieldName();
        if (object == null) {
            return;
        }
        if (columnBasedField.isRelationship()) {
            return;
        }
        if (dataholder.getType() == 1028) {
            return;
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)dataholder.getCacheObject();
        CacheField cacheField = quickPersistentObject.getCacheClass().getField((String)object);
        Dataholder dataholder2 = quickPersistentObject.getProperty((ColumnBasedField)cacheField);
        RelationshipObject relationshipObject = (RelationshipObject)dataholder2.getCollection();
        relationshipObject.add(this.newJavaInstance(true));
    }

    private void setEmbeddedObject(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        QuickEmbeddedObject quickEmbeddedObject = (QuickEmbeddedObject)dataholder.getCacheObject();
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        if (quickEmbeddedObject != null) {
            quickEmbeddedObject.onSetStore(this, columnBasedField, tableBasedClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataholder getReferenceObject(ColumnBasedField columnBasedField, int n, int n2) throws CacheException {
        String string;
        try {
            string = SysListProxy.getString(this.mFieldValues, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not get id of object at field " + columnBasedField.getName());
        }
        if (string == null) {
            return new Dataholder();
        }
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            CacheObject cacheObject = this.getDatabase().openCacheObject(columnBasedField.getTypeName(), string);
            cacheObject.assertNotClosed(true);
            Dataholder dataholder = new Dataholder(cacheObject);
            this.setCachedValue(columnBasedField, dataholder, false);
            this.makeRefDirty(n2);
            cacheObject.assertNotClosed(false);
            return dataholder;
        }
    }

    private void setCollection(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        this.setCachedValue(columnBasedField, dataholder, false);
        this.makeDirty(n);
    }

    private List emptyList(ColumnBasedField columnBasedField, int n) throws CacheException {
        ArrayList arrayList = this.prepareEmptyList(columnBasedField);
        if (arrayList != null) {
            arrayList.clear();
        } else {
            arrayList = new ArrayList(n);
        }
        return arrayList;
    }

    private List emptyLazyList(ColumnBasedField columnBasedField, LazyList.Initializer initializer, LazyList.Transformer transformer) throws CacheException {
        List list = this.prepareEmptyList(columnBasedField);
        if (list != null) {
            list.clear();
            if (list instanceof LazyList) {
                ((LazyList)list).setInitializer(initializer);
            }
        } else {
            list = new LazyList(initializer, transformer);
        }
        return list;
    }

    private List prepareEmptyList(ColumnBasedField columnBasedField) throws CacheException {
        this.assertNotClosed();
        Object object = this.getInternalCachedValue(columnBasedField);
        if (object instanceof Dataholder) {
            object = ((Dataholder)object).getObject();
        }
        if (object instanceof QuickCollectionObject) {
            object = ((QuickCollectionObject)object).getCollection();
        }
        return (List)object;
    }

    private Map emptyMap(ColumnBasedField columnBasedField, int n) throws CacheException {
        HashMap hashMap;
        this.assertNotClosed();
        Object object = this.getInternalCachedValue(columnBasedField);
        if (object instanceof Dataholder) {
            object = ((Dataholder)object).getObject();
        }
        if (object instanceof QuickCollectionObject) {
            object = ((QuickCollectionObject)object).getCollection();
        }
        if ((hashMap = (HashMap)object) != null) {
            hashMap.clear();
        } else {
            hashMap = new HashMap(n);
        }
        return hashMap;
    }

    private Dataholder getCollection(ColumnBasedField columnBasedField) throws CacheException, SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        block54: {
            object5 = null;
            int n = columnBasedField.getColumnIndexForGet();
            int n2 = columnBasedField.getCollectionType();
            String string2 = columnBasedField.getElementTypeName();
            string = columnBasedField.getChildTableName();
            LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
            object4 = null;
            if (string == null) {
                object4 = SysListProxy.getWrappedItem(this.mFieldValues, n - 1);
            } else if (!columnBasedField.isRelationship() && !lightDatabase.isClassRegistered(string)) {
                lightDatabase.createQuickCacheClass(columnBasedField);
            }
            int n3 = columnBasedField.getElementType();
            int n4 = -1;
            if (!TypeModifierHelper.isStream(n2) && n3 == 256 && string2 != null && !string2.endsWith("String")) {
                object3 = columnBasedField.getJavaTypeName();
                if ((object3 = Dataholder.elementType((String)object3)) == null) {
                    object3 = this.getDatabase().getCacheClass(string2).getJavaClassName();
                }
                n4 = Dataholder.toIntType((String)object3);
            }
            object3 = (TableBasedClass)columnBasedField.getType();
            if (string != null && columnBasedField.isList()) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyList(columnBasedField, ((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object object6;
                    Object e = iterator.next();
                    if (e instanceof QuickStatement.ChildTableRow) {
                        QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                        object6 = childTableRow.data;
                    } else {
                        object6 = e;
                    }
                    this.processRefListElem((List)object, columnBasedField, string2, n3, n4, object6);
                }
                object5 = object;
            } else if (string != null && n2 == 19) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyList(columnBasedField, ((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                    Object object7 = childTableRow.data;
                    this.processRefListElem((List)object, columnBasedField, string2, n3, n4, object7);
                }
                object5 = object;
            } else if (string != null && n2 == 21) {
                object5 = this.getMany(columnBasedField, string2);
            } else if (string != null && n2 == 1) {
                object2 = this.getArrayOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyMap(columnBasedField, ((HashMap)object2).size());
                int n5 = lightDatabase.getKeyColumn(string);
                block16: for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    Object v = entry.getValue();
                    if (v instanceof QuickStatement.ChildTableRow) {
                        object11 = (QuickStatement.ChildTableRow)v;
                        object10 = n5 == 0 ? ((QuickStatement.ChildTableRow)object11).data : entry.getKey();
                        object9 = n5 == 0 ? entry.getKey() : ((QuickStatement.ChildTableRow)object11).data;
                        object8 = ((QuickStatement.ChildTableRow)object11).data;
                        if (SysListProxy.isValidSysList(object10) && object9 instanceof String) {
                            Object object12 = object10;
                            object10 = object9;
                            object9 = object12;
                        }
                    } else {
                        object10 = entry.getKey();
                        object8 = object9 = v;
                    }
                    switch (n3) {
                        case 256: {
                            if (n4 > 0) {
                                object11 = Dataholder.create(object9);
                                object9 = ((Dataholder)object11).getObject(n4);
                            }
                            object.put(object10, object9);
                            continue block16;
                        }
                        case 4608: {
                            object11 = object9.toString();
                            object.put(object10, this.getObjectInCollection((String)object11, string2));
                            continue block16;
                        }
                        case 8704: {
                            SysListProxy.rewind(object9);
                            object.put(object10, this.getObjectInCollection(object8, string2, string));
                            continue block16;
                        }
                    }
                    throw new CacheException("Unsupported collection element type");
                }
                object5 = object;
            } else if (columnBasedField.isList() && this.mLoadMethod == 7506) {
                try {
                    object5 = SerialStorage.getSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    this.mLoadMethod = 7502;
                }
                catch (Exception exception) {
                    SysListProxy.rewind(object4);
                    object5 = SerialStorage.getCommaSeparatedSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    this.mLoadMethod = 7501;
                    object4 = lightDatabase.wrapPrimList((List)object5);
                }
            } else {
                if (columnBasedField.isList() && this.mLoadMethod == 7502) {
                    try {
                        object5 = SerialStorage.getSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().startsWith("Incorrect list")) {
                            SysListProxy.rewind(object4);
                            object5 = SerialStorage.getCommaSeparatedSerialList(null, this.getDatabase(), string2, n3, object4, n4);
                            object4 = lightDatabase.wrapPrimList((List)object5);
                        }
                        break block54;
                    }
                    catch (SystemError systemError) {
                        if (systemError.getCode() == -9001) {
                            SysListProxy.rewind(object4);
                            object5 = SerialStorage.getCommaSeparatedSerialList(null, this.getDatabase(), string2, n3, object4, n4);
                            object4 = lightDatabase.wrapPrimList((List)object5);
                            this.mLoadMethod = 7501;
                        }
                        break block54;
                    }
                }
                if (columnBasedField.isList() && this.mLoadMethod == 7501) {
                    object5 = SerialStorage.getCommaSeparatedSerialList(null, this.getDatabase(), string2, n3, object4, n4);
                    object4 = lightDatabase.wrapPrimList((List)object5);
                } else if (n2 == 1 && this.mLoadMethod == 7501) {
                    object5 = SerialStorage.getCommaSeparatedSerialArray(null, this.getDatabase(), string2, n3, object4, n4);
                } else if (n2 == 1 && this.mLoadMethod == 7506) {
                    try {
                        object5 = SerialStorage.getCommaSeparatedSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                        this.mLoadMethod = 7501;
                    }
                    catch (Exception exception) {
                        object5 = SerialStorage.getSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                        this.mLoadMethod = 7502;
                    }
                } else if (n2 == 1 && this.mLoadMethod == 7502) {
                    object5 = SerialStorage.getSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                } else {
                    if (n2 == 32) {
                        InputStream inputStream = null;
                        try {
                            inputStream = ((LightDatabase)this.getDatabase()).getJDBCBinaryStream(object4);
                        }
                        catch (SQLException sQLException) {
                            inputStream = null;
                        }
                        QuickStreamObject quickStreamObject = new QuickStreamObject((TableBasedClass)object3, inputStream, new ByteArrayOutputStream());
                        return new Dataholder(quickStreamObject);
                    }
                    if (n2 == 64) {
                        Reader reader = ((LightDatabase)this.getDatabase()).getJDBCCharacterStream(object4);
                        QuickReaderObject quickReaderObject = new QuickReaderObject((TableBasedClass)object3, reader, new CharArrayWriter());
                        return new Dataholder(quickReaderObject);
                    }
                    throw new CacheException("Unsupported collection type: " + n2);
                }
            }
        }
        if (columnBasedField.isRelationship()) {
            object2 = new QuickRelationshipObject((TableBasedClass)object3, object5);
        } else {
            object2 = new QuickCollectionObject((TableBasedClass)object3, object5);
            if (string == null) {
                ((QuickCollectionObject)object2).setSerialValue(object4);
            }
        }
        object = new Dataholder((CacheObject)object2);
        return object;
    }

    private void processRefListElem(List list, ColumnBasedField columnBasedField, String string, int n, int n2, Object object) throws CacheException, SQLException {
        switch (n) {
            case 256: {
                if (n2 > 0) {
                    Dataholder dataholder = Dataholder.create(object);
                    object = dataholder.getObject(n2);
                }
                list.add(object);
                break;
            }
            case 4608: {
                String string2 = (String)object;
                list.add(this.getObjectInCollection(string2, string));
                break;
            }
            case 8704: {
                SysListProxy.rewind(object);
                list.add(this.getObjectInCollection(object, string, columnBasedField.getChildTableName()));
                break;
            }
            default: {
                throw new CacheException("Unsupported collection element type");
            }
        }
    }

    private List getMany(ColumnBasedField columnBasedField, String string) throws CacheException {
        String string2 = columnBasedField.getInverseFieldName();
        String string3 = columnBasedField.getInverseColumnName();
        String string4 = string3 + " = ? ";
        Object[] objectArray = new String[]{this.getId().toString()};
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        OMRelationshipObjectTransformer oMRelationshipObjectTransformer = new OMRelationshipObjectTransformer(this, string2);
        LazyQueryInitializer lazyQueryInitializer = new LazyQueryInitializer(string, string4, (String[])objectArray);
        boolean bl = columnBasedField.getFetchPolicy() == 1;
        List list = !bl && lightDatabase.allowLazyCollections() ? this.emptyLazyList(columnBasedField, lazyQueryInitializer, oMRelationshipObjectTransformer) : this.emptyList(columnBasedField, 0);
        if (list instanceof LazyList) {
            lazyQueryInitializer.setCountSQL(string3 + " = '" + (String)objectArray[0] + "'");
        } else {
            Iterator iterator = lightDatabase.openByQuery(string, string4, objectArray);
            while (iterator.hasNext()) {
                Object object = iterator.next();
                object = oMRelationshipObjectTransformer.transform(object);
                list.add(object);
            }
        }
        return list;
    }

    private ArrayList getListOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new ArrayList();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        ArrayList arrayList = lightDatabase.getListOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return arrayList;
    }

    private HashMap getArrayOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new HashMap();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        HashMap hashMap = lightDatabase.getArrayOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInCollection(Object object, String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = ((LightDatabase)this.getDatabase()).getCacheClass(string, string2);
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            QuickPersistentObject quickPersistentObject = this.instantiate(tableBasedClass, object, 7502);
            quickPersistentObject.assertNotClosed(true);
            Object object2 = quickPersistentObject.newJavaInstance(true);
            quickPersistentObject.assertNotClosed(false);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInCollection(String string, String string2) throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            CacheObject cacheObject = this.getDatabase().openCacheObject(string2, string);
            cacheObject.assertNotClosed(true);
            Object object = cacheObject.newJavaInstance(true);
            cacheObject.assertNotClosed(false);
            return object;
        }
    }

    private Dataholder getEmbeddedObject(ColumnBasedField columnBasedField) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        QuickEmbeddedObject quickEmbeddedObject = new QuickEmbeddedObject(tableBasedClass, this, columnBasedField);
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        return new Dataholder(quickEmbeddedObject);
    }

    private static void logData(Object object) {
        try {
            SysListProxy.rewind(object);
            int n = 1;
            while (!SysListProxy.atEnd(object)) {
                Logger.out.println("\t" + n + ":\t" + SysListProxy.getObject(object));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            Logger.out.println("Exception caught " + sQLException.getMessage());
        }
    }

    protected boolean cachedValuesNotNull() {
        return this.mStorage.cachedValuesNotNull();
    }

    protected Object getInternalCachedValue(ColumnBasedField columnBasedField) throws CacheException {
        return this.mStorage.getInternalCachedValue(columnBasedField);
    }

    protected void setInternalCachedValue(ColumnBasedField columnBasedField, Object object) throws CacheException {
        this.mStorage.setInternalCachedValue(columnBasedField, object);
    }

    protected void initCachedValues() throws CacheException {
        this.mStorage.initCachedValues();
    }

    protected void cleanupCachedValues() {
        if (this.mStorage.isReusable() && this.cachedValuesNotNull()) {
            int n = 0;
            Iterator iterator = this.mClass.getAllSettableFieldsIterator();
            while (iterator.hasNext()) {
                ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
                try {
                    boolean bl = this.isId(columnBasedField);
                    this.setCachedValue(columnBasedField, null, bl);
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                this.mFieldState[n] = 4;
                ++n;
            }
            this.mStorage.cleanupCachedValues();
        } else {
            this.replaceStorage();
        }
    }

    private void replaceStorage() {
        try {
            this.setCleanStorage(new ArrayBackedStorage(this));
        }
        catch (CacheException cacheException) {
            throw new IllegalStateException(cacheException.getMessage());
        }
    }

    protected QuickPersistentObject instantiate(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        return this.mStorage.instantiate(tableBasedClass, object, n);
    }

    protected void setCachedId(Dataholder dataholder) throws CacheException {
        this.mStorage.setCachedId(dataholder);
    }

    public void setCachedIdToNull() throws CacheException {
        this.setCachedId(Dataholder.create(null));
    }

    protected Dataholder getCachedId() throws CacheException {
        return this.mStorage.getCachedId();
    }

    private boolean isId(ColumnBasedField columnBasedField) throws CacheException {
        int n = this.mClass.getIdField().getColumnIndexForGet();
        if (columnBasedField.getColumnIndexForGet() != n) {
            return false;
        }
        n = this.mClass.getIdField().getColumnIndexForSet();
        return columnBasedField.getColumnIndexForSet() == n;
    }

    static {
        try {
            SysListProxy.setString(NULL_SYS_LIST, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static interface LocalStorage {
        public boolean cachedValuesNotNull();

        public Object getInternalCachedValue(ColumnBasedField var1) throws CacheException;

        public void setInternalCachedValue(ColumnBasedField var1, Object var2) throws CacheException;

        public void initCachedValues() throws CacheException;

        public void cleanupCachedValues();

        public QuickPersistentObject instantiate(TableBasedClass var1, Object var2, int var3) throws CacheException;

        public Dataholder getCachedId() throws CacheException;

        public void setCachedId(Dataholder var1) throws CacheException;

        public boolean isReusable();
    }

    private static class OMRelationshipObjectTransformer
    implements LazyList.Transformer {
        private String inverse;
        private Dataholder me;

        public OMRelationshipObjectTransformer(CacheObject cacheObject, String string) throws CacheException {
            this.me = new Dataholder(cacheObject);
            this.inverse = string;
        }

        @Override
        public Object transform(Object object) throws CacheException {
            if (object instanceof PersistentWrapper) {
                PersistentWrapper persistentWrapper = (PersistentWrapper)object;
                ColumnBasedField columnBasedField = (ColumnBasedField)persistentWrapper.getCacheClass().getField(this.inverse);
                ((QuickPersistentObject)persistentWrapper.getProxy()).setProperty(columnBasedField, this.me, false, false);
            } else {
                Persistent persistent = (Persistent)object;
                ColumnBasedField columnBasedField = (ColumnBasedField)persistent.getCacheClass().getField(this.inverse);
                if (!this.me.getCacheObject().isClosed()) {
                    ((QuickPersistentObject)persistent.getProxy()).setProperty(columnBasedField, this.me, false, false);
                }
            }
            return object;
        }
    }

    private class LazyQueryInitializer
    implements LazyList.Initializer {
        private String elemClassName;
        private String sql;
        private String[] args;
        private String countSQL;
        private DataSource mDataSource;
        private Connection mCon;

        public LazyQueryInitializer(String string, String string2, String[] stringArray) {
            this.args = stringArray;
            this.elemClassName = string;
            this.sql = string2;
        }

        public void setCountSQL(String string) {
            this.countSQL = string;
        }

        @Override
        public Iterator init() throws Exception {
            LightDatabase lightDatabase = this.getDB();
            Iterator iterator = lightDatabase.openByQuery(this.elemClassName, this.sql, (Object[])this.args);
            return iterator;
        }

        @Override
        public synchronized void postInit(LazyList lazyList) throws Exception {
            boolean bl = this.mCon != null;
            int n = bl ? 100 : 10;
            lazyList.fetchNext(n);
            if (!lazyList.isLoaded()) {
                LightDatabase lightDatabase = this.getDB();
                int n2 = lightDatabase.countObjects(this.elemClassName, this.countSQL);
                if (n2 < n) {
                    throw new SystemError("Inconsistent list size: " + n2);
                }
                lazyList.setSize(n2);
                if (bl) {
                    this.close();
                }
            } else {
                this.close();
            }
        }

        @Override
        public synchronized void injectData(Object object) {
            if (object instanceof DataSource) {
                this.mDataSource = (DataSource)object;
            }
        }

        private synchronized LightDatabase getDB() throws CacheException, SQLException {
            LightDatabase lightDatabase = (LightDatabase)QuickPersistentObject.this.getDatabase();
            if (lightDatabase.isOpen()) {
                return lightDatabase;
            }
            if (this.mDataSource == null) {
                throw new IllegalStateException("Database Connection is closed.");
            }
            if (this.mCon == null) {
                this.mCon = this.mDataSource.getConnection();
            }
            return (LightDatabase)CacheDatabase.getLightDatabase(this.mCon);
        }

        private synchronized void close() throws SQLException {
            if (this.mCon != null) {
                this.mCon.close();
            }
            this.mCon = null;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

