/*
 * Decompiled with CFR 0.152.
 */
package com.intersys;

import java.net.InetAddress;
import java.util.StringTokenizer;

public class MachineInfo {
    private static final String loopBackAddress = "127.0.0.1";
    private static String exeName = "java.exe";
    private static String ipAddress;
    private static String[] ipAddressArray;
    private static String hostName;
    private static String myUserName;
    private static byte[] osInfo;

    private static void setIPAddress() {
        InetAddress[] inetAddressArray = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getHostName();
            ipAddress = inetAddress.getHostAddress();
            inetAddressArray = InetAddress.getAllByName(hostName);
            ipAddressArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                MachineInfo.ipAddressArray[i] = inetAddressArray[i].getHostAddress();
            }
        }
        catch (Exception exception) {
            hostName = "localhost";
            ipAddress = loopBackAddress;
            ipAddressArray = new String[1];
            MachineInfo.ipAddressArray[0] = loopBackAddress;
        }
    }

    public static String getIPAddress(String string) {
        if (string.regionMatches(0, loopBackAddress, 0, 4)) {
            return loopBackAddress;
        }
        for (int i = 0; i < ipAddressArray.length; ++i) {
            if (!ipAddressArray[i].regionMatches(0, string, 0, ipAddressArray[i].length())) continue;
            return loopBackAddress;
        }
        return ipAddress;
    }

    public static String getUserName() {
        return myUserName;
    }

    private static void setUserName() {
        myUserName = System.getProperty("user.name");
    }

    public static String getMachineName() {
        return hostName;
    }

    public static String getExeName() {
        return exeName;
    }

    private static void setExeName() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        exeName = stackTraceElementArray[stackTraceElementArray.length - 1].getClassName();
    }

    public static byte[] getOSInfo() {
        return osInfo;
    }

    private static void setOSInfo() {
        short s = 0;
        short s2 = 0;
        String string = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                s = Short.parseShort(stringTokenizer.nextToken());
                break;
            }
            catch (Exception exception) {
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                s2 = Short.parseShort(stringTokenizer.nextToken());
                break;
            }
            catch (Exception exception) {
            }
        }
        MachineInfo.osInfo[0] = (byte)(s & 0xFF);
        MachineInfo.osInfo[1] = (byte)(s >> 8);
        MachineInfo.osInfo[2] = (byte)(s2 & 0xFF);
        MachineInfo.osInfo[3] = (byte)(s2 >> 8);
        String string2 = System.getProperty("os.name");
        int n = string2.equalsIgnoreCase("Windows 95") ? 1 : (string2.equalsIgnoreCase("Windows 98") ? 1 : (string2.equalsIgnoreCase("Windows ME") ? 1 : (string2.equalsIgnoreCase("Windows NT") ? 2 : (string2.equalsIgnoreCase("Windows 2000") ? 2 : (string2.equalsIgnoreCase("Windows XP") ? 2 : (string2.regionMatches(true, 0, "Windows", 0, 7) ? 2 : (string2.equalsIgnoreCase("AIX") ? 64 : (string2.equalsIgnoreCase("Digital Unix") ? 65 : (string2.equalsIgnoreCase("FreeBSD") ? 66 : (string2.equalsIgnoreCase("HP-UX") ? 67 : (string2.equalsIgnoreCase("Linux") ? 68 : (string2.equalsIgnoreCase("Solaris") ? 69 : (string2.equalsIgnoreCase("Irix") ? 70 : (string2.equalsIgnoreCase("Mac OS") ? 71 : (string2.equalsIgnoreCase("OS/2") ? 78 : 255)))))))))))))));
        MachineInfo.osInfo[8] = (byte)(n & 0xFF);
        MachineInfo.osInfo[9] = (byte)(n >> 8);
        String string3 = System.getProperty("os.arch");
        int n2 = string3.equalsIgnoreCase("x86") ? 0 : (string3.equalsIgnoreCase("Pentium") ? 0 : (string3.equalsIgnoreCase("Alpha") ? 1 : (string3.equalsIgnoreCase("MIPS") ? 2 : (string3.regionMatches(true, 0, "Power", 0, 5) ? 3 : (string3.equalsIgnoreCase("sparc") ? 16 : (string3.equalsIgnoreCase("PA-RISC") ? 17 : 255))))));
        MachineInfo.osInfo[10] = (byte)(n2 & 0xFF);
        MachineInfo.osInfo[11] = (byte)(n2 >> 8);
    }

    public static void main(String[] stringArray) {
        System.out.print("\nMachineInfo class\n");
        String string = MachineInfo.getIPAddress("192.168.1.101");
        System.out.print("\n" + string + "\n");
        System.out.print("\nUser Name: " + MachineInfo.getUserName() + "\n");
        System.out.print("\nHost Name: " + MachineInfo.getMachineName() + "\n");
        System.out.print("\nInitial Class Application Name: " + MachineInfo.getExeName() + "\n");
    }

    static {
        ipAddressArray = null;
        osInfo = new byte[12];
        MachineInfo.setExeName();
        MachineInfo.setOSInfo();
        MachineInfo.setIPAddress();
        MachineInfo.setUserName();
    }
}

