/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.dbeaver.ee.scmp.SCMPConstants;
import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPInput;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizard;
import com.dbeaver.ee.scmp.ui.wizard.SchemaMappingDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.Scope;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import liquibase.license.LocationType;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.utils.CommonUtils;

class SchemaComparePageInput
extends ActiveWizardPage<SchemaCompareWizard> {
    private static final Log log = Log.getLog(SchemaComparePageInput.class);
    private DatabaseNavigatorTree sourceTree;
    private DatabaseNavigatorTree targetTree;
    private CMPOptions cmpOptions;
    private SelectDataSourceCombo sourceDSSelectCombo;
    private SelectDataSourceCombo targetDSSelectCombo;

    SchemaComparePageInput(SchemaCompareWizard wizard) {
        super("Input objects");
        this.setTitle(wizard.getOptions().getTargetInput() == null ? LBMessages.wizard_schema_compare_input_title_specify_objects : String.valueOf(LBMessages.wizard_schema_compare_input_title_specify_input) + LBMessages.wizard_schema_compare_input_title_migration);
        String description = String.valueOf(LBMessages.wizard_schema_compare_input_title_specify_input) + LBMessages.wizard_schema_compare_input_title_migration;
        description = String.valueOf(description) + LBMessages.wizard_schema_compare_input_title_specify_description;
        this.setDescription(description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        boolean doDiff = ((SchemaCompareWizard)this.getWizard()).getTargetInput() != null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite sourceTargetPanel = UIUtils.createComposite((Composite)composite, (int)(doDiff ? 2 : 1));
        sourceTargetPanel.setLayoutData((Object)new GridData(1808));
        sourceTargetPanel.setLayout((Layout)new FillLayout());
        CustomSashForm panelDivider = UIUtils.createPartDivider((IWorkbenchPart)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart(), (Composite)sourceTargetPanel, (int)256);
        this.sourceTree = this.createObjectSelectorPanel((Composite)panelDivider, LBMessages.wizard_schema_compare_input_panel_title_source, ((SchemaCompareWizard)this.getWizard()).getSourceInput(), true);
        if (doDiff) {
            this.targetTree = this.createObjectSelectorPanel((Composite)panelDivider, LBMessages.wizard_schema_compare_input_panel_title_target, ((SchemaCompareWizard)this.getWizard()).getTargetInput(), false);
        }
        if (doDiff) {
            Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)4);
            ((GridLayout)settingsPanel.getLayout()).horizontalSpacing = 20;
            UIUtils.createControlLabel((Composite)settingsPanel, (String)LBMessages.wizard_schema_compare_input_panel_title_settings, (int)4);
            Composite optionsGroup = UIUtils.createComposite((Composite)settingsPanel, (int)4);
            this.cmpOptions = ((SchemaCompareWizard)this.getWizard()).getOptions();
            DBPPreferenceStore globalPreferences = DBWorkbench.getPlatform().getPreferenceStore();
            this.checkLBLicense(globalPreferences);
            this.checkLBLogLevel(globalPreferences);
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_create_objects, (String)LBMessages.wizard_schema_compare_input_options_create_objects_tip, (boolean)this.cmpOptions.isDoCreate(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.cmpOptions.setDoCreate(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_alter_objects, (String)LBMessages.wizard_schema_compare_input_options_alter_objects_tip, (boolean)this.cmpOptions.isDoChange(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.cmpOptions.setDoChange(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_drop_objects, (String)LBMessages.wizard_schema_compare_input_options_drop_objects_tip, (boolean)this.cmpOptions.isDoDrop(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.cmpOptions.setDoDrop(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive_tip, (boolean)this.cmpOptions.isCaseInsensitiveCompare(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.cmpOptions.setCaseInsensitiveCompare(((Button)e.widget).getSelection());
                }
            });
            Composite buttonsGroup = UIUtils.createComposite((Composite)settingsPanel, (int)3);
            buttonsGroup.setLayoutData((Object)new GridData(2));
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)LBMessages.wizard_schema_compare_input_schema_mapping, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.showSchemaMappings();
                }
            });
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)LBMessages.wizard_schema_compare_input_object_types, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.showComparisonObjectsTypes();
                }
            });
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)LBMessages.wizard_schema_compare_button_preferences, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.showPreferencesFor((Shell)SchemaComparePageInput.this.getShell(), null, (String[])new String[]{"com.dbeaver.ee.scmp.ui.preferencePages.page.schemaCompare"});
                }
            });
            Composite switchGroup = UIUtils.createComposite((Composite)settingsPanel, (int)1);
            switchGroup.setLayoutData((Object)new GridData(128));
            UIUtils.createPushButton((Composite)switchGroup, (String)LBMessages.wizard_schema_compare_input_push_button_swap_sources, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.LINK_TO_EDITOR), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.swapSources();
                }
            });
        }
        this.setControl((Control)composite);
    }

    private void checkLBLicense(DBPPreferenceStore globalPreferences) {
        String property = System.getProperty("liquibase.license.key");
        String licenseInPreferences = globalPreferences.getString("@dbeaver-prop-lb-lic@");
        if (CommonUtils.isNotEmpty((String)property)) {
            this.checkLicenseState(property);
        } else if (CommonUtils.isNotEmpty((String)licenseInPreferences)) {
            this.checkLicenseState(licenseInPreferences);
        }
    }

    private void checkLBLogLevel(DBPPreferenceStore globalPreferences) {
        SCMPConstants.LogLevels logLevel = (SCMPConstants.LogLevels)CommonUtils.valueOf(SCMPConstants.LogLevels.class, (String)globalPreferences.getString("@dbeaver-prop-lb-log-level@"), (Enum)SCMPConstants.LogLevels.OFF);
        this.cmpOptions.setLogLevel(logLevel);
    }

    private boolean checkLicenseState(String key) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, key);
        LicenseInstallResult licenseInstallResult = licenseService.installLicense(new Location[]{licenseKeyLocation});
        if (licenseInstallResult.code == 0) {
            this.cmpOptions.setHasLiquibaseLicense(true);
            return true;
        }
        return false;
    }

    private void swapSources() {
        SchemaCompareWizard compareWizard = (SchemaCompareWizard)this.getWizard();
        if (this.cmpOptions != null) {
            CMPInput targetInput = this.cmpOptions.getTargetInput();
            CMPInput sourceInput = this.cmpOptions.getSourceInput();
            if (targetInput != null) {
                this.cmpOptions.setSourceInput(targetInput);
                compareWizard.setSourceInput(targetInput);
                this.cmpOptions.setTargetInput(sourceInput);
                compareWizard.setTargetInput(sourceInput);
                this.cmpOptions.refreshSchemaMappings(true);
            }
        }
        DBNNode sourceTreeModel = this.sourceTree.getModel();
        Object[] sourceCheckedElements = this.sourceTree.getCheckboxViewer().getCheckedElements();
        Object[] sourceExpandedElements = this.sourceTree.getViewer().getExpandedElements();
        DBNNode targetTreeModel = this.targetTree.getModel();
        Object[] targetCheckedElements = this.targetTree.getCheckboxViewer().getCheckedElements();
        Object[] targetExpandedElements = this.targetTree.getViewer().getExpandedElements();
        this.sourceTree.setInput(targetTreeModel);
        this.sourceTree.getCheckboxViewer().setCheckedElements(targetCheckedElements);
        this.targetTree.setInput(sourceTreeModel);
        this.targetTree.getCheckboxViewer().setCheckedElements(sourceCheckedElements);
        this.sourceTree.getViewer().setExpandedElements(targetExpandedElements);
        this.targetTree.getViewer().setExpandedElements(sourceExpandedElements);
        this.sourceTree.redraw();
        this.targetTree.redraw();
        if (compareWizard.getTargetInput() != null) {
            this.sourceDSSelectCombo.select((Object)compareWizard.getSourceInput().getDataSourceContainer());
            this.targetDSSelectCombo.select((Object)compareWizard.getTargetInput().getDataSourceContainer());
            this.sourceDSSelectCombo.redraw();
            this.targetDSSelectCombo.redraw();
        }
    }

    private void showSchemaMappings() {
        SchemaMappingDialog dialog = new SchemaMappingDialog(this.getShell(), ((SchemaCompareWizard)this.getWizard()).getOptions());
        dialog.open();
    }

    private void showComparisonObjectsTypes() {
        SchemaCompareExcludeObjectsDialog dialog = new SchemaCompareExcludeObjectsDialog(this.getShell(), LBMessages.wizard_schema_compare_input_object_types, null);
        dialog.open();
    }

    private void createEngineSelector(Composite settingsGroup, final CMPOptions cmpOptions) {
        final Combo engineCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"Diff Engine", (String)"Diff engine", (int)12);
        engineCombo.setLayoutData((Object)new GridData(32));
        for (SCMPDiffEngineDescriptor diffEngine : SCMPEngineRegistry.getInstance().getDiffEngines()) {
            engineCombo.add(diffEngine.getLabel());
        }
        if (!CommonUtils.isEmpty((String)cmpOptions.getDiffEngineId())) {
            engineCombo.setText(cmpOptions.getDiffEngineId());
        }
        if (engineCombo.getSelectionIndex() < 0) {
            engineCombo.select(0);
        }
        engineCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cmpOptions.setDiffEngineId(((SCMPDiffEngineDescriptor)SCMPEngineRegistry.getInstance().getDiffEngines().get(engineCombo.getSelectionIndex())).getId());
            }
        });
    }

    private DatabaseNavigatorTree createObjectSelectorPanel(Composite parent, String panelTitle, CMPInput input, boolean showSchemaObjects) {
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        Composite dsPanel = UIUtils.createComposite((Composite)group, (int)2);
        dsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)dsPanel, (String)panelTitle);
        SelectDataSourceCombo dsSelectCombo = new SelectDataSourceCombo(dsPanel){

            protected DBPProject getActiveProject() {
                return ((SchemaCompareWizard)SchemaComparePageInput.this.getWizard()).getProject();
            }
        };
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        dsSelectCombo.setLayoutData((Object)gd);
        dsSelectCombo.addProjectDataSources();
        ObjectNavigatorFilter filter = new ObjectNavigatorFilter(showSchemaObjects);
        DatabaseNavigatorTree dataSourceTree = new DatabaseNavigatorTree(group, null, 2084, true, (INavigatorFilter)filter);
        gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.minimumWidth = 200;
        dataSourceTree.setLayoutData((Object)gd);
        dataSourceTree.setFilterObjectType(DatabaseNavigatorTreeFilterObjectType.container);
        DataSourceSelectListener dsSelectListener = new DataSourceSelectListener(dataSourceTree, input);
        dsSelectCombo.addSelectionListener((DBRRunnableParametrized)dsSelectListener);
        dsSelectCombo.select((Object)input.getDataSourceContainer());
        if (showSchemaObjects) {
            this.sourceDSSelectCombo = dsSelectCombo;
        } else {
            this.targetDSSelectCombo = dsSelectCombo;
        }
        dsSelectListener.loadObjects(input.getDataSourceContainer());
        CheckboxTreeViewer treeViewer = (CheckboxTreeViewer)dataSourceTree.getViewer();
        treeViewer.addCheckStateListener((ICheckStateListener)new ObjectsStateListener(treeViewer, input));
        List inputObjects = input.getInputObjects();
        if (!CommonUtils.isEmpty((Collection)inputObjects)) {
            treeViewer.getControl().setRedraw(false);
            try {
                Iterator iterator = inputObjects.iterator();
                while (iterator.hasNext()) {
                    DBSObject object = (DBSObject)iterator.next();
                    DBNDatabaseNode objectNode = DBNUtils.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)object, (boolean)false);
                    if (objectNode != null && this.isSelectableNode(objectNode)) {
                        if (object instanceof DBSObjectContainer) {
                            treeViewer.setGrayChecked((Object)objectNode, true);
                        } else {
                            treeViewer.setChecked((Object)objectNode, true);
                        }
                        treeViewer.reveal((Object)objectNode);
                        continue;
                    }
                    iterator.remove();
                }
            }
            finally {
                treeViewer.getControl().setRedraw(true);
            }
        }
        return dataSourceTree;
    }

    private boolean isSelectableNode(DBNDatabaseNode node) {
        Object valueObject;
        if (node instanceof DBNDatabaseFolder) {
            Class folderChildren = ((DBNDatabaseFolder)node).getChildrenClass();
            return folderChildren != null && DBSEntity.class.isAssignableFrom(folderChildren);
        }
        if (node instanceof DBNDataSource && (valueObject = node.getValueObject()) instanceof DBSObjectContainer) {
            try {
                return DBSTable.class.isAssignableFrom(((DBSObjectContainer)valueObject).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.debug((Object)"Can't find primary child type", (Throwable)e);
                return false;
            }
        }
        DBSObject object = node.getObject();
        if (object instanceof DBSEntity) {
            return true;
        }
        if (object instanceof DBSObjectContainer) {
            try {
                Class childType = ((DBSObjectContainer)object).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor());
                return childType != null && DBSEntity.class.isAssignableFrom(childType);
            }
            catch (DBException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return false;
    }

    private void checkInputObject(List<DBSObject> inputObjects, DBSObject object) throws CMPException {
        DBSInstance newInstance = DBUtils.getObjectOwnerInstance((DBSObject)object);
        if (!(newInstance instanceof JDBCRemoteInstance)) {
            throw new CMPException("Only JDBC connections can be compared");
        }
        if (inputObjects.isEmpty()) {
            return;
        }
        DBSInstance curInstance = DBUtils.getObjectOwnerInstance((DBSObject)inputObjects.get(0));
        if (curInstance != newInstance) {
            throw new CMPException("You can't select objects which belong to different physical connections (" + curInstance.getName() + ", " + newInstance.getName() + ")");
        }
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        boolean doDiff;
        if (!((SchemaCompareWizard)this.getWizard()).getSourceInput().isValid()) {
            this.setErrorMessage("You must specify at least one input object");
            return false;
        }
        boolean bl = doDiff = ((SchemaCompareWizard)this.getWizard()).getTargetInput() != null;
        if (doDiff && !((SchemaCompareWizard)this.getWizard()).getTargetInput().isValid()) {
            this.setErrorMessage("You must specify at least one target schema");
            return false;
        }
        if (((SchemaCompareWizard)this.getWizard()).isSrcSameAsTarget()) {
            this.setErrorMessage("Source and target schema(s) must be different");
            return false;
        }
        if (!((SchemaCompareWizard)this.getWizard()).isValidMapping()) {
            this.setErrorMessage("Number of input schemas don't match target schemas");
            return false;
        }
        this.setErrorMessage(null);
        if (doDiff) {
            ((SchemaCompareWizard)this.getWizard()).getOptions().refreshSchemaMappings(false);
        }
        return true;
    }

    private class DataSourceSelectListener
    implements DBRRunnableParametrized<DBPDataSourceContainer> {
        private final DatabaseNavigatorTree dataSourceTree;
        private final CMPInput input;

        DataSourceSelectListener(DatabaseNavigatorTree dataSourceTree, CMPInput input) {
            this.dataSourceTree = dataSourceTree;
            this.input = input;
        }

        public void run(DBPDataSourceContainer selectedDataSource) {
            this.input.setInputObjects(new ArrayList());
            this.input.setDataSourceContainer(selectedDataSource);
            this.loadObjects(selectedDataSource);
        }

        void loadObjects(DBPDataSourceContainer selectedDataSource) {
            DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
            DBNDatabaseNode dsNode = selectedDataSource == null ? null : model.getNodeByObject((DBSObject)selectedDataSource);
            this.dataSourceTree.setInput((DBNNode)dsNode);
            this.dataSourceTree.getViewer().expandToLevel(2);
            TreeItem topItem = this.dataSourceTree.getViewer().getTree().getTopItem();
            if (topItem != null && topItem.getItemCount() == 1) {
                this.dataSourceTree.getViewer().expandToLevel(1);
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }
    }

    private static class ObjectNavigatorFilter
    extends DatabaseNavigatorTreeFilter {
        private final boolean showSchemaObjects;

        public ObjectNavigatorFilter(boolean showSchemaObjects) {
            this.showSchemaObjects = showSchemaObjects;
        }

        public boolean filterFolders() {
            return true;
        }

        public boolean isLeafObject(Object object) {
            if (object instanceof DBNDatabaseNode) {
                DBNDatabaseNode databaseNode = (DBNDatabaseNode)object;
                DBSObject dbObject = databaseNode.getObject();
                if (!this.showSchemaObjects) {
                    if (dbObject instanceof DBSSchema) {
                        DBXTreeNode meta = databaseNode.getMeta();
                        return !DBNNode.nodeHasStructureContainers((DBNNode)databaseNode, (DBXTreeNode)meta);
                    }
                    if (dbObject instanceof DBSCatalog) {
                        try {
                            Class childType = ((DBSCatalog)dbObject).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor());
                            if (!DBSSchema.class.isAssignableFrom(childType)) {
                                return true;
                            }
                        }
                        catch (DBException e) {
                            log.debug((Object)e);
                        }
                    }
                }
                if (dbObject instanceof DBSEntityAttribute) {
                    return true;
                }
            }
            return false;
        }

        public boolean select(Object element) {
            DBSObject object;
            if (element instanceof DBNDatabaseFolder) {
                Class folderChildren = ((DBNDatabaseFolder)element).getChildrenClass();
                if (folderChildren == null) {
                    return false;
                }
                if (!this.isGoodClass(folderChildren)) {
                    return false;
                }
            } else if (element instanceof DBNDatabaseNode && !this.isGoodClass((object = ((DBNDatabaseNode)element).getObject()).getClass())) {
                return false;
            }
            return true;
        }

        private boolean isGoodClass(Class<? extends DBSObject> folderChildren) {
            if (!this.showSchemaObjects) {
                return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
            }
            return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSEntity.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
        }
    }

    private class ObjectsStateListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer treeViewer;
        private final CMPInput input;

        public ObjectsStateListener(CheckboxTreeViewer treeViewer, CMPInput input) {
            this.treeViewer = treeViewer;
            this.input = input;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean isFolder;
            Object element = event.getElement();
            if (!(element instanceof DBNDatabaseNode)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                return;
            }
            if (!SchemaComparePageInput.this.isSelectableNode((DBNDatabaseNode)element)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                UIUtils.showMessageBox((Shell)SchemaComparePageInput.this.getShell(), (String)"Wrong node", (String)("You can't select item '" + element + "' (" + ((DBNDatabaseNode)element).getNodeType() + "). Only tables or table containers are allowed."), (int)8);
                return;
            }
            boolean bl = isFolder = element instanceof DBNDatabaseFolder || ((DBNDatabaseNode)element).getObject() instanceof DBSObjectContainer;
            if (event.getChecked()) {
                this.treeViewer.setGrayed(element, isFolder);
            }
            List inputObjects = this.input.getInputObjects();
            if (element instanceof DBNDatabaseFolder) {
                this.toggleFolderObjects((DBNDatabaseFolder)element, event.getChecked());
            } else {
                DBSObject object = ((DBNDatabaseNode)element).getObject();
                if (event.getChecked()) {
                    if (!inputObjects.contains(object)) {
                        try {
                            SchemaComparePageInput.this.checkInputObject(this.input.getInputObjects(), object);
                            this.input.getInputObjects().add(object);
                        }
                        catch (Exception e) {
                            this.treeViewer.setChecked(element, false);
                            DBWorkbench.getPlatformUI().showError("Wrong object", "You can't add object [" + object.getName() + "]", (Throwable)e);
                        }
                    }
                } else {
                    this.input.getInputObjects().remove(object);
                }
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }

        private void toggleFolderObjects(DBNDatabaseFolder folder, boolean checked) {
            try {
                SchemaComparePageInput.this.getContainer().run(false, true, monitor -> {
                    try {
                        DBNDatabaseNode[] children = folder.getChildren((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                        if (children != null) {
                            List inputObjects = this.input.getInputObjects();
                            DBNDatabaseNode[] dBNDatabaseNodeArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                                DBSObject object = child.getObject();
                                SchemaComparePageInput.this.checkInputObject(this.input.getInputObjects(), object);
                                if (checked) {
                                    inputObjects.add(object);
                                } else {
                                    inputObjects.remove(object);
                                }
                                ++n2;
                            }
                            UIUtils.asyncExec(() -> {
                                DBNDatabaseNode[] dBNDatabaseNodeArray2 = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DBNDatabaseNode child = dBNDatabaseNodeArray2[n2];
                                    this.treeViewer.setChecked((Object)child, checked);
                                    ++n2;
                                }
                            });
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class SchemaCompareExcludeObjectsDialog
    extends BaseDialog {
        private Tree tree;
        private TreeItem tableItem;
        private TreeItem columnItem;
        private TreeItem pkItem;
        private TreeItem ukItem;
        private TreeItem fkItem;
        private TreeItem indexItem;
        private TreeItem viewItem;
        private TreeItem sequenceItem;
        private TreeItem triggerItem;
        private TreeItem functionItem;
        private TreeItem procedureItem;
        private TreeItem packageItem;
        private TreeItem checkConstraintItem;
        private TreeItem synonymItem;
        Set<Class<? extends DatabaseObject>> excludedObjectsSet;
        final List<Class<? extends DatabaseObject>> tableChildClasses;

        SchemaCompareExcludeObjectsDialog(Shell parentShell, @Nullable String title, DBPImage icon) {
            super(parentShell, title, icon);
            this.excludedObjectsSet = new HashSet<Class<? extends DatabaseObject>>();
            this.tableChildClasses = new ArrayList<Class<? extends DatabaseObject>>();
            this.tableChildClasses.add(Column.class);
            this.tableChildClasses.add(PrimaryKey.class);
            this.tableChildClasses.add(UniqueConstraint.class);
            this.tableChildClasses.add(ForeignKey.class);
            this.tableChildClasses.add(Index.class);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
            GridData gd = new GridData(1808);
            gd.widthHint = 300;
            gd.heightHint = 200;
            composite.setLayoutData((Object)gd);
            this.tree = new Tree(composite, 67616);
            this.tree.setLayoutData((Object)new GridData(1808));
            this.tableItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_tables);
            this.columnItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_columns);
            this.pkItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_pk);
            this.ukItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_uk);
            this.fkItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_fk);
            this.indexItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_indexes);
            this.tableItem.setExpanded(true);
            this.viewItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_views);
            this.sequenceItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_sequences);
            if (SchemaComparePageInput.this.cmpOptions.isHasLiquibaseLicense()) {
                this.triggerItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_triggers);
                this.functionItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_functions);
                this.procedureItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_procedures);
                this.packageItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_packages);
                this.synonymItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_synonyms);
                this.checkConstraintItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_check_constraints);
            }
            UIUtils.createLabel((Composite)composite, (String)LBMessages.wizard_schema_compare_input_object_types_tip);
            this.tree.setVisible(true);
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32 && e.item instanceof TreeItem) {
                        TreeItem checkedItem = (TreeItem)e.item;
                        boolean checked = checkedItem.getChecked();
                        if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.tableItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Table.class);
                            if (!checked) {
                                TreeItem[] treeItemArray = SchemaCompareExcludeObjectsDialog.this.tableItem.getItems();
                                int n = treeItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TreeItem childItem = treeItemArray[n2];
                                    childItem.setChecked(false);
                                    ++n2;
                                }
                                for (Class<? extends DatabaseObject> type : SchemaCompareExcludeObjectsDialog.this.tableChildClasses) {
                                    SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(false, type);
                                }
                            }
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.columnItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Column.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.pkItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, PrimaryKey.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.ukItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, UniqueConstraint.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.fkItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, ForeignKey.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.indexItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Index.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.viewItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, View.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.triggerItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Trigger.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.functionItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Function.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.procedureItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, StoredProcedure.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.packageItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, DatabasePackage.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.synonymItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Synonym.class);
                        } else if (checkedItem.equals(SchemaCompareExcludeObjectsDialog.this.checkConstraintItem)) {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, CheckConstraint.class);
                        } else {
                            SchemaCompareExcludeObjectsDialog.this.changeObjectsTypeSet(checked, Sequence.class);
                        }
                    }
                }
            });
            SchemaComparePageInput.this.cmpOptions.setExcludedObjectTypes(this.excludedObjectsSet);
            return dialogArea;
        }

        private void changeObjectsTypeSet(boolean checked, Class<? extends DatabaseObject> typeClass) {
            if (!checked) {
                this.excludedObjectsSet.add(typeClass);
            } else {
                this.excludedObjectsSet.removeIf(o -> o.equals(typeClass));
            }
        }

        private TreeItem createCheckedTreeItem(String text) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(text);
            item.setChecked(true);
            return item;
        }

        private TreeItem createCheckedTableChildTreeItem(String text) {
            TreeItem item = new TreeItem(this.tableItem, 0);
            item.setText(text);
            item.setChecked(true);
            return item;
        }
    }
}

