/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DatabaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class LiquibaseHanaUtil {
    private static final ReadWriteLock COLUMN_DATA_TYPE_CACHE_LOCK = new ReentrantReadWriteLock();
    private static final Map<String, Map<String, Map<String, DatabaseDataType>>> COLUMN_DATA_TYPE_CACHE = new HashMap<String, Map<String, Map<String, DatabaseDataType>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseDataType getColumnDataType(String catalog, String schema, String table, String column, Database database) {
        String columnName;
        String tableName;
        String schemaName;
        block13: {
            String catalogName = catalog == null ? database.getDefaultCatalogName() : database.correctObjectName(catalog, Catalog.class);
            schemaName = schema == null ? database.getDefaultSchemaName() : database.correctObjectName(schema, Schema.class);
            tableName = database.correctObjectName(table, Table.class);
            columnName = database.correctObjectName(column, Column.class);
            DatabaseConnection databaseConnection = database.getConnection();
            if (databaseConnection instanceof JdbcConnection) {
                JdbcConnection connection = (JdbcConnection)databaseConnection;
                try (ResultSet rs = connection.getMetaData().getColumns(catalogName, schemaName, tableName, columnName);){
                    DatabaseDataType dataTypeFromCache;
                    if (!rs.next()) break block13;
                    String typeName = rs.getString(6);
                    String columnSize = rs.getString(7);
                    String decimalDigits = rs.getString(9);
                    DatabaseDataType dataType = decimalDigits == null ? new DatabaseDataType(typeName, new Object[]{columnSize}) : new DatabaseDataType(typeName, new Object[]{columnSize, decimalDigits});
                    if (LiquibaseHanaUtil.equals(dataType, dataTypeFromCache = LiquibaseHanaUtil.getColumnDataTypeFromCache(schemaName, tableName, columnName))) break block13;
                    COLUMN_DATA_TYPE_CACHE_LOCK.writeLock().lock();
                    try {
                        dataTypeFromCache = LiquibaseHanaUtil.getColumnDataTypeFromCache(schemaName, tableName, columnName);
                        if (!LiquibaseHanaUtil.equals(dataType, dataTypeFromCache)) {
                            LiquibaseHanaUtil.addColumnDataTypeToCache(schemaName, tableName, columnName, dataType);
                        }
                    }
                    finally {
                        COLUMN_DATA_TYPE_CACHE_LOCK.writeLock().unlock();
                    }
                }
                catch (SQLException | DatabaseException e) {
                    Scope.getCurrentScope().getLog(LiquibaseHanaUtil.class).info("Could not get column information for column \"" + columnName + "\" of table \"" + schemaName + "\".\"" + tableName + "\"", e);
                }
            }
        }
        return LiquibaseHanaUtil.getColumnDataTypeFromCache(schemaName, tableName, columnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTableStore(String schema, String table, Database database) {
        String schemaName = schema == null ? database.getDefaultSchemaName() : database.correctObjectName(schema, Schema.class);
        String tableName = database.correctObjectName(table, Table.class);
        DatabaseConnection databaseConnection = database.getConnection();
        if (!(databaseConnection instanceof JdbcConnection)) return null;
        JdbcConnection connection = (JdbcConnection)databaseConnection;
        try (PreparedStatement ps = connection.prepareStatement("SELECT TABLE_TYPE FROM SYS.TABLES WHERE SCHEMA_NAME=? AND TABLE_NAME=?");){
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException | DatabaseException e) {
            Scope.getCurrentScope().getLog(LiquibaseHanaUtil.class).info("Could not get table type information for table \"" + schemaName + "\".\"" + tableName + "\"", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatabaseDataType getColumnDataTypeFromCache(String schema, String table, String column) {
        COLUMN_DATA_TYPE_CACHE_LOCK.readLock().lock();
        try {
            Map<String, Map<String, DatabaseDataType>> schemaMap = COLUMN_DATA_TYPE_CACHE.get(schema);
            if (schemaMap == null) {
                DatabaseDataType databaseDataType = null;
                return databaseDataType;
            }
            Map<String, DatabaseDataType> tableMap = schemaMap.get(table);
            if (tableMap == null) {
                DatabaseDataType databaseDataType = null;
                return databaseDataType;
            }
            DatabaseDataType databaseDataType = tableMap.get(column);
            return databaseDataType;
        }
        finally {
            COLUMN_DATA_TYPE_CACHE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addColumnDataTypeToCache(String schema, String table, String column, DatabaseDataType columnDataType) {
        COLUMN_DATA_TYPE_CACHE_LOCK.writeLock().lock();
        try {
            Map<String, DatabaseDataType> tableMap;
            Map<String, Map<String, DatabaseDataType>> schemaMap = COLUMN_DATA_TYPE_CACHE.get(schema);
            if (schemaMap == null) {
                schemaMap = new HashMap<String, Map<String, DatabaseDataType>>();
                COLUMN_DATA_TYPE_CACHE.put(schema, schemaMap);
            }
            if ((tableMap = schemaMap.get(table)) == null) {
                tableMap = new HashMap<String, DatabaseDataType>();
                schemaMap.put(table, tableMap);
            }
            tableMap.put(column, columnDataType);
        }
        finally {
            COLUMN_DATA_TYPE_CACHE_LOCK.writeLock().unlock();
        }
    }

    private static boolean equals(DatabaseDataType d1, DatabaseDataType d2) {
        return d1 == null && d2 == null || d1 != null && d2 != null && Objects.equals(d1.toString(), d2.toString());
    }
}

