/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.sqlgenerator;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.ext.hana.HanaDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropColumnGenerator;
import liquibase.statement.core.DropColumnStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

public class DropColumnGeneratorHana
extends DropColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DropColumnStatement statement, Database database) {
        return database instanceof HanaDatabase;
    }

    public Sql[] generateSql(DropColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ");
        ArrayList<Column> affectedColumns = new ArrayList<Column>();
        if (statement.isMultiple()) {
            boolean firstColumn = true;
            for (DropColumnStatement s : statement.getColumns()) {
                if (firstColumn) {
                    sb.append(database.escapeTableName(s.getCatalogName(), s.getSchemaName(), s.getTableName()));
                    sb.append(" DROP (");
                } else {
                    sb.append(",");
                }
                sb.append(database.escapeColumnName(s.getCatalogName(), s.getSchemaName(), s.getTableName(), s.getColumnName()));
                firstColumn = false;
                affectedColumns.add(this.getAffectedColumn(s));
            }
        } else {
            sb.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
            sb.append(" DROP (");
            sb.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()));
            affectedColumns.add(this.getAffectedColumn(statement));
        }
        sb.append(")");
        return new Sql[]{new UnparsedSql(sb.toString(), (DatabaseObject[])affectedColumns.toArray(new Column[affectedColumns.size()]))};
    }
}

